/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.data.build.binddata.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonArrayMergerUtil {
    private static Logger logger = LoggerFactory.getLogger(JsonArrayMergerUtil.class);

    public static JSONArray merge(JSONArray arrayA, JSONArray arrayB) {
        JSONArray result = new JSONArray();
        int maxLength = Math.max(arrayA.size(), arrayB.size());
        JSONObject templateA = JsonArrayMergerUtil.generateTemplate(arrayA);
        JSONObject templateB = JsonArrayMergerUtil.generateTemplate(arrayB);
        for (int i = 0; i < maxLength; ++i) {
            JSONObject merged = new JSONObject();
            if (i < arrayB.size()) {
                JsonArrayMergerUtil.copyJsonObject(merged, arrayB.getJSONObject(i));
            } else {
                JsonArrayMergerUtil.copyJsonObject(merged, templateB);
            }
            if (i < arrayA.size()) {
                JsonArrayMergerUtil.copyJsonObject(merged, arrayA.getJSONObject(i));
            } else {
                JsonArrayMergerUtil.copyJsonObject(merged, templateA);
            }
            result.add((Object)merged);
        }
        return result;
    }

    private static JSONObject generateTemplate(JSONArray array) {
        JSONObject template = new JSONObject();
        if (array.size() == 0) {
            return template;
        }
        try {
            JSONObject sample = array.getJSONObject(0);
            for (String key : sample.keySet()) {
                Object value = sample.get((Object)key);
                if (value instanceof JSONArray) {
                    template.put(key, (Object)JsonArrayMergerUtil.generateArrayTemplate((JSONArray)value));
                    continue;
                }
                template.put(key, (Object)"");
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u7ec4\u8f6c\u6362\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return template;
    }

    private static JSONArray generateArrayTemplate(JSONArray array) {
        JSONArray template = new JSONArray();
        if (array.size() == 0) {
            return template;
        }
        try {
            Object first = array.get(0);
            if (first instanceof JSONObject) {
                JSONArray jsonArray = new JSONArray();
                jsonArray.add(first);
                JSONObject objTemplate = JsonArrayMergerUtil.generateTemplate(jsonArray);
                template.add((Object)objTemplate);
            } else {
                template.add((Object)"");
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u7ec4\u8f6c\u6362\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return template;
    }

    private static void copyJsonObject(JSONObject target, JSONObject source) {
        for (String key : source.keySet()) {
            try {
                Object value = source.get((Object)key);
                if (value instanceof JSONObject) {
                    JSONObject newObj = new JSONObject();
                    JsonArrayMergerUtil.copyJsonObject(newObj, (JSONObject)value);
                    target.put(key, (Object)newObj);
                    continue;
                }
                if (value instanceof JSONArray) {
                    target.put(key, (Object)JsonArrayMergerUtil.copyJsonArray((JSONArray)value));
                    continue;
                }
                target.put(key, value);
            }
            catch (Exception e) {
                logger.error("\u6570\u7ec4\u8f6c\u6362\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private static JSONArray copyJsonArray(JSONArray source) {
        JSONArray copy = new JSONArray();
        for (int i = 0; i < source.size(); ++i) {
            try {
                Object item = source.get(i);
                if (item instanceof JSONObject) {
                    JSONObject objCopy = new JSONObject();
                    JsonArrayMergerUtil.copyJsonObject(objCopy, (JSONObject)item);
                    copy.add((Object)objCopy);
                    continue;
                }
                copy.add(item);
                continue;
            }
            catch (Exception e) {
                logger.error("\u6570\u7ec4\u8f6c\u6362\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
        return copy;
    }
}

