/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.data.build.binddata.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class DataBindUtil {
    public static JSONArray convert(JSONObject input) {
        if (input == null) {
            return new JSONArray();
        }
        HashMap<String, JSONArray> convertedArrays = new HashMap<String, JSONArray>();
        int maxLength = 0;
        for (String key : input.keySet()) {
            Object value = input.get((Object)key);
            JSONArray arrayValue = DataBindUtil.convertToJsonArray(value);
            convertedArrays.put(key, arrayValue);
            maxLength = Math.max(maxLength, arrayValue.size());
        }
        JSONArray resultArray = new JSONArray();
        for (int i = 0; i < maxLength; ++i) {
            JSONObject newObj = new JSONObject();
            for (String key : input.keySet()) {
                JSONArray values = (JSONArray)convertedArrays.get(key);
                Object val = i < values.size() ? values.get(i) : null;
                newObj.put(key, val);
            }
            resultArray.add((Object)newObj);
        }
        return resultArray;
    }

    private static JSONArray convertToJsonArray(Object value) {
        if (value == null) {
            return new JSONArray();
        }
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        if (value instanceof Collection) {
            return new JSONArray((List)value);
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            JSONArray array = new JSONArray();
            for (int i = 0; i < length; ++i) {
                array.add(Array.get(value, i));
            }
            return array;
        }
        JSONArray singleValueArray = new JSONArray();
        singleValueArray.add(value);
        return singleValueArray;
    }

    public static JSONArray transform(JSONArray originalArray, String parentKey) {
        JSONArray result = new JSONArray();
        originalArray.forEach(item -> {
            JSONObject wrapper = new JSONObject();
            JSONArray innerArray = new JSONArray();
            innerArray.add((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)item)));
            wrapper.put(parentKey, (Object)innerArray);
            result.add((Object)wrapper);
        });
        return result;
    }
}

