/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.data.build.binddata.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.data.build.binddata.empty.BindDataCtx;
import com.jxdinfo.hussar.data.build.binddata.empty.BindDataSource;
import com.jxdinfo.hussar.data.build.binddata.empty.DataSourceDetail;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class BindDataSourceUtil {
    public static Object analysisBindDataSourceConfig(BindDataSource bindDataSource, BindDataCtx bindDataCtx) {
        String bindSourceType = bindDataSource.getBindSourceType();
        if (HussarUtils.isEmpty((Object)bindSourceType)) {
            return "";
        }
        if ("DataSet".equals(bindDataSource.getBindSourceType())) {
            DataSourceDetail dataSourceDetail = bindDataSource.getDataSourceDetail();
            if (HussarUtils.isEmpty((Object)dataSourceDetail.getBindWordDataSetId()) || HussarUtils.isEmpty(dataSourceDetail.getBindDataPath())) {
                return "";
            }
            String bindWordDataSetId = dataSourceDetail.getBindWordDataSetId();
            List<String> bindDataPath = dataSourceDetail.getBindDataPath();
            Map<String, Object> datasetData = bindDataCtx.getDatasetData();
            if (HussarUtils.isNotEmpty(datasetData) && HussarUtils.isNotEmpty((Object)datasetData.get(bindWordDataSetId))) {
                return BindDataSourceUtil.getPathDataOfDataType(bindDataPath, datasetData.get(bindWordDataSetId));
            }
        }
        return "";
    }

    public static Object getDataByPathOfBasic(BindDataSource bindDataSource, BindDataCtx bindDataCtx, Object duplicateAreaDirectDatum, String dupBindWordDataSetId, List<String> dupPath) {
        String bindSourceType = bindDataSource.getBindSourceType();
        if (HussarUtils.isEmpty((Object)bindSourceType)) {
            return "";
        }
        if ("DataSet".equals(bindDataSource.getBindSourceType())) {
            DataSourceDetail dataSourceDetail = bindDataSource.getDataSourceDetail();
            if (HussarUtils.isEmpty((Object)dataSourceDetail.getBindWordDataSetId()) || HussarUtils.isEmpty(dataSourceDetail.getBindDataPath())) {
                return "";
            }
            String bindWordDataSetId = dataSourceDetail.getBindWordDataSetId();
            if (HussarUtils.isNotEmpty((Object)bindWordDataSetId) && bindWordDataSetId.equals(dupBindWordDataSetId)) {
                List<String> bindDataPath = dataSourceDetail.getBindDataPath();
                if (HussarUtils.isNotEmpty(bindDataPath) && bindDataPath.size() > dupPath.size()) {
                    List<String> noPath = bindDataPath.subList(dupPath.size(), bindDataPath.size());
                    return BindDataSourceUtil.getDataByNoPathInAllData(noPath, duplicateAreaDirectDatum);
                }
                return BindDataSourceUtil.analysisBindDataSourceConfig(bindDataSource, bindDataCtx);
            }
            return BindDataSourceUtil.analysisBindDataSourceConfig(bindDataSource, bindDataCtx);
        }
        return "";
    }

    public static Object getDataByNoPathInAllData(List<String> noPath, Object duplicateAreaDataObj) {
        if (HussarUtils.isNotEmpty((Object)duplicateAreaDataObj)) {
            if (HussarUtils.isNotEmpty(noPath)) {
                ArrayList current = duplicateAreaDataObj;
                for (String pathKey : noPath) {
                    if (current == null) {
                        return "";
                    }
                    if (current instanceof Map) {
                        current = ((Map)((Object)current)).get(pathKey);
                        continue;
                    }
                    if (current instanceof List) {
                        List list = current;
                        try {
                            int index = Integer.parseInt(pathKey);
                            if (index >= 0 && index < list.size()) {
                                current = list.get(index);
                                continue;
                            }
                            return "";
                        }
                        catch (NumberFormatException e) {
                            if (!list.isEmpty() && list.get(0) instanceof Map) {
                                ArrayList resultList = new ArrayList();
                                for (Object item : list) {
                                    Object value = ((Map)item).get(pathKey);
                                    if (value == null) continue;
                                    resultList.add(value);
                                }
                                current = resultList;
                                continue;
                            }
                            return "";
                        }
                    }
                    return "";
                }
                return current;
            }
            return duplicateAreaDataObj;
        }
        return "";
    }

    private static Object getPathDataOfDataType(List<String> bindDataPath, Object data) {
        if (HussarUtils.isEmpty((Object)data) || HussarUtils.isEmpty(bindDataPath)) {
            return "";
        }
        int index = 2;
        return BindDataSourceUtil.extractValue(data, index, bindDataPath);
    }

    private static Object extractValue(Object object, int currentIndex, List<String> fromFields) {
        if (HussarUtils.isEmpty((Object)object) || HussarUtils.isEmpty(fromFields) || currentIndex >= fromFields.size()) {
            return null;
        }
        String fieldName = fromFields.get(currentIndex);
        Object parse = JSON.parse((String)object.toString());
        if (parse instanceof JSONObject) {
            JSONObject jsonObject = JSON.parseObject((String)object.toString());
            Object childObj = jsonObject.get((Object)fieldName);
            if (currentIndex == fromFields.size() - 1) {
                return childObj;
            }
            return BindDataSourceUtil.extractValue(childObj, ++currentIndex, fromFields);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        JSONArray jsonArray = JSON.parseArray((String)object.toString());
        if (currentIndex == fromFields.size() - 1) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Object childObj = jsonObject.get((Object)fieldName);
                list.add(childObj);
            }
        } else {
            ++currentIndex;
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Object childObj = jsonObject.get((Object)fieldName);
                BindDataSourceUtil.extractValueFromArray(childObj, currentIndex, fromFields, list);
            }
        }
        return list;
    }

    private static void extractValueFromArray(Object object, int currentIndex, List<String> fromFields, List<Object> list) {
        if (HussarUtils.isEmpty((Object)object) || HussarUtils.isEmpty(fromFields) || currentIndex >= fromFields.size()) {
            return;
        }
        String fieldName = fromFields.get(currentIndex);
        if (object instanceof JSONObject) {
            JSONObject jsonObject = JSON.parseObject((String)object.toString());
            Object childObj = jsonObject.get((Object)fieldName);
            if (currentIndex == fromFields.size() - 1) {
                list.add(childObj);
            } else {
                BindDataSourceUtil.extractValueFromArray(childObj, ++currentIndex, fromFields, list);
            }
        } else {
            Object childObj;
            JSONObject jsonObject;
            int i;
            JSONArray jsonArray = JSON.parseArray((String)object.toString());
            if (currentIndex == fromFields.size() - 1) {
                for (i = 0; i < jsonArray.size(); ++i) {
                    jsonObject = jsonArray.getJSONObject(i);
                    childObj = jsonObject.get((Object)fieldName);
                    list.add(childObj);
                }
            }
            ++currentIndex;
            for (i = 0; i < jsonArray.size(); ++i) {
                jsonObject = jsonArray.getJSONObject(i);
                childObj = jsonObject.get((Object)fieldName);
                BindDataSourceUtil.extractValueFromArray(childObj, currentIndex, fromFields, list);
            }
        }
    }

    private static Object getFieldValue(String fieldName, Object data) {
        JSONArray dataArray = JSON.parseArray((String)((String)data));
        return IntStream.range(0, dataArray.size()).mapToObj(i -> dataArray.getJSONObject(i)).filter(Objects::nonNull).map(obj -> obj.getString(fieldName)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

