/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dashboard.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.dashboard.json.ChartType;
import com.jxdinfo.hussar.dashboard.json.Dimension;
import com.jxdinfo.hussar.dashboard.json.FilterData;
import com.jxdinfo.hussar.dashboard.json.GroupAggregation;
import com.jxdinfo.hussar.dashboard.json.Metric;
import com.jxdinfo.hussar.dashboard.json.ParamsData;
import com.jxdinfo.hussar.dashboard.json.QueryDataJson;
import com.jxdinfo.hussar.dashboard.json.QueryOrder;
import com.jxdinfo.hussar.dashboard.json.ShowField;
import com.jxdinfo.hussar.dashboard.qo.SuperQueryConditionDto;
import com.jxdinfo.hussar.dashboard.run.plugin.base.data.ConvertData;
import com.jxdinfo.hussar.dashboard.run.plugin.base.service.support.AbstractPluginBaseRemoteService;
import com.jxdinfo.hussar.dashboard.service.IDashboardFeignService;
import com.jxdinfo.hussar.dashboard.util.ConstantUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.DataType;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppDataSourceService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.QueryBusinessDataVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppTreeExtendVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.FieldDetailVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormGroupExtendVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormDataVo;
import com.jxdinfo.hussar.formdesign.application.panel.dto.QueryChartDataDto;
import com.jxdinfo.hussar.formdesign.application.panel.service.ISysPanelChartService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FieldDataSourceService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class DashboardFeignServiceImpl
implements IDashboardFeignService {
    private static final Logger logger = LoggerFactory.getLogger(DashboardFeignServiceImpl.class);
    @Resource
    private ISysPanelChartService panelChartService;
    @Resource
    private FieldDataSourceService fieldDataSourceService;
    @Resource
    private IHussarAppDataSourceService hussarAppDataSourceService;
    @Resource
    private ISysFormService formService;

    public List<Map<String, Object>> getDataSourceList(String type, String key) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        FormDesignResponse response = this.fieldDataSourceService.dataList(type, key);
        if (response.getData() != null) {
            for (AppTreeExtendVo vo : (List)response.getData()) {
                List noGroupList = vo.getNoGroupList();
                if (noGroupList != null) {
                    ArrayList<SysFormDataVo> resNoGroupList = new ArrayList<SysFormDataVo>();
                    for (SysFormDataVo sysFormDataVo : noGroupList) {
                        if ("2".equals(sysFormDataVo.getFormType())) continue;
                        resNoGroupList.add(sysFormDataVo);
                    }
                    vo.setNoGroupList(resNoGroupList);
                }
                List formGroupExtendVoList = vo.getSysFormGroupVos();
                ArrayList<FormGroupExtendVo> resFormGroupExtendVoList = new ArrayList<FormGroupExtendVo>();
                for (FormGroupExtendVo formGroupExtendVo : formGroupExtendVoList) {
                    List formDataVoList = formGroupExtendVo.getSysFormList();
                    if (formDataVoList != null) {
                        ArrayList<SysFormDataVo> resFormDataVoList = new ArrayList<SysFormDataVo>();
                        for (SysFormDataVo sysFormDataVo : formDataVoList) {
                            if ("2".equals(sysFormDataVo.getFormType())) continue;
                            resFormDataVoList.add(sysFormDataVo);
                        }
                        formGroupExtendVo.setSysFormList(resFormDataVoList);
                    }
                    resFormGroupExtendVoList.add(formGroupExtendVo);
                }
                vo.setSysFormGroupVos(resFormGroupExtendVoList);
                dataList.add(BeanUtil.beanToMap((Object)vo));
            }
        }
        return dataList;
    }

    public List<WidgetField> getDataSourceDetailUpgrade(String type, String appId, String formId, String appCode, String apiCode) {
        List<Object> widgetFields = new ArrayList<WidgetField>();
        try {
            FormDesignResponse response;
            if (HussarUtils.isNotEmpty((Object)appId)) {
                AppContextUtil.setAppId((String)appId);
            }
            if (HussarUtils.isNotEmpty((Object)(response = this.fieldDataSourceService.sourceDetail(type, appId, formId, appCode, apiCode, "")).getData())) {
                widgetFields = ((FieldDetailVO)response.getData()).getList();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (LcdpException e) {
            throw new RuntimeException(e);
        }
        return widgetFields;
    }

    public Map<String, Object> getDataSourceInfo(String type, String appId, String formId, String appCode, String apiCode) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        List<WidgetField> list = this.getDataSourceDetailUpgrade(type, appId, formId, appCode, apiCode);
        SysForm sysForm = (SysForm)this.formService.getById((Serializable)Long.valueOf(formId));
        resMap.put("info", sysForm);
        resMap.put("list", list);
        return resMap;
    }

    public List<Map<String, Object>> getDataOption(Map<String, Object> queryMap) {
        List<Map<String, Object>> resList;
        block34: {
            String fieldType;
            String fieldName;
            block35: {
                fieldName = queryMap.get("fieldName").toString();
                fieldType = queryMap.get("fieldType").toString();
                resList = new ArrayList<Map<String, Object>>();
                if (!WidgetType.JXDNSwitch.getType().equals(fieldType) && !WidgetType.SELECT_MUL.getType().equals(fieldType) && !WidgetType.CHECK_BOX_GROUP.getType().equals(fieldType) && !WidgetType.SELECT.getType().equals(fieldType) && !WidgetType.RADIO_GROUP.getType().equals(fieldType)) break block35;
                String appCode = queryMap.get("appCode") == null ? null : queryMap.get("appCode").toString();
                String apiCode = queryMap.get("apiCode") == null ? null : queryMap.get("apiCode").toString();
                List<WidgetField> datasourceDetail = this.getDataSourceDetailUpgrade(queryMap.get("type").toString(), queryMap.get("appId").toString(), queryMap.get("formId").toString(), appCode, apiCode);
                if (!HussarUtils.isNotEmpty(datasourceDetail)) break block34;
                for (WidgetField field : datasourceDetail) {
                    if (!fieldName.equals(field.getName())) continue;
                    JSONObject props = field.getProps();
                    if (props == null) break block34;
                    if (WidgetType.JXDNSwitch.getType().equals(fieldType)) {
                        List textEntry = (List)props.get((Object)"textEntry");
                        for (int i = 0; i < textEntry.size(); ++i) {
                            HashMap<String, Object> resMap = new HashMap<String, Object>();
                            resMap.put("label", textEntry.get(i));
                            resMap.put("value", i);
                            resList.add(resMap);
                        }
                        break block34;
                    }
                    if ("async".equals(props.get((Object)"optionType"))) {
                        Map async = (Map)props.get((Object)"async");
                        HashMap<String, Object> paramsData = new HashMap<String, Object>();
                        paramsData.put("size", Integer.MAX_VALUE);
                        paramsData.put("current", 1);
                        String queryFieldName = (String)async.get("fieldName");
                        Map filterCondition = (Map)props.get((Object)"filterCondition");
                        List conditions = (List)filterCondition.get("conditions");
                        if (!conditions.isEmpty()) {
                            String rel = filterCondition.get("rel").toString();
                            ArrayList<SuperQueryConditionDto> superQueryConditionDtos = new ArrayList<SuperQueryConditionDto>();
                            for (Map map : conditions) {
                                if (!"custom".equals(map.get("mode"))) continue;
                                SuperQueryConditionDto dto = new SuperQueryConditionDto();
                                dto.setField(map.get("field").toString());
                                dto.setMatch(rel.toUpperCase());
                                OperatorType operatorType = OperatorType.getByName((String)map.get("method").toString());
                                dto.setRule(operatorType.getValue());
                                if (map.get("value") instanceof List) {
                                    List objects = (List)map.get("value");
                                    String value = "";
                                    for (int i = 0; i < objects.size(); ++i) {
                                        value = value + objects.get(i);
                                        if (i >= objects.size() - 1) continue;
                                        value = value + ",";
                                    }
                                    dto.setVal(value);
                                } else {
                                    dto.setVal(map.get("value").toString());
                                }
                                superQueryConditionDtos.add(dto);
                            }
                            SuperQueryConditionDto notNull = new SuperQueryConditionDto();
                            notNull.setRule(OperatorType.IS_NOT_NULL.getValue());
                            notNull.setMatch("AND");
                            notNull.setField(queryFieldName);
                            superQueryConditionDtos.add(notNull);
                            paramsData.put("superQueryConditionDto", superQueryConditionDtos);
                        }
                        ArrayList<QueryOrder> queryOrderList = new ArrayList<QueryOrder>();
                        List list = (List)props.get((Object)"optionSort");
                        for (Map sortMap : list) {
                            QueryOrder queryOrder = new QueryOrder();
                            queryOrder.setColumn(sortMap.get("column").toString());
                            queryOrder.setAsc((Boolean)sortMap.get("asc"));
                            queryOrderList.add(queryOrder);
                        }
                        if (!queryOrderList.isEmpty()) {
                            paramsData.put("orders", queryOrderList);
                        }
                        resList = this.queryOption((String)async.get("asyncType"), (String)async.get("appId"), (String)async.get("formId"), (String)async.get("uri"), (String)async.get("appCode"), (String)async.get("apiCode"), paramsData, queryFieldName);
                        break block34;
                    }
                    if ("static".equals(props.get((Object)"optionType"))) {
                        resList = (List)props.get((Object)"options");
                        break block34;
                    }
                    if (!"dataLinkage".equals(props.get((Object)"optionType"))) break block34;
                    Map dataLinkage = (Map)props.get((Object)"dataLinkage");
                    Map data = (Map)dataLinkage.get("data");
                    HashMap<String, Object> paramsData = new HashMap<String, Object>();
                    paramsData.put("size", Integer.MAX_VALUE);
                    paramsData.put("current", 1);
                    String queryFieldName = (String)data.get("fieldName");
                    Map filterCondition = (Map)dataLinkage.get("filter");
                    String rel = filterCondition.get("rel").toString();
                    List conditions = (List)filterCondition.get("conditions");
                    ArrayList<SuperQueryConditionDto> superQueryConditionDtos = new ArrayList<SuperQueryConditionDto>();
                    for (Map map : conditions) {
                        if (!"custom".equals(map.get("mode"))) continue;
                        SuperQueryConditionDto dto = new SuperQueryConditionDto();
                        dto.setField(map.get("field").toString());
                        dto.setMatch(rel.toUpperCase());
                        OperatorType operatorType = OperatorType.getByName((String)map.get("method").toString());
                        dto.setRule(operatorType.getValue());
                        if (map.get("value") instanceof List) {
                            List objects = (List)map.get("value");
                            String value = "";
                            for (int i = 0; i < objects.size(); ++i) {
                                value = value + objects.get(i);
                                if (i >= objects.size() - 1) continue;
                                value = value + ",";
                            }
                            dto.setVal(value);
                        } else {
                            dto.setVal(map.get("value").toString());
                        }
                        superQueryConditionDtos.add(dto);
                    }
                    SuperQueryConditionDto notNull = new SuperQueryConditionDto();
                    notNull.setRule(OperatorType.IS_NOT_NULL.getValue());
                    notNull.setMatch("AND");
                    notNull.setField(queryFieldName);
                    superQueryConditionDtos.add(notNull);
                    paramsData.put("superQueryConditionDto", superQueryConditionDtos);
                    ArrayList<QueryOrder> queryOrderList = new ArrayList<QueryOrder>();
                    QueryOrder queryOrder = new QueryOrder();
                    switch (props.get((Object)"dataLinkageSort").toString()) {
                        case "1": {
                            queryOrder.setColumn(queryFieldName);
                            queryOrder.setAsc(Boolean.valueOf(true));
                            break;
                        }
                        case "2": {
                            queryOrder.setColumn(queryFieldName);
                            queryOrder.setAsc(Boolean.valueOf(false));
                            break;
                        }
                        case "3": {
                            queryOrder.setColumn("createTime_date");
                            queryOrder.setAsc(Boolean.valueOf(true));
                            break;
                        }
                        case "4": {
                            queryOrder.setColumn("createTime_date");
                            queryOrder.setAsc(Boolean.valueOf(false));
                            break;
                        }
                    }
                    if (HussarUtils.isNotEmpty((Object)queryOrder)) {
                        queryOrderList.add(queryOrder);
                    }
                    if (!queryOrderList.isEmpty()) {
                        paramsData.put("orders", queryOrderList);
                    }
                    resList = this.queryOption((String)data.get("asyncType"), (String)data.get("appId"), (String)data.get("formId"), (String)data.get("uri"), (String)data.get("appCode"), (String)data.get("apiCode"), paramsData, queryFieldName);
                    break block34;
                }
                break block34;
            }
            HashMap<String, Serializable> paramsData = new HashMap<String, Serializable>();
            paramsData.put("size", Integer.valueOf(Integer.MAX_VALUE));
            paramsData.put("current", Integer.valueOf(1));
            HashMap groupAggregation = new HashMap();
            ArrayList<String> groupList = new ArrayList<String>();
            String labelName = this.getLabel(fieldName, fieldType);
            fieldName = this.getValue(fieldName, fieldType);
            groupList.add(fieldName);
            if (!labelName.equals(fieldName)) {
                groupList.add(labelName);
            }
            groupAggregation.put("group", groupList);
            paramsData.put("groupAggregation", groupAggregation);
            QueryChartDataDto queryChartDataDto = new QueryChartDataDto();
            queryChartDataDto.setParams(paramsData);
            queryChartDataDto.setAppId(queryMap.get("appId").toString());
            queryChartDataDto.setFormId(queryMap.get("formId").toString());
            SysForm sysForm = (SysForm)this.formService.getById((Serializable)Long.valueOf(queryMap.get("formId").toString()));
            queryChartDataDto.setFormType(sysForm != null ? sysForm.getFormType() : null);
            ApiResponse response = this.panelChartService.formData(queryChartDataDto);
            if (response.isSuccess()) {
                PageVo data = (PageVo)response.getData();
                if (HussarUtils.isEmpty((Object)data)) {
                    return resList;
                }
                List res = data.getData();
                for (Map map : res) {
                    if (map == null) continue;
                    HashMap resMap = new HashMap();
                    resMap.put("label", map.get(labelName));
                    resMap.put("value", map.get(fieldName));
                    resList.add(resMap);
                }
            }
        }
        return resList;
    }

    private List<Map<String, Object>> queryOption(String asyncType, String appId, String formId, String uri, String appCode, String apiCode, Map<String, Object> paramsData, String queryFieldName) {
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        ApiResponse response = new ApiResponse();
        if (HussarUtils.equals((Object)asyncType, (Object)"currentApp") || HussarUtils.equals((Object)asyncType, (Object)"crossApp")) {
            response = this.hussarAppDataSourceService.queryAppBusinessData(formId, appId, paramsData);
        } else if (HussarUtils.equals((Object)asyncType, (Object)"dataSet")) {
            try {
                response = this.hussarAppDataSourceService.querySetBusinessData(formId, paramsData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (LcdpException e) {
                throw new RuntimeException(e);
            }
        } else {
            ApiResponse apiResponse = response = HussarUtils.equals((Object)asyncType, (Object)"externalAPI") ? this.hussarAppDataSourceService.queryApiBusinessData(formId, appCode, apiCode, uri, paramsData) : ApiResponse.fail((String)"\u6570\u636e\u6e90\u7c7b\u578b\u65e0\u6548");
        }
        if (response.isSuccess() && HussarUtils.isNotEmpty((Object)response.getData())) {
            PageVo pageVo = (PageVo)((QueryBusinessDataVo)response.getData()).getBusinessData();
            List data = pageVo.getData();
            HashSet<String> set = new HashSet<String>();
            for (Map map : data) {
                if (map.get(queryFieldName) == null || set.contains(map.get(queryFieldName).toString())) continue;
                HashMap resMap = new HashMap();
                resMap.put("label", map.get(queryFieldName));
                resMap.put("value", map.get(queryFieldName));
                set.add(map.get(queryFieldName).toString());
                resList.add(resMap);
            }
        }
        return resList;
    }

    public Map<String, Object> queryDataChart(QueryDataJson queryDataJson) {
        int limit;
        boolean enable;
        HashMap data = new HashMap();
        Map<Object, Object> paramsData = new HashMap();
        String chartType = queryDataJson.getWidget().getChartType();
        List<WidgetField> fieldDetails = this.getDataSourceDetailUpgrade(queryDataJson.getType(), queryDataJson.getAppId(), queryDataJson.getFormId(), queryDataJson.getAppCode(), queryDataJson.getApiCode());
        ArrayList metrics = new ArrayList();
        metrics.addAll(queryDataJson.getWidget().getMetrics());
        List xFields = queryDataJson.getWidget().getxFields();
        HashMap<String, String> dateFormatMap = new HashMap<String, String>();
        if (fieldDetails != null) {
            for (WidgetField widgetField : fieldDetails) {
                if (!widgetField.getType().equals(WidgetType.DATE.getType())) continue;
                dateFormatMap.put(widgetField.getName(), widgetField.getProps().get((Object)"format").toString());
            }
        }
        paramsData = this.initAggregation(queryDataJson, dateFormatMap);
        Map rowFilter = queryDataJson.getWidget().getRowsFilter();
        if (HussarUtils.isNotEmpty((Object)rowFilter)) {
            boolean bl = enable = rowFilter.get("enable") == null ? false : Boolean.parseBoolean(rowFilter.get("enable").toString());
            limit = enable ? (rowFilter.get("index") != null ? Integer.parseInt(rowFilter.get("index").toString()) : Integer.MAX_VALUE) : Integer.MAX_VALUE;
        } else {
            limit = queryDataJson.getLimit() == 0 ? Integer.MAX_VALUE : queryDataJson.getLimit();
            enable = true;
        }
        if (enable) {
            if (limit == Integer.MAX_VALUE) {
                paramsData.put("size", Integer.MAX_VALUE);
            } else {
                paramsData.put("size", limit + 1);
            }
        } else {
            paramsData.put("size", Integer.MAX_VALUE);
        }
        paramsData.put("current", 1);
        QueryChartDataDto queryChartDataDto = new QueryChartDataDto();
        queryChartDataDto.setParams(paramsData);
        queryChartDataDto.setAppId(queryDataJson.getAppId());
        queryChartDataDto.setFormId(queryDataJson.getFormId());
        Map<String, Object> optionMap = new HashMap<String, Object>();
        SysForm sysForm = (SysForm)this.formService.getById((Serializable)Long.valueOf(queryDataJson.getFormId()));
        queryChartDataDto.setFormType(sysForm != null ? sysForm.getFormType() : null);
        ApiResponse response = this.panelChartService.formData(queryChartDataDto);
        if (ChartType.METRIC_TABLE.getType().equals(chartType)) {
            List resList;
            if (xFields.size() > 0) {
                List resList2;
                HashMap sumParam = new HashMap();
                BeanUtil.copy(paramsData, sumParam);
                ((Map)sumParam.get("groupAggregation")).put("group", null);
                queryChartDataDto.setParams(sumParam);
                QueryChartDataDto sumQueryChartDataDto = queryChartDataDto;
                ((Map)sumQueryChartDataDto.getParams().get("groupAggregation")).put("group", null);
                ApiResponse sumResponse = this.panelChartService.formData(sumQueryChartDataDto);
                if (sumResponse.isSuccess() && HussarUtils.isNotEmpty((Object)(resList2 = ((PageVo)sumResponse.getData()).getData()))) {
                    Map sumMap = (Map)resList2.get(0);
                    data.put("sumMap", sumMap);
                }
            } else if (response.isSuccess() && HussarUtils.isNotEmpty((Object)(resList = ((PageVo)response.getData()).getData()))) {
                Map sumMap = (Map)resList.get(0);
                data.put("sumMap", sumMap);
            }
        }
        ParamsData paramsDataObj = (ParamsData)BeanUtil.mapToBean(paramsData, ParamsData.class, (boolean)false);
        if (response.isSuccess() && response.getData() != null && ((PageVo)response.getData()).getData() != null) {
            ArrayList<Map> resList = new ArrayList<Map>();
            for (Map map : ((PageVo)response.getData()).getData()) {
                if (map == null || resList.size() >= limit) continue;
                resList.add(map);
            }
            for (Object dimension : xFields) {
                int i;
                String decimalStr;
                String value;
                String[] numStrArr;
                String decimalString;
                BigDecimal decimalValue;
                String numStr;
                ArrayList<Map> mapList;
                if (WidgetType.JXDNSwitch.getType().equals(dimension.getType())) {
                    List textEntry = (List)dimension.getProps().get("textEntry");
                    for (Map map : resList) {
                        if ("".equals(map.get(dimension.getName())) || map.get(dimension.getName()) == null) continue;
                        int yesOrNo = Integer.parseInt(map.get(dimension.getName()).toString());
                        map.put(dimension.getName(), textEntry.get(yesOrNo));
                    }
                }
                if (WidgetType.DATE.getType().equals(dimension.getType())) {
                    for (Map resMap3 : resList) {
                        if (resMap3.get(dimension.getName()) == null) continue;
                        String string = dimension.getProps().get("format").toString();
                        LocalDateTime localDateTime = (LocalDateTime)resMap3.get(dimension.getName());
                        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(string);
                        resMap3.put(dimension.getName(), dateTimeFormatter.format(localDateTime));
                    }
                }
                if (WidgetType.NUMBER.getType().equals(dimension.getType())) {
                    int decimalNum = Integer.parseInt(dimension.getProps().get("decimalNum").toString());
                    mapList = new ArrayList<Map>();
                    for (Map resMap4 : resList) {
                        if (resMap4 == null) continue;
                        if (resMap4.get(dimension.getName()) != null) {
                            numStr = resMap4.get(dimension.getName()).toString();
                            decimalValue = new BigDecimal(numStr);
                            decimalString = decimalValue.toPlainString();
                            numStrArr = decimalString.split("\\.");
                            value = numStrArr[0];
                            if (numStrArr.length > 1 && decimalNum > 0) {
                                if (numStrArr[1].length() >= decimalNum) {
                                    value = value + "." + numStrArr[1].substring(0, decimalNum);
                                } else {
                                    decimalStr = "." + numStrArr[1];
                                    for (i = 0; i < decimalNum - numStrArr[1].length(); ++i) {
                                        decimalStr = decimalStr + "0";
                                    }
                                    value = value + decimalStr;
                                }
                            }
                            resMap4.put(dimension.getName(), value);
                        }
                        mapList.add(resMap4);
                    }
                    resList = mapList;
                }
                if (WidgetType.SELECT_MUL.getType().equals(dimension.getType()) || WidgetType.CHECK_BOX_GROUP.getType().equals(dimension.getType())) {
                    for (Map resMap : resList) {
                        if (resMap.get(this.getLabel(dimension.getName(), dimension.getType())) == null) continue;
                        String string = resMap.get(this.getLabel(dimension.getName(), dimension.getType())).toString();
                        if ("[]".equals(string)) {
                            resMap.put(this.getLabel(dimension.getName(), dimension.getType()), "");
                        }
                        if (string.length() <= 4) continue;
                        String string2 = string.substring(2, string.length() - 2).replace("\",\"", ",");
                        resMap.put(this.getLabel(dimension.getName(), dimension.getType()), string2);
                    }
                }
                if (WidgetType.ADDRESS.getType().equals(dimension.getType()) && Boolean.parseBoolean(dimension.getProps().get("fullAddress").toString())) {
                    String addressDetailName = dimension.getName() + "_detailed";
                    String addressName = this.getLabel(dimension.getName(), dimension.getType());
                    for (Map resMap5 : resList) {
                        if (resMap5.get(addressName) == null) continue;
                        resMap5.put(addressName, resMap5.get(addressName).toString() + (resMap5.get(addressDetailName) == null ? "" : resMap5.get(addressDetailName).toString()));
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (Object fieldName : paramsDataObj.getGroupAggregation().getGroup()) {
                        if (((String)fieldName).equals(addressDetailName)) continue;
                        arrayList.add(fieldName);
                    }
                    paramsDataObj.getGroupAggregation().setGroup(arrayList);
                }
                if ("PROCESS_STATE".equals(dimension.getName())) {
                    List options = (List)dimension.getProps().get("options");
                    for (Map map : resList) {
                        Object fieldName;
                        if (map.get(dimension.getName()) == null) continue;
                        String value2 = map.get(dimension.getName()).toString();
                        fieldName = options.iterator();
                        while (fieldName.hasNext()) {
                            Map option = (Map)fieldName.next();
                            if (!((String)option.get("value")).equals(value2)) continue;
                            map.put(dimension.getName(), option.get("label"));
                        }
                    }
                }
                if (!WidgetType.JXDNAggregate.getType().equals(dimension.getType())) continue;
                int decimalNum = Integer.parseInt(dimension.getProps().get("decimalNum").toString());
                mapList = new ArrayList();
                for (Map resMap6 : resList) {
                    if (resMap6 == null) continue;
                    if (resMap6.get(dimension.getName()) != null) {
                        numStr = resMap6.get(dimension.getName()).toString();
                        decimalValue = new BigDecimal(numStr);
                        decimalString = decimalValue.toPlainString();
                        numStrArr = decimalString.split("\\.");
                        value = numStrArr[0];
                        if (numStrArr.length > 1 && decimalNum > 0) {
                            if (numStrArr[1].length() >= decimalNum) {
                                value = value + "." + numStrArr[1].substring(0, decimalNum);
                            } else {
                                decimalStr = "." + numStrArr[1];
                                for (i = 0; i < decimalNum - numStrArr[1].length(); ++i) {
                                    decimalStr = decimalStr + "0";
                                }
                                value = value + decimalStr;
                            }
                        }
                        resMap6.put(dimension.getName(), value);
                    }
                    mapList.add(resMap6);
                }
                resList = mapList;
            }
            if (chartType.equals(ChartType.PROGRESS_CHART.getType())) {
                if (resList.size() > 1) {
                    ((Map)resList.get(0)).putIfAbsent("target", 0);
                    ((Map)resList.get(0)).putIfAbsent("value", 0);
                }
            } else {
                HashMap<String, Object> aggNameMap = new HashMap<String, Object>();
                for (String str : paramsDataObj.getGroupAggregation().getAgg().keySet()) {
                    String aggName = (String)paramsDataObj.getGroupAggregation().getAgg().get(str);
                    int n = aggName.lastIndexOf("_agg");
                    aggNameMap.put(aggName.substring(0, n), aggName);
                }
                for (Metric metric : metrics) {
                    if (!metric.getType().equals(WidgetType.NUMBER.getType())) continue;
                    for (Map map : resList) {
                        map.putIfAbsent(aggNameMap.get(metric.getName()), 0);
                    }
                }
            }
            JSONArray json = JSONArray.parseArray((String)JSON.toJSONString(resList));
            data.put("widget", queryDataJson.getWidget());
            data.put("dataMap", paramsDataObj);
            data.put("json", json);
            AbstractPluginBaseRemoteService service = (AbstractPluginBaseRemoteService)SpringUtil.getBean((String)chartType, AbstractPluginBaseRemoteService.class);
            ConvertData newValue = new ConvertData(null, null, data);
            ConvertData convertData = service.convertPluginData(newValue);
            optionMap = (Map)convertData.getData();
        }
        return optionMap;
    }

    public Map<String, Object> queryDataTable(QueryDataJson queryDataJson) {
        PageVo businessData;
        HashMap<String, Object> data = new HashMap<String, Object>();
        List<WidgetField> dataSourceDetail = this.getDataSourceDetailUpgrade(queryDataJson.getType(), queryDataJson.getAppId(), queryDataJson.getFormId(), queryDataJson.getAppCode(), queryDataJson.getApiCode());
        HashMap<String, String> dateFormatMap = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty(dataSourceDetail)) {
            for (WidgetField widgetField : dataSourceDetail) {
                if (!widgetField.getType().equals(WidgetType.DATE.getType())) continue;
                dateFormatMap.put(widgetField.getName(), widgetField.getProps().get((Object)"format").toString());
            }
        }
        Map<String, Object> paramsData = this.initAggregation(queryDataJson, dateFormatMap);
        paramsData.remove("groupAggregation");
        ArrayList<QueryOrder> queryOrderList = new ArrayList<QueryOrder>();
        for (ShowField field : queryDataJson.getWidget().getFields()) {
            QueryOrder queryOrder = new QueryOrder();
            queryOrder.setColumn(this.getValue(field.getName(), field.getType()));
            if (field.getSort() == ConstantUtil.ASC_ORDER.intValue()) {
                queryOrder.setAsc(Boolean.valueOf(true));
                queryOrderList.add(queryOrder);
                continue;
            }
            if (field.getSort() != ConstantUtil.DESC_ORDER.intValue()) continue;
            queryOrder.setAsc(Boolean.valueOf(false));
            queryOrderList.add(queryOrder);
        }
        if (!queryOrderList.isEmpty()) {
            paramsData.put("orders", queryOrderList);
        }
        paramsData.put("size", queryDataJson.getLimit());
        paramsData.put("current", queryDataJson.getCurrent());
        ApiResponse response = new ApiResponse();
        if (HussarUtils.equals((Object)queryDataJson.getType(), (Object)DataType.FORM.getType())) {
            response = this.hussarAppDataSourceService.queryAppBusinessData(queryDataJson.getFormId(), queryDataJson.getAppId(), paramsData);
        } else if (HussarUtils.equals((Object)queryDataJson.getType(), (Object)DataType.DATASET.getType())) {
            try {
                response = this.hussarAppDataSourceService.querySetBusinessData(queryDataJson.getFormId(), paramsData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (LcdpException e) {
                throw new RuntimeException(e);
            }
        } else {
            response = HussarUtils.equals((Object)queryDataJson.getType(), (Object)DataType.EXTERNALAPI.getType()) ? this.hussarAppDataSourceService.queryApiBusinessData(queryDataJson.getFormId(), queryDataJson.getAppCode(), queryDataJson.getApiCode(), queryDataJson.getUri(), paramsData) : ApiResponse.fail((String)"\u6570\u636e\u6e90\u7c7b\u578b\u65e0\u6548");
        }
        Map<String, Object> optionMap = new HashMap<String, Object>();
        if (response.isSuccess() && (businessData = (PageVo)((QueryBusinessDataVo)response.getData()).getBusinessData()) != null && businessData.getData() != null) {
            String chartType = ChartType.DATA_TABLE.getType();
            for (WidgetField fieldDetail : dataSourceDetail) {
                int i;
                String decimalStr;
                String value;
                String[] numStrArr;
                String decimalString;
                Object decimalValue;
                String numStr;
                if (WidgetType.DATE.getType().equals(fieldDetail.getType())) {
                    for (Object map : businessData.getData()) {
                        if (map.get(fieldDetail.getName()) == null) continue;
                        String formatStr = fieldDetail.getProps().getString("format");
                        LocalDateTime localDateTime = (LocalDateTime)map.get(fieldDetail.getName());
                        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(formatStr);
                        map.put(fieldDetail.getName(), dateTimeFormatter.format(localDateTime));
                    }
                }
                if (WidgetType.NUMBER.getType().equals(fieldDetail.getType())) {
                    Object map;
                    int decimalNum = Integer.parseInt(fieldDetail.getProps().get((Object)"decimalNum").toString());
                    map = businessData.getData().iterator();
                    while (map.hasNext()) {
                        Map map2 = (Map)map.next();
                        if (map2.get(fieldDetail.getName()) == null) continue;
                        numStr = map2.get(fieldDetail.getName()).toString();
                        decimalValue = new BigDecimal(numStr);
                        decimalString = ((BigDecimal)decimalValue).toPlainString();
                        numStrArr = decimalString.split("\\.");
                        value = numStrArr[0];
                        if (numStrArr.length > 1 && decimalNum > 0) {
                            if (numStrArr[1].length() >= decimalNum) {
                                value = value + "." + numStrArr[1].substring(0, decimalNum);
                            } else {
                                decimalStr = "." + numStrArr[1];
                                for (i = 0; i < decimalNum - numStrArr[1].length(); ++i) {
                                    decimalStr = decimalStr + "0";
                                }
                                value = value + decimalStr;
                            }
                        }
                        map2.put(fieldDetail.getName(), value);
                    }
                }
                if (WidgetType.SELECT_MUL.getType().equals(fieldDetail.getType()) || WidgetType.CHECK_BOX_GROUP.getType().equals(fieldDetail.getType())) {
                    for (Object map : businessData.getData()) {
                        if (map.get(this.getLabel(fieldDetail.getName(), fieldDetail.getType())) == null) continue;
                        Object labelStr = map.get(this.getLabel(fieldDetail.getName(), fieldDetail.getType())).toString();
                        if ("[]".equals(labelStr)) {
                            map.put(this.getLabel(fieldDetail.getName(), fieldDetail.getType()), "");
                        }
                        if (((String)labelStr).length() <= 4) continue;
                        labelStr = ((String)labelStr).substring(2, ((String)labelStr).length() - 2).replace("\",\"", ",");
                        map.put(this.getLabel(fieldDetail.getName(), fieldDetail.getType()), labelStr);
                    }
                }
                if (WidgetType.ADDRESS.getType().equals(fieldDetail.getType()) && Boolean.parseBoolean(fieldDetail.getProps().get((Object)"fullAddress").toString())) {
                    String addressDetailName = fieldDetail.getName() + "_detailed";
                    String addressName = this.getLabel(fieldDetail.getName(), fieldDetail.getType());
                    for (Map map : businessData.getData()) {
                        if (map.get(addressName) == null) continue;
                        map.put(addressName, map.get(addressName).toString() + (map.get(addressDetailName) == null ? "" : map.get(addressDetailName).toString()));
                    }
                }
                if ("PROCESS_STATE".equals(fieldDetail.getName())) {
                    List options = (List)fieldDetail.getProps().get((Object)"options");
                    for (Map map2 : businessData.getData()) {
                        if (map2.get(fieldDetail.getName()) == null) continue;
                        String value2 = map2.get(fieldDetail.getName()).toString();
                        for (Map option : options) {
                            if (!((String)option.get("value")).equals(value2)) continue;
                            map2.put(fieldDetail.getName(), option.get("label"));
                        }
                    }
                }
                if (!WidgetType.JXDNAggregate.getType().equals(fieldDetail.getType())) continue;
                int decimalNum = Integer.parseInt(fieldDetail.getProps().get((Object)"decimalNum").toString());
                for (Map map2 : businessData.getData()) {
                    if (map2.get(fieldDetail.getName()) == null) continue;
                    numStr = map2.get(fieldDetail.getName()).toString();
                    decimalValue = new BigDecimal(numStr);
                    decimalString = ((BigDecimal)decimalValue).toPlainString();
                    numStrArr = decimalString.split("\\.");
                    value = numStrArr[0];
                    if (numStrArr.length > 1 && decimalNum > 0) {
                        if (numStrArr[1].length() >= decimalNum) {
                            value = value + "." + numStrArr[1].substring(0, decimalNum);
                        } else {
                            decimalStr = "." + numStrArr[1];
                            for (i = 0; i < decimalNum - numStrArr[1].length(); ++i) {
                                decimalStr = decimalStr + "0";
                            }
                            value = value + decimalStr;
                        }
                    }
                    map2.put(fieldDetail.getName(), value);
                }
            }
            JSONObject json = JSONObject.parseObject((String)JSON.toJSONString((Object)businessData));
            data.put("dataSourceDetail", dataSourceDetail);
            data.put("widget", queryDataJson.getWidget());
            data.put("dataMap", paramsData);
            data.put("json", json);
            data.put("formId", queryDataJson.getFormId());
            data.put("limit", queryDataJson.getLimit());
            data.put("current", queryDataJson.getCurrent());
            data.putAll(queryDataJson.getWidget().getRowsFilter());
            AbstractPluginBaseRemoteService service = (AbstractPluginBaseRemoteService)SpringUtil.getBean((String)chartType, AbstractPluginBaseRemoteService.class);
            ConvertData newValue = new ConvertData(null, null, data);
            ConvertData convertData = service.convertPluginData(newValue);
            optionMap = (Map)convertData.getData();
            if (ChartType.GANTT_CHART.getType().equals(queryDataJson.getWidget().getChartType()) && queryDataJson.getWidget().getHasXAxis().booleanValue()) {
                paramsData.put("size", Integer.MAX_VALUE);
                paramsData.put("current", 1);
                if (HussarUtils.equals((Object)queryDataJson.getType(), (Object)DataType.FORM.getType())) {
                    response = this.hussarAppDataSourceService.queryAppBusinessData(queryDataJson.getFormId(), queryDataJson.getAppId(), paramsData);
                } else if (HussarUtils.equals((Object)queryDataJson.getType(), (Object)DataType.DATASET.getType())) {
                    try {
                        response = this.hussarAppDataSourceService.querySetBusinessData(queryDataJson.getFormId(), paramsData);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (LcdpException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    ApiResponse apiResponse = response = HussarUtils.equals((Object)queryDataJson.getType(), (Object)DataType.EXTERNALAPI.getType()) ? this.hussarAppDataSourceService.queryApiBusinessData(queryDataJson.getFormId(), queryDataJson.getAppCode(), queryDataJson.getApiCode(), queryDataJson.getUri(), paramsData) : ApiResponse.fail((String)"\u6570\u636e\u6e90\u7c7b\u578b\u65e0\u6548");
                }
                if (response.isSuccess()) {
                    PageVo businessDataGantt = (PageVo)((QueryBusinessDataVo)response.getData()).getBusinessData();
                    List ganttData = businessDataGantt.getData();
                    optionMap.put("xAxis", ganttData);
                }
            }
        }
        return optionMap;
    }

    private Map<String, Object> initAggregation(QueryDataJson queryDataJson, Map<String, String> dateFormatMap) {
        ArrayList metrics = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)queryDataJson.getWidget().getMetrics())) {
            metrics.addAll(queryDataJson.getWidget().getMetrics());
        }
        String chartType = queryDataJson.getWidget().getChartType();
        if (ChartType.MULTI_AXES_CHART.getType().equals(chartType) && queryDataJson.getWidget().getRtmetrics() != null) {
            metrics.addAll(queryDataJson.getWidget().getRtmetrics());
        }
        ArrayList<Dimension> xField = new ArrayList<Dimension>();
        if (HussarUtils.isNotEmpty((Object)queryDataJson.getWidget().getxFields())) {
            xField.addAll(queryDataJson.getWidget().getxFields());
        }
        List filterDataList = queryDataJson.getWidget().getFilter();
        if (ChartType.SANKEY_CHART.getType().equals(chartType)) {
            if (queryDataJson.getWidget().getSource() != null) {
                xField.add(queryDataJson.getWidget().getSource());
            }
            if (queryDataJson.getWidget().getTarget() != null) {
                xField.add(queryDataJson.getWidget().getTarget());
            }
        }
        HashMap<String, Object> paramsData = new HashMap<String, Object>();
        GroupAggregation resGroupAggregation = new GroupAggregation();
        ArrayList<QueryOrder> groupOrders = new ArrayList<QueryOrder>();
        if (HussarUtils.isNotEmpty(xField)) {
            ArrayList<String> group = new ArrayList<String>();
            for (Dimension dimension : xField) {
                QueryOrder queryOrder;
                QueryOrder queryOrder2;
                String groupName = this.getLabel(dimension.getName(), dimension.getType());
                group.add(groupName);
                if (ChartType.MAP_CHART.getType().equals(chartType)) {
                    group.add(dimension.getName() + "_code");
                }
                resGroupAggregation.setGroup(group);
                if (dimension.getSort() == ConstantUtil.ASC_ORDER) {
                    queryOrder2 = new QueryOrder();
                    queryOrder2.setColumn(groupName);
                    queryOrder2.setAsc(Boolean.valueOf(true));
                    groupOrders.add(queryOrder2);
                } else if (dimension.getSort() == ConstantUtil.DESC_ORDER) {
                    queryOrder2 = new QueryOrder();
                    queryOrder2.setColumn(groupName);
                    queryOrder2.setAsc(Boolean.valueOf(false));
                    groupOrders.add(queryOrder2);
                }
                if (!dimension.getType().equals(WidgetType.ADDRESS.getType()) || dimension.getProps().get("fullAddress") == null || !Boolean.parseBoolean(dimension.getProps().get("fullAddress").toString())) continue;
                String addressDetailName = dimension.getName() + "_detailed";
                group.add(addressDetailName);
                if (dimension.getSort() == ConstantUtil.ASC_ORDER) {
                    queryOrder = new QueryOrder();
                    queryOrder.setColumn(addressDetailName);
                    queryOrder.setAsc(Boolean.valueOf(true));
                    groupOrders.add(queryOrder);
                    continue;
                }
                if (dimension.getSort() != ConstantUtil.DESC_ORDER) continue;
                queryOrder = new QueryOrder();
                queryOrder.setColumn(addressDetailName);
                queryOrder.setAsc(Boolean.valueOf(false));
                groupOrders.add(queryOrder);
            }
        }
        if (HussarUtils.isNotEmpty(metrics)) {
            HashMap<String, String> aggMap = new HashMap<String, String>();
            if (ChartType.PROGRESS_CHART.getType().equals(queryDataJson.getWidget().getChartType())) {
                List targetValues;
                if (HussarUtils.isNotEmpty(metrics)) {
                    String op = ((Metric)metrics.get(0)).getOp();
                    String aggName = this.getValue(((Metric)metrics.get(0)).getName(), ((Metric)metrics.get(0)).getType());
                    if ("JXDNNumber".equals(((Metric)metrics.get(0)).getType())) {
                        if ("countDistinct".equals(op)) {
                            aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "value");
                        } else if ("count".equals(op)) {
                            aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "value");
                        } else {
                            aggMap.put(op.toUpperCase() + "(${" + aggName + "})", "value");
                        }
                    } else if ("countDistinct".equals(op)) {
                        aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "value");
                    } else if ("count".equals(op)) {
                        aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "value");
                    } else {
                        aggMap.put(op.toUpperCase() + "(${" + aggName + "})", "value");
                    }
                }
                if (HussarUtils.isNotEmpty((Object)(targetValues = queryDataJson.getWidget().getTargetValues()))) {
                    String op = ((Metric)targetValues.get(0)).getOp();
                    String aggName = this.getValue(((Metric)targetValues.get(0)).getName(), ((Metric)targetValues.get(0)).getType());
                    if ("JXDNNumber".equals(((Metric)targetValues.get(0)).getType())) {
                        if ("countDistinct".equals(op)) {
                            aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "target");
                        } else if ("count".equals(op)) {
                            aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "target");
                        } else {
                            aggMap.put(op.toUpperCase() + "(${" + aggName + "})", "target");
                        }
                    } else if ("countDistinct".equals(op)) {
                        aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "target");
                    } else if ("count".equals(op)) {
                        aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", "target");
                    } else {
                        aggMap.put(op.toUpperCase() + "(${" + aggName + "})", "target");
                    }
                }
                resGroupAggregation.setAgg(aggMap);
            } else {
                for (Metric obj : metrics) {
                    String op = obj.getOp();
                    String aggName = this.getValue(obj.getName(), obj.getType());
                    String name = obj.getName() + "_agg";
                    if (xField != null && xField.size() > 0) {
                        boolean isNotUnique = true;
                        block18: while (isNotUnique) {
                            for (int i = 0; i < xField.size(); ++i) {
                                if (((Dimension)xField.get(i)).equals(name)) {
                                    name = name + "a";
                                    continue block18;
                                }
                                if (i != xField.size() - 1) continue;
                                isNotUnique = false;
                            }
                        }
                    }
                    if ("JXDNNumber".equals(obj.getType())) {
                        if ("countDistinct".equals(op)) {
                            aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", name);
                        } else if ("count".equals(op)) {
                            aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", name);
                        } else {
                            aggMap.put(op.toUpperCase() + "(${" + aggName + "})", name);
                        }
                    } else if ("countDistinct".equals(op)) {
                        aggMap.put("COUNT( DISTINCT CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", name);
                    } else if ("count".equals(op)) {
                        aggMap.put("COUNT( CASE WHEN ${" + aggName + "} IS NULL THEN '1' ELSE ${" + aggName + "} END)", name);
                    } else {
                        aggMap.put(op.toUpperCase() + "(${" + aggName + "})", name);
                    }
                    resGroupAggregation.setAgg(aggMap);
                    if (obj.getSort() == ConstantUtil.ASC_ORDER) {
                        QueryOrder queryOrder = new QueryOrder();
                        queryOrder.setColumn(name);
                        queryOrder.setAsc(Boolean.valueOf(true));
                        groupOrders.add(queryOrder);
                        continue;
                    }
                    if (obj.getSort() != ConstantUtil.DESC_ORDER) continue;
                    QueryOrder queryOrder = new QueryOrder();
                    queryOrder.setColumn(name);
                    queryOrder.setAsc(Boolean.valueOf(false));
                    groupOrders.add(queryOrder);
                }
            }
        }
        if (groupOrders.size() > 0) {
            resGroupAggregation.setOrders(groupOrders);
        } else if (xField != null && !xField.isEmpty()) {
            QueryOrder queryOrder = new QueryOrder();
            queryOrder.setColumn(this.getLabel(((Dimension)xField.get(0)).getName(), ((Dimension)xField.get(0)).getType()));
            queryOrder.setAsc(Boolean.valueOf(true));
            groupOrders.add(queryOrder);
            resGroupAggregation.setOrders(groupOrders);
        }
        if (HussarUtils.isNotEmpty((Object)filterDataList)) {
            ArrayList<SuperQueryConditionDto> superQueryConditionDtos = new ArrayList<SuperQueryConditionDto>();
            for (FilterData filterData : filterDataList) {
                String rel;
                SuperQueryConditionDto dto = new SuperQueryConditionDto();
                dto.setField(this.getValue(filterData.getName(), filterData.getType()));
                if (filterData.getType().equals(WidgetType.DATE.getType()) && HussarUtils.isNotEmpty(dateFormatMap) && (!"yyyy-MM-dd HH:mm:ss".equals(dateFormatMap.get(filterData.getName())) || filterData.getName().equals("START_TIME") || filterData.getName().equals("FINISH_TIME")) && (filterData.getFilterItem().getMethod().equals(OperatorType.EQ.getValue()) || filterData.getFilterItem().getMethod().equals(OperatorType.NE.getValue())) && filterData.getFilterItem().getValue().length > 0 && HussarUtils.isNotEmpty((Object)filterData.getFilterItem().getValue()[0])) {
                    String equalDateValue = filterData.getFilterItem().getValue()[0];
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    LocalDateTime localDateTime = LocalDateTime.parse(equalDateValue, dateTimeFormatter);
                    String year = String.valueOf(localDateTime.getYear());
                    String month = localDateTime.getMonthValue() > 9 ? String.valueOf(localDateTime.getMonthValue()) : "0" + localDateTime.getMonthValue();
                    String day = localDateTime.getDayOfMonth() > 9 ? String.valueOf(localDateTime.getDayOfMonth()) : "0" + localDateTime.getDayOfMonth();
                    String hour = localDateTime.getHour() > 9 ? String.valueOf(localDateTime.getHour()) : "0" + localDateTime.getHour();
                    String minute = localDateTime.getMinute() > 9 ? String.valueOf(localDateTime.getMinute()) : "0" + localDateTime.getMinute();
                    String second = localDateTime.getSecond() > 9 ? String.valueOf(localDateTime.getSecond()) : "0" + localDateTime.getSecond();
                    String startTime = "";
                    String endTime = "";
                    switch (dateFormatMap.get(filterData.getName())) {
                        case "yyyy": {
                            startTime = year + "-01-01 00:00:00";
                            endTime = year + "-12-31 23:59:59";
                            break;
                        }
                        case "yyyy-MM": {
                            int lastDayOfMonth = localDateTime.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
                            startTime = year + "-" + month + "-01 00:00:00";
                            endTime = year + "-" + month + "-" + lastDayOfMonth + " 23:59:59";
                            break;
                        }
                        case "yyyy-MM-dd": {
                            startTime = year + "-" + month + "-" + day + " 00:00:00";
                            endTime = year + "-" + month + "-" + day + " 23:59:59";
                            break;
                        }
                        case "yyyy-MM-dd HH": {
                            startTime = year + "-" + month + "-" + day + " " + hour + ":00:00";
                            endTime = year + "-" + month + "-" + day + " " + hour + ":59:59";
                            break;
                        }
                        case "yyyy-MM-dd HH:mm": {
                            startTime = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":00";
                            endTime = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":59";
                            break;
                        }
                        case "yyyy-MM-dd HH:mm:ss": {
                            startTime = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second + ".000";
                            endTime = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second + ".999";
                            break;
                        }
                    }
                    String[] timeRange = new String[]{startTime, endTime};
                    filterData.getFilterItem().setValue(timeRange);
                    if (OperatorType.EQ.getValue().equals(filterData.getFilterItem().getMethod())) {
                        filterData.getFilterItem().setMethod(OperatorType.BETWEEN.getValue());
                    } else if (OperatorType.NE.getValue().equals(filterData.getFilterItem().getMethod())) {
                        filterData.getFilterItem().setMethod(OperatorType.NOT_BETWEEN.getValue());
                    }
                }
                if (HussarUtils.isEmpty((Object)(rel = filterData.getRel()))) {
                    rel = "and";
                }
                dto.setMatch(rel.toUpperCase());
                dto.setRule(filterData.getFilterItem().getMethod());
                String value = "";
                for (int i = 0; i < filterData.getFilterItem().getValue().length; ++i) {
                    if (filterData.getFilterItem().getValue()[i] != null) {
                        value = value + filterData.getFilterItem().getValue()[i];
                    }
                    if (i >= filterData.getFilterItem().getValue().length - 1) continue;
                    value = value + ",";
                }
                dto.setVal(value);
                superQueryConditionDtos.add(dto);
            }
            paramsData.put("superQueryConditionDto", superQueryConditionDtos);
        }
        paramsData.put("groupAggregation", BeanUtil.beanToMap((Object)resGroupAggregation));
        return paramsData;
    }

    String getLabel(String name, String type) {
        WidgetType widgetType;
        String res = name;
        if (!"PROCESS_STATE".equals(name) && HussarUtils.isNotEmpty((Object)(widgetType = WidgetType.getWidgetType((String)type)))) {
            switch (widgetType) {
                case SELECT_MUL: 
                case SELECT: 
                case RADIO_GROUP: 
                case CHECK_BOX_GROUP: 
                case JXDNUser: 
                case JXDNUserMulti: 
                case JXDNOrg: 
                case JXDNOrgMulti: 
                case ADDRESS: {
                    res = name + "_label";
                    break;
                }
            }
        }
        return res;
    }

    String getValue(String name, String type) {
        String res = name;
        WidgetType widgetType = WidgetType.getWidgetType((String)type);
        if (HussarUtils.isNotEmpty((Object)widgetType) && !"createUser_user".equals(name) && !"updateUser_user".equals(name)) {
            switch (widgetType) {
                case JXDNUser: 
                case JXDNUserMulti: 
                case JXDNOrg: 
                case JXDNOrgMulti: {
                    res = name + "_id";
                    break;
                }
                case ADDRESS: {
                    res = name + "_code";
                    break;
                }
            }
        }
        return res;
    }
}

