/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dashboard.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.dashboard.json.Dimension;
import com.jxdinfo.hussar.dashboard.json.FilterData;
import com.jxdinfo.hussar.dashboard.json.GroupAggregation;
import com.jxdinfo.hussar.dashboard.json.Metric;
import com.jxdinfo.hussar.dashboard.json.ParamsData;
import com.jxdinfo.hussar.dashboard.json.QueryDataJson;
import com.jxdinfo.hussar.dashboard.json.QueryOrder;
import com.jxdinfo.hussar.dashboard.json.ShowField;
import com.jxdinfo.hussar.dashboard.qo.SuperQueryConditionDto;
import com.jxdinfo.hussar.dashboard.run.plugin.base.data.ConvertData;
import com.jxdinfo.hussar.dashboard.run.plugin.base.service.support.AbstractPluginBaseRemoteService;
import com.jxdinfo.hussar.dashboard.run.plugin.base.service.support.RoutingPluginBaseRemoteService;
import com.jxdinfo.hussar.dashboard.service.IDashboardFeignService;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.DataType;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppDataSourceService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.QueryBusinessDataVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppTreeExtendVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.FieldDetailVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormGroupExtendVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormDataVo;
import com.jxdinfo.hussar.formdesign.application.panel.dto.QueryChartDataDto;
import com.jxdinfo.hussar.formdesign.application.panel.service.ISysPanelChartService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FieldDataSourceService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class DashboardFeignServiceImpl
implements IDashboardFeignService {
    private static final Logger logger = LoggerFactory.getLogger(DashboardFeignServiceImpl.class);
    @Resource
    RoutingPluginBaseRemoteService routingPluginBaseRemoteService;
    @Resource
    private ISysPanelChartService panelChartService;
    @Resource
    private FieldDataSourceService fieldDataSourceService;
    @Resource
    private IHussarAppDataSourceService hussarAppDataSourceService;

    public List<Map<String, Object>> getDataSourceList(String type, String key) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("type", type));
        params.add(new BasicNameValuePair("key", key));
        FormDesignResponse response = this.fieldDataSourceService.dataList(type, key);
        if (response.getData() != null) {
            for (AppTreeExtendVo vo : (List)response.getData()) {
                List noGroupList = vo.getNoGroupList();
                if (noGroupList != null) {
                    ArrayList<SysFormDataVo> resNoGroupList = new ArrayList<SysFormDataVo>();
                    for (SysFormDataVo sysFormDataVo : noGroupList) {
                        if ("2".equals(sysFormDataVo.getFormType())) continue;
                        resNoGroupList.add(sysFormDataVo);
                    }
                    vo.setNoGroupList(resNoGroupList);
                }
                List formGroupExtendVoList = vo.getSysFormGroupVos();
                ArrayList<FormGroupExtendVo> resFormGroupExtendVoList = new ArrayList<FormGroupExtendVo>();
                for (FormGroupExtendVo formGroupExtendVo : formGroupExtendVoList) {
                    List formDataVoList = formGroupExtendVo.getSysFormList();
                    if (formDataVoList != null) {
                        ArrayList<SysFormDataVo> resFormDataVoList = new ArrayList<SysFormDataVo>();
                        for (SysFormDataVo sysFormDataVo : formDataVoList) {
                            if ("2".equals(sysFormDataVo.getFormType())) continue;
                            resFormDataVoList.add(sysFormDataVo);
                        }
                        formGroupExtendVo.setSysFormList(resFormDataVoList);
                    }
                    resFormGroupExtendVoList.add(formGroupExtendVo);
                }
                vo.setSysFormGroupVos(resFormGroupExtendVoList);
                dataList.add(BeanUtil.beanToMap((Object)vo));
            }
        }
        return dataList;
    }

    public List<Map<String, Object>> getDataSourceDetailUpgrade(String type, String appId, String formId, String appCode, String apiCode) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        try {
            FormDesignResponse response;
            List widgetFields;
            if (HussarUtils.isNotEmpty((Object)appId)) {
                AppContextUtil.setAppId((String)appId);
            }
            if ((widgetFields = ((FieldDetailVO)(response = this.fieldDataSourceService.sourceDetail(type, appId, formId, appCode, apiCode)).getData()).getList()) != null) {
                for (WidgetField widgetField : widgetFields) {
                    dataList.add(BeanUtil.beanToMap((Object)widgetField));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (LcdpException e) {
            throw new RuntimeException(e);
        }
        return dataList;
    }

    public List<Map<String, Object>> getDataOption(Map<String, Object> queryMap) {
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("type", queryMap.get("type"));
        paramMap.put("uri", queryMap.get("uri"));
        paramMap.put("appCode", queryMap.get("appCode"));
        paramMap.put("apiCode", queryMap.get("apiCode"));
        String fieldName = queryMap.get("fieldName").toString();
        String fieldType = queryMap.get("fieldType").toString();
        List<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        if (WidgetType.JXDNSwitch.getType().equals(fieldType) || WidgetType.SELECT_MUL.getType().equals(fieldType) || WidgetType.CHECK_BOX_GROUP.getType().equals(fieldType) || WidgetType.SELECT.getType().equals(fieldType) || WidgetType.RADIO_GROUP.getType().equals(fieldType)) {
            String appCode = queryMap.get("appCode") == null ? null : queryMap.get("appCode").toString();
            String apiCode = queryMap.get("apiCode") == null ? null : queryMap.get("apiCode").toString();
            List<Map<String, Object>> datasourceDetail = this.getDataSourceDetailUpgrade(queryMap.get("type").toString(), queryMap.get("appId").toString(), queryMap.get("formId").toString(), appCode, apiCode);
            for (Map<String, Object> field : datasourceDetail) {
                if (!fieldName.equals(field.get("name"))) continue;
                Map props = (Map)field.get("props");
                if (props == null) break;
                if (WidgetType.JXDNSwitch.getType().equals(fieldType)) {
                    List textEntry = (List)props.get("textEntry");
                    for (int i = 0; i < textEntry.size(); ++i) {
                        HashMap<String, Object> resMap = new HashMap<String, Object>();
                        resMap.put("label", textEntry.get(i));
                        resMap.put("value", i);
                        resList.add(resMap);
                    }
                    break;
                }
                if ("async".equals(props.get("optionType"))) {
                    Map async = (Map)props.get("async");
                    HashMap<String, Object> paramsData = new HashMap<String, Object>();
                    paramsData.put("size", Integer.MAX_VALUE);
                    paramsData.put("current", 1);
                    String queryFieldName = (String)async.get("fieldName");
                    Map filterCondition = (Map)props.get("filterCondition");
                    List conditions = (List)filterCondition.get("conditions");
                    if (!conditions.isEmpty()) {
                        String rel = filterCondition.get("rel").toString();
                        ArrayList<SuperQueryConditionDto> superQueryConditionDtos = new ArrayList<SuperQueryConditionDto>();
                        for (Map map : conditions) {
                            if (!"custom".equals(map.get("mode"))) continue;
                            SuperQueryConditionDto dto = new SuperQueryConditionDto();
                            dto.setField(map.get("field").toString());
                            dto.setMatch(rel.toUpperCase());
                            OperatorType operatorType = OperatorType.getByName((String)map.get("method").toString());
                            dto.setRule(operatorType.getValue());
                            if (map.get("value") instanceof List) {
                                List objects = (List)map.get("value");
                                String value = "";
                                for (int i = 0; i < objects.size(); ++i) {
                                    value = value + objects.get(i);
                                    if (i >= objects.size() - 1) continue;
                                    value = value + ",";
                                }
                                dto.setVal(value);
                            } else {
                                dto.setVal(map.get("value").toString());
                            }
                            superQueryConditionDtos.add(dto);
                        }
                        paramsData.put("superQueryConditionDto", superQueryConditionDtos);
                    }
                    ArrayList<QueryOrder> queryOrderList = new ArrayList<QueryOrder>();
                    List list = (List)props.get("optionSort");
                    for (Map sortMap : list) {
                        QueryOrder queryOrder = new QueryOrder();
                        queryOrder.setColumn(sortMap.get("column").toString());
                        queryOrder.setAsc((Boolean)sortMap.get("asc"));
                        queryOrderList.add(queryOrder);
                    }
                    if (!queryOrderList.isEmpty()) {
                        paramsData.put("orders", queryOrderList);
                    }
                    resList = this.queryOption((String)async.get("asyncType"), (String)async.get("appId"), (String)async.get("formId"), (String)async.get("uri"), (String)async.get("appCode"), (String)async.get("apiCode"), paramsData, queryFieldName);
                    break;
                }
                if ("static".equals(props.get("optionType"))) {
                    resList = (List)props.get("options");
                    break;
                }
                if (!"dataLinkage".equals(props.get("optionType"))) break;
                Map dataLinkage = (Map)props.get("dataLinkage");
                Map data = (Map)dataLinkage.get("data");
                HashMap<String, Object> paramsData = new HashMap<String, Object>();
                paramsData.put("size", Integer.MAX_VALUE);
                paramsData.put("current", 1);
                String queryFieldName = (String)data.get("fieldName");
                Map filterCondition = (Map)dataLinkage.get("filter");
                String rel = filterCondition.get("rel").toString();
                List conditions = (List)filterCondition.get("conditions");
                ArrayList<SuperQueryConditionDto> superQueryConditionDtos = new ArrayList<SuperQueryConditionDto>();
                for (Map map : conditions) {
                    if ("custom".equals(map.get("mode"))) {
                        SuperQueryConditionDto dto = new SuperQueryConditionDto();
                        dto.setField(map.get("field").toString());
                        dto.setMatch(rel.toUpperCase());
                        OperatorType operatorType = OperatorType.getByName((String)map.get("method").toString());
                        dto.setRule(operatorType.getValue());
                        if (map.get("value") instanceof List) {
                            List objects = (List)map.get("value");
                            String value = "";
                            for (int i = 0; i < objects.size(); ++i) {
                                value = value + objects.get(i);
                                if (i >= objects.size() - 1) continue;
                                value = value + ",";
                            }
                            dto.setVal(value);
                        } else {
                            dto.setVal(map.get("value").toString());
                        }
                        superQueryConditionDtos.add(dto);
                    }
                    SuperQueryConditionDto notNull = new SuperQueryConditionDto();
                    notNull.setRule(OperatorType.IS_NOT_NULL.getValue());
                    notNull.setMatch("AND");
                    notNull.setField(queryFieldName);
                    superQueryConditionDtos.add(notNull);
                }
                paramsData.put("superQueryConditionDto", superQueryConditionDtos);
                ArrayList<QueryOrder> queryOrderList = new ArrayList<QueryOrder>();
                QueryOrder queryOrder = new QueryOrder();
                switch (props.get("dataLinkageSort").toString()) {
                    case "1": {
                        queryOrder.setColumn(queryFieldName);
                        queryOrder.setAsc(Boolean.valueOf(true));
                        break;
                    }
                    case "2": {
                        queryOrder.setColumn(queryFieldName);
                        queryOrder.setAsc(Boolean.valueOf(false));
                        break;
                    }
                    case "3": {
                        queryOrder.setColumn("createTime_date");
                        queryOrder.setAsc(Boolean.valueOf(true));
                        break;
                    }
                    case "4": {
                        queryOrder.setColumn("createTime_date");
                        queryOrder.setAsc(Boolean.valueOf(false));
                        break;
                    }
                }
                queryOrderList.add(queryOrder);
                if (!queryOrderList.isEmpty()) {
                    paramsData.put("orders", queryOrderList);
                }
                resList = this.queryOption((String)data.get("asyncType"), (String)data.get("appId"), (String)data.get("formId"), (String)data.get("uri"), (String)data.get("appCode"), (String)data.get("apiCode"), paramsData, queryFieldName);
                break;
            }
        } else {
            paramMap.put("appId", queryMap.get("appId"));
            paramMap.put("formId", queryMap.get("formId"));
            HashMap<String, Serializable> paramsData = new HashMap<String, Serializable>();
            paramsData.put("size", Integer.valueOf(Integer.MAX_VALUE));
            paramsData.put("current", Integer.valueOf(1));
            HashMap groupAggregation = new HashMap();
            ArrayList<String> groupList = new ArrayList<String>();
            String labelName = this.getLabel(fieldName, fieldType);
            fieldName = this.getValue(fieldName, fieldType);
            groupList.add(fieldName);
            if (!labelName.equals(fieldName)) {
                groupList.add(labelName);
            }
            groupAggregation.put("group", groupList);
            paramsData.put("groupAggregation", groupAggregation);
            paramMap.put("params", paramsData);
            QueryChartDataDto queryChartDataDto = new QueryChartDataDto();
            queryChartDataDto.setParams(paramsData);
            queryChartDataDto.setAppId(queryMap.get("appId").toString());
            queryChartDataDto.setFormId(queryMap.get("formId").toString());
            ApiResponse response = this.panelChartService.formData(queryChartDataDto);
            if (response.isSuccess()) {
                List res = ((PageVo)response.getData()).getData();
                for (Map map : res) {
                    if (map == null) continue;
                    HashMap resMap = new HashMap();
                    resMap.put("label", map.get(labelName));
                    resMap.put("value", map.get(fieldName));
                    resList.add(resMap);
                }
            }
        }
        return resList;
    }

    private List<Map<String, Object>> queryOption(String asyncType, String appId, String formId, String uri, String appCode, String apiCode, Map<String, Object> paramsData, String queryFieldName) {
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        ApiResponse response = new ApiResponse();
        if (HussarUtils.equals((Object)asyncType, (Object)"currentApp") || HussarUtils.equals((Object)asyncType, (Object)"crossApp")) {
            response = this.hussarAppDataSourceService.queryAppBusinessData(formId, appId, paramsData);
        } else if (HussarUtils.equals((Object)asyncType, (Object)"dataSet")) {
            try {
                response = this.hussarAppDataSourceService.querySetBusinessData(formId, paramsData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (LcdpException e) {
                throw new RuntimeException(e);
            }
        } else {
            ApiResponse apiResponse = response = HussarUtils.equals((Object)asyncType, (Object)"externalAPI") ? this.hussarAppDataSourceService.queryAPIBusinessData(formId, appCode, apiCode, uri, paramsData) : ApiResponse.fail((String)"\u6570\u636e\u6e90\u7c7b\u578b\u65e0\u6548");
        }
        if (response.isSuccess()) {
            PageVo pageVo = (PageVo)((QueryBusinessDataVo)response.getData()).getBusinessData();
            List data = pageVo.getData();
            HashSet<String> set = new HashSet<String>();
            for (Map map : data) {
                if (map.get(queryFieldName) == null || set.contains(map.get(queryFieldName).toString())) continue;
                HashMap resMap = new HashMap();
                resMap.put("label", map.get(queryFieldName));
                resMap.put("value", map.get(queryFieldName));
                set.add(map.get(queryFieldName).toString());
                resList.add(resMap);
            }
        }
        return resList;
    }

    public Map<String, Object> queryDataChart(QueryDataJson queryDataJson) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        paramMap.put("type", queryDataJson.getType());
        paramMap.put("appId", queryDataJson.getAppId());
        paramMap.put("formId", queryDataJson.getFormId());
        paramMap.put("uri", queryDataJson.getUri());
        paramMap.put("appCode", queryDataJson.getAppCode());
        paramMap.put("apiCode", queryDataJson.getApiCode());
        Map<Object, Object> paramsData = new HashMap();
        String chartType = queryDataJson.getWidget().getChartType();
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        metrics.addAll(queryDataJson.getWidget().getMetrics());
        ArrayList<Dimension> xFields = queryDataJson.getWidget().getxFields();
        if ("progress_chart".equals(chartType)) {
            xFields = new ArrayList<Dimension>();
            if (HussarUtils.isNotEmpty((Object)queryDataJson.getWidget().getTargetValues()) && queryDataJson.getWidget().getTargetValues().size() > 0 && HussarUtils.isEmpty((Object)((Metric)queryDataJson.getWidget().getTargetValues().get(0)).getValue())) {
                metrics.addAll(queryDataJson.getWidget().getTargetValues());
                paramMap.put("params", paramsData);
            } else {
                data.put("staticTargetValue", ((Metric)queryDataJson.getWidget().getTargetValues().get(0)).getValue());
            }
        }
        paramsData = this.initAggregation(metrics, xFields, queryDataJson.getWidget().getyFields(), queryDataJson.getWidget().getFilter());
        if (queryDataJson.getLimit() != 0) {
            paramsData.put("size", queryDataJson.getLimit());
        } else {
            paramsData.put("size", Integer.MAX_VALUE);
        }
        paramsData.put("current", 1);
        paramMap.put("params", paramsData);
        QueryChartDataDto queryChartDataDto = new QueryChartDataDto();
        queryChartDataDto.setParams(paramsData);
        queryChartDataDto.setAppId(queryDataJson.getAppId());
        queryChartDataDto.setFormId(queryDataJson.getFormId());
        Map<String, Object> optionMap = new HashMap<String, Object>();
        ApiResponse response = this.panelChartService.formData(queryChartDataDto);
        if (response.isSuccess()) {
            List resList = ((PageVo)response.getData()).getData();
            for (Dimension dimension : xFields) {
                if (WidgetType.JXDNSwitch.getType().equals(dimension.getType())) {
                    Iterator textEntry = (List)dimension.getProps().get("textEntry");
                    for (Map resMap : resList) {
                        if ("".equals(resMap.get(dimension.getName())) || resMap.get(dimension.getName()) == null) continue;
                        Integer yesOrNo = Integer.parseInt(resMap.get(dimension.getName()).toString());
                        resMap.put(dimension.getName(), textEntry.get(yesOrNo));
                    }
                }
                if (WidgetType.DATE.getType().equals(dimension.getType())) {
                    for (Map resMap : resList) {
                        if (resMap.get(dimension.getName()) == null) continue;
                        String formatStr = dimension.getProps().get("format").toString();
                        LocalDateTime localDateTime = (LocalDateTime)resMap.get(dimension.getName());
                        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(formatStr);
                        resMap.put(dimension.getName(), dateTimeFormatter.format(localDateTime));
                    }
                }
                if (WidgetType.NUMBER.getType().equals(dimension.getType())) {
                    for (Map resMap : resList) {
                        String numStr;
                        if (resMap.get(dimension.getName()) == null || !(numStr = resMap.get(dimension.getName()).toString()).endsWith(".0")) continue;
                        resMap.put(dimension.getName(), numStr.substring(0, numStr.length() - 2));
                    }
                }
                if (!WidgetType.SELECT_MUL.getType().equals(dimension.getType()) && !WidgetType.CHECK_BOX_GROUP.getType().equals(dimension.getType())) continue;
                for (Map resMap : resList) {
                    String labelStr;
                    if (resMap.get(this.getLabel(dimension.getName(), dimension.getType())) == null || (labelStr = resMap.get(this.getLabel(dimension.getName(), dimension.getType())).toString()).length() <= 4) continue;
                    labelStr = labelStr.substring(2, labelStr.length() - 2).replace("\",\"", ",");
                    resMap.put(this.getLabel(dimension.getName(), dimension.getType()), labelStr);
                }
            }
            JSONArray json = JSONArray.parseArray((String)JSON.toJSONString((Object)resList));
            data.put("widget", queryDataJson.getWidget());
            data.put("dataMap", BeanUtil.mapToBean(paramsData, ParamsData.class, (boolean)false));
            data.put("json", json);
            AbstractPluginBaseRemoteService service = (AbstractPluginBaseRemoteService)SpringUtil.getBean((String)chartType, AbstractPluginBaseRemoteService.class);
            ConvertData newValue = new ConvertData(null, null, data);
            ConvertData convertData = service.convertPluginData(newValue);
            optionMap = (Map)convertData.getData();
        }
        return optionMap;
    }

    public Map<String, Object> queryDataTable(QueryDataJson queryDataJson) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        paramMap.put("type", queryDataJson.getType());
        paramMap.put("appId", queryDataJson.getAppId());
        paramMap.put("formId", queryDataJson.getFormId());
        paramMap.put("uri", queryDataJson.getUri());
        paramMap.put("appCode", queryDataJson.getAppCode());
        paramMap.put("apiCode", queryDataJson.getApiCode());
        Map<String, Object> paramsData = this.initAggregation(null, null, null, queryDataJson.getWidget().getFilter());
        paramsData.remove("groupAggregation");
        ArrayList<QueryOrder> queryOrderList = new ArrayList<QueryOrder>();
        for (ShowField field : queryDataJson.getWidget().getFields()) {
            QueryOrder queryOrder = new QueryOrder();
            queryOrder.setColumn(field.getName());
            if (field.getSort() == 1) {
                queryOrder.setAsc(Boolean.valueOf(true));
                queryOrderList.add(queryOrder);
                continue;
            }
            if (field.getSort() != -1) continue;
            queryOrder.setAsc(Boolean.valueOf(false));
            queryOrderList.add(queryOrder);
        }
        if (!queryOrderList.isEmpty()) {
            paramsData.put("orders", queryOrderList);
        }
        paramsData.put("size", queryDataJson.getLimit());
        paramsData.put("current", queryDataJson.getCurrent());
        paramMap.put("params", paramsData);
        ApiResponse response = new ApiResponse();
        if (HussarUtils.equals((Object)queryDataJson.getType(), (Object)DataType.FORM.getType())) {
            response = this.hussarAppDataSourceService.queryAppBusinessData(queryDataJson.getFormId(), queryDataJson.getAppId(), paramsData);
        } else if (HussarUtils.equals((Object)queryDataJson.getType(), (Object)DataType.DATASET.getType())) {
            try {
                response = this.hussarAppDataSourceService.querySetBusinessData(queryDataJson.getFormId(), paramsData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (LcdpException e) {
                throw new RuntimeException(e);
            }
        } else {
            response = HussarUtils.equals((Object)queryDataJson.getType(), (Object)DataType.EXTERNALAPI.getType()) ? this.hussarAppDataSourceService.queryAPIBusinessData(queryDataJson.getFormId(), queryDataJson.getAppCode(), queryDataJson.getApiCode(), queryDataJson.getUri(), paramsData) : ApiResponse.fail((String)"\u6570\u636e\u6e90\u7c7b\u578b\u65e0\u6548");
        }
        Map<String, Object> optionMap = new HashMap<String, Object>();
        if (response.isSuccess()) {
            PageVo businessData = (PageVo)((QueryBusinessDataVo)response.getData()).getBusinessData();
            String chartType = "data_table";
            List dataSourceDetail = ((QueryBusinessDataVo)response.getData()).getWidgetList();
            for (WidgetDTO widgetDTO : dataSourceDetail) {
                if (WidgetType.DATE.getType().equals(widgetDTO.getType())) {
                    for (Map map : businessData.getData()) {
                        if (map.get(widgetDTO.getName()) == null) continue;
                        String formatStr = widgetDTO.getProps().getString("format");
                        LocalDateTime localDateTime = (LocalDateTime)map.get(widgetDTO.getName());
                        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(formatStr);
                        map.put(widgetDTO.getName(), dateTimeFormatter.format(localDateTime));
                    }
                }
                if (WidgetType.NUMBER.getType().equals(widgetDTO.getType())) {
                    for (Map map : businessData.getData()) {
                        String numStr;
                        if (map.get(widgetDTO.getName()) == null || !(numStr = map.get(widgetDTO.getName()).toString()).endsWith(".0")) continue;
                        map.put(widgetDTO.getName(), numStr.substring(0, numStr.length() - 2));
                    }
                }
                if (!WidgetType.SELECT_MUL.getType().equals(widgetDTO.getType()) && !WidgetType.CHECK_BOX_GROUP.getType().equals(widgetDTO.getType())) continue;
                for (Map map : businessData.getData()) {
                    String labelStr;
                    if (map.get(this.getLabel(widgetDTO.getName(), widgetDTO.getType())) == null || (labelStr = map.get(this.getLabel(widgetDTO.getName(), widgetDTO.getType())).toString()).length() <= 4) continue;
                    labelStr = labelStr.substring(2, labelStr.length() - 2).replace("\",\"", ",");
                    map.put(this.getLabel(widgetDTO.getName(), widgetDTO.getType()), labelStr);
                }
            }
            JSONObject json = JSONObject.parseObject((String)JSON.toJSONString((Object)businessData));
            data.put("dataSourceDetail", dataSourceDetail);
            data.put("widget", queryDataJson.getWidget());
            data.put("dataMap", paramsData);
            data.put("json", json);
            data.put("formId", queryDataJson.getFormId());
            data.put("limit", queryDataJson.getLimit());
            data.put("current", queryDataJson.getCurrent());
            data.putAll(queryDataJson.getWidget().getRowsFilter());
            AbstractPluginBaseRemoteService service = (AbstractPluginBaseRemoteService)SpringUtil.getBean((String)chartType, AbstractPluginBaseRemoteService.class);
            ConvertData newValue = new ConvertData(null, null, data);
            ConvertData convertData = service.convertPluginData(newValue);
            optionMap = (Map)convertData.getData();
        }
        return optionMap;
    }

    public Map<String, Object> initAggregation(List<Metric> metrics, List<Dimension> xField, List<Dimension> yField, List<FilterData> filterDataList) {
        HashMap<String, Object> paramsData = new HashMap<String, Object>();
        GroupAggregation resGroupAggregation = new GroupAggregation();
        ArrayList<QueryOrder> groupOrders = new ArrayList<QueryOrder>();
        if (xField != null) {
            ArrayList<String> group = new ArrayList<String>();
            for (Dimension dimension : xField) {
                QueryOrder queryOrder;
                group.add(this.getLabel(dimension.getName(), dimension.getType()));
                resGroupAggregation.setGroup(group);
                if (dimension.getSort() == 1) {
                    queryOrder = new QueryOrder();
                    queryOrder.setColumn(dimension.getName());
                    queryOrder.setAsc(Boolean.valueOf(true));
                    groupOrders.add(queryOrder);
                    continue;
                }
                if (dimension.getSort() != -1) continue;
                queryOrder = new QueryOrder();
                queryOrder.setColumn(dimension.getName());
                queryOrder.setAsc(Boolean.valueOf(false));
                groupOrders.add(queryOrder);
            }
        }
        if (metrics != null) {
            HashMap<String, String> aggMap = new HashMap<String, String>();
            for (Metric obj : metrics) {
                String op = obj.getOp();
                String name = obj.getName() + "_agg";
                if (xField != null && xField.size() > 0) {
                    boolean isNotUnique = true;
                    block2: while (isNotUnique) {
                        for (int i = 0; i < xField.size(); ++i) {
                            if (xField.get(i).equals(name)) {
                                name = name + "a";
                                continue block2;
                            }
                            if (i != xField.size() - 1) continue;
                            isNotUnique = false;
                        }
                    }
                }
                if ("countDistinct".equals(op)) {
                    aggMap.put("COUNT( DISTINCT ${" + obj.getName() + "})", name);
                } else {
                    aggMap.put(op.toUpperCase() + "(${" + obj.getName() + "})", name);
                }
                resGroupAggregation.setAgg(aggMap);
                if (obj.getSort() == 1) {
                    QueryOrder queryOrder = new QueryOrder();
                    queryOrder.setColumn(obj.getName());
                    queryOrder.setAsc(Boolean.valueOf(true));
                    groupOrders.add(queryOrder);
                    continue;
                }
                if (obj.getSort() != -1) continue;
                QueryOrder queryOrder = new QueryOrder();
                queryOrder.setColumn(obj.getName());
                queryOrder.setAsc(Boolean.valueOf(false));
                groupOrders.add(queryOrder);
            }
        }
        if (groupOrders.size() > 0) {
            resGroupAggregation.setOrders(groupOrders);
        }
        if (HussarUtils.isNotEmpty(filterDataList)) {
            ArrayList<SuperQueryConditionDto> superQueryConditionDtos = new ArrayList<SuperQueryConditionDto>();
            for (FilterData filterData : filterDataList) {
                SuperQueryConditionDto dto = new SuperQueryConditionDto();
                dto.setField(this.getValue(filterData.getName(), filterData.getType()));
                dto.setMatch(filterData.getRel().toUpperCase());
                dto.setRule(filterData.getFilterItem().getMethod());
                String value = "";
                if (filterData.getFilterItem().getValue().length > 1) {
                    if (OperatorType.EQ.getValue().equals(filterData.getFilterItem().getMethod())) {
                        dto.setRule(OperatorType.IN.getValue());
                    }
                    if (OperatorType.NE.getValue().equals(filterData.getFilterItem().getMethod())) {
                        dto.setRule(OperatorType.NOT_IN.getValue());
                    }
                    if (OperatorType.USER_EQ.getValue().equals(filterData.getFilterItem().getMethod())) {
                        dto.setRule(OperatorType.USER_IN.getValue());
                    }
                    if (OperatorType.USER_NE.getValue().equals(filterData.getFilterItem().getMethod())) {
                        dto.setRule(OperatorType.USER_NOT_IN.getValue());
                    }
                }
                for (int i = 0; i < filterData.getFilterItem().getValue().length; ++i) {
                    value = value + filterData.getFilterItem().getValue()[i];
                    if (i >= filterData.getFilterItem().getValue().length - 1) continue;
                    value = value + ",";
                }
                dto.setVal(value);
                superQueryConditionDtos.add(dto);
            }
            paramsData.put("superQueryConditionDto", superQueryConditionDtos);
        }
        paramsData.put("groupAggregation", BeanUtil.beanToMap((Object)resGroupAggregation));
        return paramsData;
    }

    String getLabel(String name, String widgetType) {
        String res = name;
        switch (widgetType) {
            case "JXDNSelectMulti": 
            case "JXDNSelect": 
            case "JXDNRadioGroup": 
            case "JXDNCheckBoxGroup": 
            case "JXDNUser": 
            case "JXDNUserMulti": 
            case "JXDNOrg": 
            case "JXDNOrgMulti": 
            case "JXDNAddress": {
                res = name + "_label";
                break;
            }
        }
        return res;
    }

    String getValue(String name, String widgetType) {
        String res = name;
        switch (widgetType) {
            case "JXDNUser": 
            case "JXDNUserMulti": 
            case "JXDNOrg": 
            case "JXDNOrgMulti": {
                res = name + "_id";
                break;
            }
            case "JXDNAddress": {
                res = name + "_code";
                break;
            }
        }
        return res;
    }
}

