/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dashboard.service.impl;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.dashboard.dao.DashEntryRunMapper;
import com.jxdinfo.hussar.dashboard.json.DashboardJsonData;
import com.jxdinfo.hussar.dashboard.json.WidgetJsonData;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.run.plugin.base.service.support.RoutingPluginBaseRemoteService;
import com.jxdinfo.hussar.dashboard.service.IDashEntryRunService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class DashEntryRunServiceImpl
extends HussarServiceImpl<DashEntryRunMapper, DashEntry>
implements IDashEntryRunService {
    @Resource
    private DashEntryRunMapper dashEntryMapper;
    @Resource
    private RoutingPluginBaseRemoteService routingPluginBaseRemoteService;

    public DashboardJsonData getEntryInfo(Long panelId) {
        DashboardJsonData dashboardJsonData = this.getJsonData(panelId);
        return dashboardJsonData;
    }

    private DashboardJsonData getJsonData(Long panelId) {
        DashEntry dashEntry = (DashEntry)this.dashEntryMapper.selectById(panelId);
        if (HussarUtils.isNotEmpty((Object)dashEntry)) {
            DashboardJsonData dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), DashboardJsonData.class);
            if (dashboardJsonData == null) {
                dashboardJsonData = new DashboardJsonData();
            }
            dashboardJsonData.setGroupId(dashEntry.getGroupId());
            dashboardJsonData.setIcon(dashEntry.getIcon());
            Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)panelId);
            List dashEntryList = this.dashEntryMapper.selectList(wrapper);
            JSONArray components = new JSONArray();
            for (DashEntry dashEntryWidget : dashEntryList) {
                if (!HussarUtils.isNotBlank((CharSequence)dashEntryWidget.getEntryOption())) continue;
                WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)dashEntryWidget.getEntryOption(), WidgetJsonData.class);
                components.add((Object)widgetJsonData);
            }
            dashboardJsonData.setComponents(components);
            dashboardJsonData.setEntryName(dashEntry.getEntryName());
            return dashboardJsonData;
        }
        return null;
    }

    public WidgetJsonData getChartInfo(Long entryId) {
        WidgetJsonData widgetJsonData = new WidgetJsonData();
        DashEntry dashEntry = (DashEntry)this.dashEntryMapper.selectById(entryId);
        if (dashEntry != null) {
            widgetJsonData = (WidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), WidgetJsonData.class);
        }
        return widgetJsonData;
    }

    public List<DashEntry> selectList(Long entryId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)entryId);
        return this.dashEntryMapper.selectList(wrapper);
    }
}

