/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dashboard.service.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.dashboard.dao.DashEntryMapper;
import com.jxdinfo.hussar.dashboard.json.DashboardJsonData;
import com.jxdinfo.hussar.dashboard.json.WidgetJsonData;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.model.DashEntryHis;
import com.jxdinfo.hussar.dashboard.service.IDashEntryHisService;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class DashEntryServiceImpl
extends HussarServiceImpl<DashEntryMapper, DashEntry>
implements IDashEntryService {
    @Resource
    private DashEntryMapper dashEntryMapper;
    @Resource
    private IDashEntryHisService dashEntryHisService;
    @Resource
    private ISysFormService sysFormService;

    public Long savePanelData(DashEntry dashentry) {
        Long entryId = IdWorker.getId((Object)new DashEntry());
        dashentry.setEntryId(entryId);
        dashentry.setEntryType("panel");
        DashboardJsonData dashboardJsonData = new DashboardJsonData();
        dashboardJsonData.setPanelId(entryId);
        dashboardJsonData.setEntryName(dashentry.getEntryName());
        dashboardJsonData.setAppId(dashentry.getAppId());
        String jsonStr = JSONUtil.toJsonStr((cn.hutool.json.JSON)JSONUtil.parseObj((Object)dashboardJsonData, (boolean)false));
        dashentry.setEntryOption(jsonStr);
        this.dashEntryMapper.insert(dashentry);
        return entryId;
    }

    public Long saveWidgetData(DashEntry dashEntry) {
        Long entryId = IdWorker.getId((Object)new DashEntry());
        dashEntry.setEntryId(entryId);
        dashEntry.setParentId(null);
        dashEntry.setEntryType("widget");
        dashEntry.setEntryStatus("1");
        WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), WidgetJsonData.class);
        if (widgetJsonData != null) {
            widgetJsonData.setDataSourceId(dashEntry.getDatasourceId());
            widgetJsonData.setDataSourceName(dashEntry.getDatasourceName());
            widgetJsonData.setDataSourceType(dashEntry.getDatasourceType());
            widgetJsonData.setAppId(dashEntry.getAppId());
            widgetJsonData.setTitle(dashEntry.getEntryName());
            widgetJsonData.setEntryId(entryId);
        } else {
            widgetJsonData = new WidgetJsonData();
        }
        String jsonStr = JSONUtil.toJsonStr((cn.hutool.json.JSON)JSONUtil.parseObj((Object)widgetJsonData, (boolean)false));
        dashEntry.setEntryOption(JSONUtil.toJsonStr((Object)jsonStr));
        this.dashEntryMapper.insert(dashEntry);
        return entryId;
    }

    public Long updateWidgetData(String widgetInfo) {
        WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)widgetInfo, WidgetJsonData.class);
        DashEntry dashEntry = (DashEntry)this.dashEntryMapper.selectById(widgetJsonData.getEntryId());
        if (dashEntry != null) {
            dashEntry.setEntryName(widgetJsonData.getTitle());
            dashEntry.setDatasourceId(widgetJsonData.getDataSourceId());
            dashEntry.setDatasourceName(widgetJsonData.getDataSourceName());
            dashEntry.setDatasourceType(widgetJsonData.getDataSourceType());
            dashEntry.setEntryOption(JSONUtil.toJsonStr((Object)widgetJsonData));
            this.dashEntryMapper.updateById(dashEntry);
            return widgetJsonData.getEntryId();
        }
        return null;
    }

    public Boolean deleteData(Long entryId) {
        DashboardJsonData dashboardJsonData = this.getJsonData(entryId);
        DashEntryHis dashEntryHis = new DashEntryHis();
        dashEntryHis.setHisPanelId(entryId);
        dashEntryHis.setHisPanelOption(JSONUtil.toJsonStr((Object)dashboardJsonData));
        this.dashEntryHisService.save((Object)dashEntryHis);
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)entryId);
        List dashEntryList = this.dashEntryMapper.selectList(wrapper);
        for (DashEntry dashEntry : dashEntryList) {
            this.dashEntryMapper.deleteById(dashEntry.getEntryId());
        }
        this.dashEntryMapper.deleteById(entryId);
        return true;
    }

    private DashboardJsonData getJsonData(Long entryId) {
        DashEntry dashEntry = (DashEntry)this.dashEntryMapper.selectById(entryId);
        DashboardJsonData dashboardJsonData = (DashboardJsonData)JSONUtil.toBean((String)dashEntry.getEntryOption(), DashboardJsonData.class);
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)entryId);
        List dashEntryList = this.dashEntryMapper.selectList(wrapper);
        JSONArray components = new JSONArray();
        for (DashEntry dashEntryWidget : dashEntryList) {
            if (!HussarUtils.isNotBlank((CharSequence)dashEntryWidget.getEntryOption())) continue;
            WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)dashEntryWidget.getEntryOption(), WidgetJsonData.class);
            components.add((Object)widgetJsonData);
        }
        dashboardJsonData.setComponents(components);
        dashboardJsonData.setEntryName(dashEntry.getEntryName());
        return dashboardJsonData;
    }

    public Long copyWidget(String widgetInfo) {
        Long entryId = IdWorker.getId((Object)new DashEntry());
        WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)widgetInfo, WidgetJsonData.class);
        if (widgetJsonData != null) {
            DashEntry widget = (DashEntry)this.dashEntryMapper.selectById(widgetJsonData.getEntryId());
            DashEntry dashEntry = new DashEntry();
            dashEntry.setEntryId(entryId);
            dashEntry.setEntryName(widgetJsonData.getTitle());
            dashEntry.setParentId(widget != null ? widget.getParentId() : null);
            dashEntry.setDatasourceId(widgetJsonData.getDataSourceId());
            dashEntry.setDatasourceName(widgetJsonData.getDataSourceName());
            dashEntry.setDatasourceType(widgetJsonData.getDataSourceType());
            widgetJsonData.setEntryId(entryId);
            dashEntry.setEntryOption(JSONUtil.toJsonStr((Object)widgetJsonData));
            dashEntry.setEntryType("widget");
            this.dashEntryMapper.insert(dashEntry);
            return entryId;
        }
        return null;
    }

    public List<DashEntry> selectList(Long entryId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)entryId);
        return this.dashEntryMapper.selectList(wrapper);
    }

    public DashEntry copyPanel(Long entryId, String name) {
        DashEntry dashEntryPanel = (DashEntry)this.getById(entryId);
        Long copyPanelId = IdWorker.getId((Object)new DashEntry());
        dashEntryPanel.setEntryId(copyPanelId);
        dashEntryPanel.setEntryName(name);
        this.dashEntryMapper.insert(dashEntryPanel);
        List<DashEntry> widgetList = this.selectList(entryId);
        for (DashEntry widget : widgetList) {
            Long widgetId = IdWorker.getId((Object)new DashEntry());
            widget.setEntryId(widgetId);
            widget.setParentId(copyPanelId);
        }
        this.saveBatch(widgetList);
        return dashEntryPanel;
    }

    public boolean updatePanel(DashEntry dashEntry) {
        if (dashEntry != null) {
            DashEntry dashEntryNew = (DashEntry)this.dashEntryMapper.selectById(dashEntry.getEntryId());
            DashboardJsonData dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashEntryNew.getEntryOption(), DashboardJsonData.class);
            dashboardJsonData.setEntryName(dashEntry.getEntryName());
            String jsonStr = JSONUtil.toJsonStr((cn.hutool.json.JSON)JSONUtil.parseObj((Object)dashboardJsonData, (boolean)false));
            dashEntryNew.setEntryOption(jsonStr);
            dashEntryNew.setGroupId(dashEntry.getGroupId());
            dashEntryNew.setIcon(dashEntry.getIcon());
            dashEntryNew.setEntryName(dashEntry.getEntryName());
            this.dashEntryMapper.updateById(dashEntryNew);
            return true;
        }
        return false;
    }

    public boolean savePanel(String dashboardInfo) {
        DashboardJsonData dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashboardInfo, DashboardJsonData.class);
        if (dashboardJsonData == null) {
            return false;
        }
        Long panelId = dashboardJsonData.getPanelId();
        DashEntry dashEntry = (DashEntry)this.dashEntryMapper.selectById(panelId);
        if (dashEntry == null) {
            return false;
        }
        dashEntry.setEntryName(dashboardJsonData.getEntryName());
        String jsonStr = JSONUtil.toJsonStr((cn.hutool.json.JSON)JSONUtil.parseObj((Object)dashboardJsonData, (boolean)false));
        dashEntry.setEntryOption(jsonStr);
        this.dashEntryMapper.updateById(dashEntry);
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)panelId);
        SysFormDto sysFormDto = new SysFormDto();
        sysFormDto.setFormType(sysForm.getFormType());
        sysFormDto.setId(sysForm.getId());
        sysFormDto.setFormName(dashboardJsonData.getEntryName());
        sysFormDto.setSeq(sysFormDto.getSeq());
        sysFormDto.setFormStatus(sysForm.getFormStatus());
        sysFormDto.setFormGroupId(sysForm.getFormGroupId());
        sysFormDto.setTableName(sysForm.getTableName());
        sysFormDto.setAppId(sysForm.getAppId());
        sysFormDto.setAppName(sysFormDto.getAppName());
        sysFormDto.setFormIcon(sysFormDto.getFormIcon());
        sysFormDto.setFormIconType(sysFormDto.getFormIconType());
        sysFormDto.setFormIconColor(sysFormDto.getFormIconColor());
        sysFormDto.setExtname(sysFormDto.getExtname());
        this.sysFormService.editForm(sysFormDto);
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)panelId);
        List dashEntryList = this.dashEntryMapper.selectList(wrapper);
        if (dashEntryList.size() > 0) {
            for (DashEntry widgetInfo : dashEntryList) {
                this.dashEntryMapper.deleteById(widgetInfo.getEntryId());
            }
        }
        JSONArray jsonArray = dashboardJsonData.getComponents();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject component = jsonArray.getJSONObject((Object)i);
            String componentStr = JSONUtil.toJsonStr((cn.hutool.json.JSON)JSONUtil.parseObj((Object)component, (boolean)false));
            WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)componentStr, WidgetJsonData.class);
            if (widgetJsonData == null) continue;
            DashEntry widget = new DashEntry();
            if (widgetJsonData.getEntryId() == null) {
                widget.setEntryId(Long.valueOf(IdWorker.getId((Object)new DashEntry())));
                widgetJsonData.setEntryId(widget.getEntryId());
            } else {
                DashEntry oldDash = (DashEntry)this.dashEntryMapper.selectById(widgetJsonData.getEntryId());
                if (oldDash != null && HussarUtils.isEmpty((Object)oldDash.getParentId())) {
                    this.dashEntryMapper.deleteById(widgetJsonData.getEntryId());
                }
                widget.setEntryId(widgetJsonData.getEntryId());
            }
            widget.setEntryName(widgetJsonData.getTitle());
            widget.setParentId(panelId);
            widget.setEntryType("widget");
            widget.setDatasourceId(widgetJsonData.getDataSourceId());
            widget.setDatasourceName(widgetJsonData.getDataSourceName());
            widget.setDatasourceType(widgetJsonData.getDataSourceType());
            String jsonWidget = JSONUtil.toJsonStr((cn.hutool.json.JSON)JSONUtil.parseObj((Object)widgetJsonData, (boolean)false));
            widget.setEntryOption(jsonWidget);
            this.dashEntryMapper.insert(widget);
        }
        return true;
    }

    public void updateChartDatasource(Long newAppId, Long newFormId, Long oldFormId, String newDataSourceName, Integer newDatasourceType) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"DATASOURCE_ID", (Object)oldFormId);
        List dashEntryList = this.dashEntryMapper.selectList(wrapper);
        if (!dashEntryList.isEmpty()) {
            for (DashEntry dashEntry : dashEntryList) {
                dashEntry.setDatasourceName(newDataSourceName);
                dashEntry.setDatasourceId(newFormId);
                dashEntry.setDatasourceType(newDatasourceType);
                WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), WidgetJsonData.class);
                widgetJsonData.setDataSourceId(newFormId);
                widgetJsonData.setDataSourceName(newDataSourceName);
                widgetJsonData.setDataSourceType(newDatasourceType);
                widgetJsonData.setAppId(newAppId);
                String optionStr = JSON.toJSONString((Object)widgetJsonData);
                dashEntry.setEntryOption(optionStr);
            }
            this.saveOrUpdateBatch(dashEntryList);
        }
    }

    public void importPanelData(Long panelId, String formName, Long appId, List<DashEntry> dashEntryList) {
        for (int i = 0; i < dashEntryList.size(); ++i) {
            DashEntry dashEntry = dashEntryList.get(i);
            dashEntry.setAppId(appId);
            if (i == 0) {
                dashEntry.setEntryId(panelId);
                dashEntry.setEntryName(formName);
            } else {
                Long entryId = IdWorker.getId((Object)new DashEntry());
                dashEntry.setParentId(panelId);
                dashEntry.setEntryId(entryId);
                WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), WidgetJsonData.class);
                widgetJsonData.setEntryId(entryId);
                dashEntry.setEntryOption(JSON.toJSONString((Object)widgetJsonData));
            }
            this.saveOrUpdateBatch(dashEntryList);
        }
    }
}

