/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dashboard.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.dashboard.dao.DashEntryPubMapper;
import com.jxdinfo.hussar.dashboard.json.DashboardJsonData;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.model.DashEntryPub;
import com.jxdinfo.hussar.dashboard.properties.DashboardFeignProperties;
import com.jxdinfo.hussar.dashboard.service.IDashEntryPubService;
import com.jxdinfo.hussar.dashboard.service.IDashEntryRunService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class DashEntryPubServiceImpl
extends HussarServiceImpl<DashEntryPubMapper, DashEntryPub>
implements IDashEntryPubService {
    @Resource
    private DashEntryPubMapper dashEntryPubMapper;
    @Resource
    private IDashEntryRunService dashEntryService;
    @Resource
    DashboardFeignProperties dashboardFeignProperties;

    public Map<String, Object> publishPanel(DashEntryPub dashEntryPub, HttpServletRequest request) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String linkShortAddress = "";
        if (dashEntryPub.getLinkStatus() == 1) {
            String tcode;
            linkShortAddress = this.getShortAddress(6);
            int count = this.dashEntryPubMapper.selectData(linkShortAddress);
            if (count > 0) {
                return dataMap;
            }
            DashboardJsonData dashboardJsonData = this.getJsonData(dashEntryPub.getPanelId());
            Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)dashEntryPub.getPanelId());
            DashEntryPub pub = (DashEntryPub)this.dashEntryPubMapper.selectOne(wrapper);
            if (pub == null) {
                dashEntryPub.setLinkShortAddress(linkShortAddress);
                JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)dashboardJsonData));
                String jsonStr = JSON.toJSONString((Object)jsonObject);
                dashEntryPub.setPubPanelOption(jsonStr);
                this.dashEntryPubMapper.insert(dashEntryPub);
            } else {
                dashEntryPub.setPubPanelId(pub.getPubPanelId());
                JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)dashboardJsonData));
                String jsonStr = JSON.toJSONString((Object)jsonObject);
                dashEntryPub.setPubPanelOption(jsonStr);
                dashEntryPub.setLinkShortAddress(linkShortAddress);
                this.dashEntryPubMapper.updateById(dashEntryPub);
            }
            String openLink = this.dashboardFeignProperties.getFrontIp() + "/" + this.dashboardFeignProperties.getPublicOpen() + "/" + linkShortAddress;
            if (HussarUtils.isNotEmpty((Object)request) && HussarUtils.isNotEmpty((Object)(tcode = request.getHeader("Tcode")))) {
                openLink = openLink + "?tcode=" + tcode;
            }
            dataMap.put("linkAddress", openLink);
            dataMap.put("linkShortAddress", linkShortAddress);
            return dataMap;
        }
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)dashEntryPub.getPanelId());
        DashEntryPub pub = (DashEntryPub)this.dashEntryPubMapper.selectOne(wrapper);
        dashEntryPub.setPubPanelId(pub.getPubPanelId());
        this.dashEntryPubMapper.updateById(dashEntryPub);
        return dataMap;
    }

    public String getHasPass(DashEntryPub dashEntryPub) {
        String linkPass = "";
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)dashEntryPub.getPanelId());
        DashEntryPub pub = (DashEntryPub)this.dashEntryPubMapper.selectOne(wrapper);
        pub.setHasPass(dashEntryPub.getHasPass());
        if (dashEntryPub.getHasPass() == 1) {
            linkPass = this.getShortAddress(6);
            pub.setLinkPass(linkPass);
        } else {
            pub.setHasPass(dashEntryPub.getHasPass());
            pub.setLinkPass("");
        }
        this.dashEntryPubMapper.updateById(pub);
        return linkPass;
    }

    private DashboardJsonData getJsonData(Long entryId) {
        DashEntry dashEntry = (DashEntry)this.dashEntryService.getById((Serializable)entryId);
        DashboardJsonData dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), DashboardJsonData.class);
        List dashEntryList = this.dashEntryService.selectList(entryId);
        JSONArray components = new JSONArray();
        for (DashEntry dashEntryWidget : dashEntryList) {
            if (!HussarUtils.isNotBlank((CharSequence)dashEntryWidget.getEntryOption())) continue;
            Map widgetJsonData = (Map)JSON.parse((String)dashEntryWidget.getEntryOption());
            components.add((Object)widgetJsonData);
        }
        dashboardJsonData.setComponents(components);
        dashboardJsonData.setEntryName(dashEntry.getEntryName());
        return dashboardJsonData;
    }

    private String getShortAddress(int length) {
        String characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(characters.charAt(random.nextInt(characters.length())));
        }
        return sb.toString();
    }

    @HussarDs(value="#tcode")
    public String getRedirectToDashPath(String shortAddress, String tcode, HttpServletRequest request) {
        String address = "";
        if (HussarUtils.isEmpty((Object)shortAddress)) {
            throw new BaseException("\u4eea\u8868\u76d8\u5916\u94fe\u77ed\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"LINK_SHORT_ADDRESS", (Object)(shortAddress = shortAddress.substring(0, 6)));
        DashEntryPub dashEntryPub = (DashEntryPub)this.getOne(wrapper);
        if (HussarUtils.isNotEmpty((Object)dashEntryPub)) {
            String userAgent = request.getHeader("User-Agent");
            if (userAgent.contains("Android") || userAgent.contains("iPhone") || userAgent.contains("iPad") || userAgent.contains("Mobile")) {
                String moveAddress = dashEntryPub.getLinkAddress() != null ? dashEntryPub.getLinkAddress().replace("public-board", "public-board-m") : dashEntryPub.getLinkAddress();
                address = this.dashboardFeignProperties.getFrontIp() + moveAddress + "/" + shortAddress;
            } else {
                address = this.dashboardFeignProperties.getFrontIp() + dashEntryPub.getLinkAddress() + "/" + shortAddress;
            }
            if (HussarUtils.isNotEmpty((Object)tcode)) {
                address = address + "?tcode=" + tcode;
            }
        } else {
            address = this.dashboardFeignProperties.getFrontIp() + "/404";
        }
        return address;
    }

    public boolean checkPwd(String linkShortAddress, String pwd) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"LINK_SHORT_ADDRESS", (Object)linkShortAddress);
        DashEntryPub dashEntryPub = (DashEntryPub)this.getOne(wrapper);
        return HussarUtils.isNotEmpty((Object)dashEntryPub) && pwd.equals(dashEntryPub.getLinkPass());
    }

    public boolean verifyStatus(String linkShortAddress, String panelId) {
        Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"LINK_SHORT_ADDRESS", (Object)linkShortAddress)).eq((Object)"ENTRY_ID", (Object)panelId)).eq((Object)"LINK_STATUS", (Object)"1");
        DashEntryPub dashEntryPub = (DashEntryPub)this.getOne(wrapper);
        return dashEntryPub != null;
    }

    public boolean isLinkPass(String panelId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)panelId);
        DashEntryPub dashEntryPub = (DashEntryPub)this.getOne(wrapper);
        if (dashEntryPub == null) {
            return false;
        }
        return dashEntryPub.getHasPass() == 1;
    }

    public boolean verifyLinkPass(String panelId, String linkPass) {
        Wrapper wrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)panelId)).eq((Object)"LINK_PASS", (Object)linkPass);
        DashEntryPub dashEntryPub = (DashEntryPub)this.getOne(wrapper);
        return dashEntryPub != null;
    }

    public DashboardJsonData getEntryInfo(Long panelId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)panelId);
        DashEntryPub dashEntryPub = (DashEntryPub)this.getOne(wrapper);
        DashboardJsonData dashboardJsonData = null;
        if (dashEntryPub != null) {
            dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashEntryPub.getPubPanelOption(), DashboardJsonData.class);
        }
        return dashboardJsonData;
    }
}

