/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dashboard.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.dashboard.dao.DashEntryMapper;
import com.jxdinfo.hussar.dashboard.json.DashboardJsonData;
import com.jxdinfo.hussar.dashboard.json.WidgetJsonData;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.model.DashEntryHis;
import com.jxdinfo.hussar.dashboard.service.IDashEntryHisService;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class DashEntryServiceImpl
extends HussarServiceImpl<DashEntryMapper, DashEntry>
implements IDashEntryService {
    @Resource
    private DashEntryMapper dashEntryMapper;
    @Resource
    private IDashEntryHisService dashEntryHisService;
    @Resource
    private ISysFormService sysFormService;

    public Long savePanelData(DashEntry dashentry) {
        Long entryId = IdWorker.getId((Object)new DashEntry());
        dashentry.setEntryId(entryId);
        dashentry.setEntryType("panel");
        DashboardJsonData dashboardJsonData = new DashboardJsonData();
        dashboardJsonData.setPanelId(entryId);
        dashboardJsonData.setEntryName(dashentry.getEntryName());
        dashboardJsonData.setAppId(dashentry.getAppId());
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)dashboardJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject);
        dashentry.setEntryOption(jsonStr);
        this.dashEntryMapper.insert(dashentry);
        return entryId;
    }

    public Long saveWidgetData(DashEntry dashEntry) {
        Long entryId = IdWorker.getId((Object)new DashEntry());
        dashEntry.setEntryId(entryId);
        dashEntry.setParentId(null);
        dashEntry.setEntryType("widget");
        dashEntry.setEntryStatus("1");
        WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), WidgetJsonData.class);
        if (widgetJsonData != null) {
            widgetJsonData.setDataSourceId(dashEntry.getDatasourceId());
            widgetJsonData.setDataSourceName(dashEntry.getDatasourceName());
            widgetJsonData.setDataSourceType(dashEntry.getDatasourceType());
            widgetJsonData.setAppId(dashEntry.getAppId());
            widgetJsonData.setTitle(dashEntry.getEntryName());
            widgetJsonData.setEntryId(entryId);
            widgetJsonData.setRel("and");
        } else {
            widgetJsonData = new WidgetJsonData();
        }
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)widgetJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject);
        dashEntry.setEntryOption(jsonStr);
        this.dashEntryMapper.insert(dashEntry);
        return entryId;
    }

    public Long updateWidgetData(String widgetInfo) {
        WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)widgetInfo, WidgetJsonData.class);
        DashEntry dashEntry = (DashEntry)this.dashEntryMapper.selectById(widgetJsonData.getEntryId());
        if (dashEntry != null) {
            dashEntry.setEntryName(widgetJsonData.getTitle());
            dashEntry.setDatasourceId(widgetJsonData.getDataSourceId());
            dashEntry.setDatasourceName(widgetJsonData.getDataSourceName());
            dashEntry.setDatasourceType(widgetJsonData.getDataSourceType());
            Map map = (Map)JSON.parse((String)widgetInfo);
            String jsonStr = JSON.toJSONString((Object)map);
            dashEntry.setEntryOption(jsonStr);
            this.dashEntryMapper.updateById(dashEntry);
            return widgetJsonData.getEntryId();
        }
        return null;
    }

    public Boolean deleteData(Long entryId) {
        DashboardJsonData dashboardJsonData = this.getJsonData(entryId);
        DashEntryHis dashEntryHis = new DashEntryHis();
        dashEntryHis.setHisPanelId(entryId);
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)dashboardJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject);
        dashEntryHis.setHisPanelOption(jsonStr);
        this.dashEntryHisService.save((Object)dashEntryHis);
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)entryId);
        List dashEntryList = this.dashEntryMapper.selectList(wrapper);
        for (DashEntry dashEntry : dashEntryList) {
            this.dashEntryMapper.deleteById(dashEntry.getEntryId());
        }
        this.dashEntryMapper.deleteById(entryId);
        return true;
    }

    private DashboardJsonData getJsonData(Long entryId) {
        DashEntry dashEntry = (DashEntry)this.dashEntryMapper.selectById(entryId);
        DashboardJsonData dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), DashboardJsonData.class);
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)entryId);
        List dashEntryList = this.dashEntryMapper.selectList(wrapper);
        JSONArray components = new JSONArray();
        for (DashEntry dashEntryWidget : dashEntryList) {
            if (!HussarUtils.isNotBlank((CharSequence)dashEntryWidget.getEntryOption())) continue;
            Map widgetJsonData = (Map)JSON.parse((String)dashEntryWidget.getEntryOption());
            components.add((Object)widgetJsonData);
        }
        dashboardJsonData.setComponents(components);
        dashboardJsonData.setEntryName(dashEntry.getEntryName());
        return dashboardJsonData;
    }

    public Long copyWidget(String widgetInfo) {
        Long entryId = IdWorker.getId((Object)new DashEntry());
        WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)widgetInfo, WidgetJsonData.class);
        if (widgetJsonData != null) {
            DashEntry widget = (DashEntry)this.dashEntryMapper.selectById(widgetJsonData.getEntryId());
            DashEntry dashEntry = new DashEntry();
            dashEntry.setEntryId(entryId);
            dashEntry.setEntryName(widgetJsonData.getTitle());
            dashEntry.setParentId(widget != null ? widget.getParentId() : null);
            dashEntry.setDatasourceId(widgetJsonData.getDataSourceId());
            dashEntry.setDatasourceName(widgetJsonData.getDataSourceName());
            dashEntry.setDatasourceType(widgetJsonData.getDataSourceType());
            widgetJsonData.setEntryId(entryId);
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)widgetJsonData));
            String jsonStr = JSON.toJSONString((Object)jsonObject);
            dashEntry.setEntryOption(jsonStr);
            dashEntry.setEntryType("widget");
            this.dashEntryMapper.insert(dashEntry);
            return entryId;
        }
        return null;
    }

    public List<DashEntry> selectList(Long entryId) {
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)entryId);
        return this.dashEntryMapper.selectList(wrapper);
    }

    public DashEntry copyPanel(Long entryId, String name) {
        WidgetJsonData widgetJsonData;
        DashEntry dashEntryPanel = (DashEntry)this.getById(entryId);
        Long copyPanelId = IdWorker.getId((Object)new DashEntry());
        dashEntryPanel.setEntryId(copyPanelId);
        dashEntryPanel.setEntryName(name);
        List<DashEntry> widgetList = this.selectList(entryId);
        ArrayList<DashEntry> filterList = new ArrayList<DashEntry>();
        HashMap<Long, Long> entryIdMap = new HashMap<Long, Long>();
        JSONArray componentsArray = new JSONArray();
        for (DashEntry widget : widgetList) {
            Long widgetId = IdWorker.getId((Object)new DashEntry());
            entryIdMap.put(widget.getEntryId(), widgetId);
            widget.setEntryId(widgetId);
            widget.setParentId(copyPanelId);
            widgetJsonData = (WidgetJsonData)JSON.parseObject((String)widget.getEntryOption(), WidgetJsonData.class);
            if (widgetJsonData == null) continue;
            if ("board_filter".equals(widgetJsonData.getType())) {
                filterList.add(widget);
                continue;
            }
            entryIdMap.put(widget.getEntryId(), widgetId);
            widgetJsonData.setEntryId(widgetId);
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)widgetJsonData));
            String jsonStr = JSON.toJSONString((Object)jsonObject);
            widget.setEntryOption(jsonStr);
            componentsArray.add((Object)widgetJsonData);
            this.dashEntryMapper.insert(widget);
        }
        for (DashEntry dashEntry : filterList) {
            Long filterId = IdWorker.getId((Object)new DashEntry());
            dashEntry.setParentId(copyPanelId);
            dashEntry.setEntryId(filterId);
            widgetJsonData = (WidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), WidgetJsonData.class);
            widgetJsonData.setEntryId(filterId);
            JSONArray triggers = widgetJsonData.getProps().getJSONArray("triggers");
            JSONArray newTriggers = new JSONArray();
            for (Object obj : triggers) {
                String trigger = obj.toString();
                if (entryIdMap.get(Long.parseLong(trigger)) != null) {
                    newTriggers.add((Object)((Long)entryIdMap.get(Long.parseLong(trigger))).toString());
                    continue;
                }
                newTriggers.add((Object)trigger);
            }
            widgetJsonData.getProps().put("triggers", (Object)newTriggers);
            JSONArray fields = widgetJsonData.getProps().getJSONArray("fields");
            JSONArray newFields = new JSONArray();
            for (Object obj : fields) {
                Map map = (Map)obj;
                if (entryIdMap.get(Long.parseLong((String)map.get("entryId"))) != null) {
                    map.put("entryId", ((Long)entryIdMap.get(Long.parseLong(((String)map.get("entryId")).toString()))).toString());
                }
                newFields.add((Object)map);
            }
            widgetJsonData.getProps().put("fields", (Object)newFields);
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)widgetJsonData));
            String jsonStr = JSON.toJSONString((Object)jsonObject);
            dashEntry.setEntryOption(jsonStr);
            componentsArray.add((Object)widgetJsonData);
            this.dashEntryMapper.insert(dashEntry);
        }
        DashboardJsonData dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashEntryPanel.getEntryOption(), DashboardJsonData.class);
        dashboardJsonData.setPanelId(copyPanelId);
        dashboardJsonData.setEntryName(name);
        dashboardJsonData.setComponents(componentsArray);
        dashboardJsonData.setPublicConfig(null);
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)dashboardJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject);
        dashEntryPanel.setEntryOption(jsonStr);
        this.dashEntryMapper.insert(dashEntryPanel);
        return dashEntryPanel;
    }

    public boolean updatePanel(DashEntry dashEntry) {
        if (dashEntry != null) {
            DashEntry dashEntryNew = (DashEntry)this.dashEntryMapper.selectById(dashEntry.getEntryId());
            DashboardJsonData dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashEntryNew.getEntryOption(), DashboardJsonData.class);
            dashboardJsonData.setEntryName(dashEntry.getEntryName());
            String jsonStr = JSON.toJSONString((Object)dashboardJsonData);
            dashEntryNew.setEntryOption(jsonStr);
            dashEntryNew.setGroupId(dashEntry.getGroupId());
            dashEntryNew.setIcon(dashEntry.getIcon());
            dashEntryNew.setEntryName(dashEntry.getEntryName());
            this.dashEntryMapper.updateById(dashEntryNew);
            return true;
        }
        return false;
    }

    public boolean savePanel(String dashboardInfo) {
        DashboardJsonData dashboardJsonData = (DashboardJsonData)JSON.parseObject((String)dashboardInfo, DashboardJsonData.class);
        if (dashboardJsonData == null) {
            return false;
        }
        Long panelId = dashboardJsonData.getPanelId();
        DashEntry dashEntry = (DashEntry)this.dashEntryMapper.selectById(panelId);
        if (dashEntry == null) {
            return false;
        }
        dashEntry.setEntryName(dashboardJsonData.getEntryName());
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)dashboardJsonData));
        String jsonStr = JSON.toJSONString((Object)jsonObject);
        dashEntry.setEntryOption(jsonStr);
        this.dashEntryMapper.updateById(dashEntry);
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)panelId);
        SysFormDto sysFormDto = new SysFormDto();
        sysFormDto.setFormType(sysForm.getFormType());
        sysFormDto.setId(sysForm.getId());
        sysFormDto.setFormName(dashboardJsonData.getEntryName());
        sysFormDto.setSeq(sysFormDto.getSeq());
        sysFormDto.setFormStatus(sysForm.getFormStatus());
        sysFormDto.setFormGroupId(sysForm.getFormGroupId());
        sysFormDto.setTableName(sysForm.getTableName());
        sysFormDto.setAppId(sysForm.getAppId());
        sysFormDto.setAppName(sysFormDto.getAppName());
        sysFormDto.setFormIcon(sysFormDto.getFormIcon());
        sysFormDto.setFormIconType(sysFormDto.getFormIconType());
        sysFormDto.setFormIconColor(sysFormDto.getFormIconColor());
        sysFormDto.setExtname(sysFormDto.getExtname());
        this.sysFormService.editForm(sysFormDto);
        Wrapper wrapper = (Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)panelId);
        List dashEntryList = this.dashEntryMapper.selectList(wrapper);
        if (dashEntryList.size() > 0) {
            for (DashEntry widgetInfo : dashEntryList) {
                this.dashEntryMapper.deleteById(widgetInfo.getEntryId());
            }
        }
        JSONArray jsonArray = dashboardJsonData.getComponents();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject component = jsonArray.getJSONObject(i);
            String componentStr = JSON.toJSONString((Object)component);
            WidgetJsonData widgetJsonData = (WidgetJsonData)JSON.parseObject((String)componentStr, WidgetJsonData.class);
            if (widgetJsonData == null) continue;
            DashEntry widget = new DashEntry();
            if (widgetJsonData.getEntryId() == null) {
                widget.setEntryId(Long.valueOf(IdWorker.getId((Object)new DashEntry())));
                widgetJsonData.setEntryId(widget.getEntryId());
            } else {
                DashEntry oldDash = (DashEntry)this.dashEntryMapper.selectById(widgetJsonData.getEntryId());
                if (oldDash != null && HussarUtils.isEmpty((Object)oldDash.getParentId())) {
                    this.dashEntryMapper.deleteById(widgetJsonData.getEntryId());
                }
                widget.setEntryId(widgetJsonData.getEntryId());
            }
            widget.setEntryName(widgetJsonData.getTitle());
            widget.setParentId(panelId);
            widget.setEntryType("widget");
            widget.setDatasourceId(widgetJsonData.getDataSourceId());
            widget.setDatasourceName(widgetJsonData.getDataSourceName());
            widget.setDatasourceType(widgetJsonData.getDataSourceType());
            JSONObject jsonObject2 = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)widgetJsonData));
            String jsonStr2 = JSON.toJSONString((Object)jsonObject2);
            widget.setEntryOption(jsonStr2);
            this.dashEntryMapper.insert(widget);
        }
        return true;
    }

    public void importPanelData(Long panelId, String icon, String groupId, String formName, Long appId, List<DashEntry> dashEntryList, Map<Long, Long> formIdMap) {
        WidgetJsonData widgetJsonData;
        DashboardJsonData panelJsonData = null;
        JSONArray components = new JSONArray();
        HashMap<Long, Long> entryIdMapping = new HashMap<Long, Long>();
        ArrayList<DashEntry> filterList = new ArrayList<DashEntry>();
        ArrayList<DashEntry> newEntryList = new ArrayList<DashEntry>();
        for (int i = 0; i < dashEntryList.size(); ++i) {
            DashEntry dashEntry = dashEntryList.get(i);
            dashEntry.setAppId(appId);
            if ("panel".equals(dashEntry.getEntryType())) {
                dashEntry.setEntryId(panelId);
                panelJsonData = (DashboardJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), DashboardJsonData.class);
                panelJsonData.setPanelId(panelId);
                panelJsonData.setAppId(appId);
                panelJsonData.setPublicConfig(null);
                if (formName != null) {
                    panelJsonData.setEntryName(formName);
                    dashEntry.setEntryName(formName);
                }
                if (icon != null) {
                    panelJsonData.setIcon(icon);
                    dashEntry.setIcon(icon);
                }
                if (groupId != null) {
                    panelJsonData.setGroupId(groupId);
                    dashEntry.setGroupId(groupId);
                }
                newEntryList.add(dashEntry);
                continue;
            }
            widgetJsonData = (WidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), WidgetJsonData.class);
            if (!"board_filter".equals(widgetJsonData.getType())) {
                Boolean flag = false;
                Long dataSourceId = dashEntry.getDatasourceId();
                if (formIdMap != null) {
                    for (Long key : formIdMap.keySet()) {
                        if (dashEntry.getDatasourceId() == null || !dashEntry.getDatasourceId().equals(key)) continue;
                        flag = true;
                        dataSourceId = formIdMap.get(key);
                    }
                }
                Long entryId = IdWorker.getId((Object)new DashEntry());
                entryIdMapping.put(dashEntry.getEntryId(), entryId);
                dashEntry.setParentId(panelId);
                dashEntry.setEntryId(entryId);
                widgetJsonData.setEntryId(entryId);
                widgetJsonData.setAppId(appId);
                if (flag.booleanValue()) {
                    dashEntry.setDatasourceId(dataSourceId);
                    widgetJsonData.setDataSourceId(dataSourceId);
                }
                components.add((Object)widgetJsonData);
                Iterator jsonObject = (JSONObject)JSON.toJSON((Object)BeanUtil.beanToMap((Object)widgetJsonData));
                String jsonStr = JSON.toJSONString((Object)jsonObject);
                dashEntry.setEntryOption(jsonStr);
                newEntryList.add(dashEntry);
                continue;
            }
            filterList.add(dashEntry);
        }
        for (DashEntry dashEntry : filterList) {
            widgetJsonData = (WidgetJsonData)JSON.parseObject((String)dashEntry.getEntryOption(), WidgetJsonData.class);
            Long entryId = IdWorker.getId((Object)new DashEntry());
            entryIdMapping.put(dashEntry.getEntryId(), entryId);
            dashEntry.setParentId(panelId);
            dashEntry.setEntryId(entryId);
            widgetJsonData.setEntryId(entryId);
            JSONArray triggers = widgetJsonData.getProps().getJSONArray("triggers");
            JSONArray newTriggers = new JSONArray();
            for (Object obj : triggers) {
                String trigger = obj.toString();
                if (entryIdMapping.get(Long.parseLong(trigger)) != null) {
                    newTriggers.add((Object)((Long)entryIdMapping.get(Long.parseLong(trigger))).toString());
                    continue;
                }
                newTriggers.add((Object)trigger);
            }
            widgetJsonData.getProps().put("triggers", (Object)newTriggers);
            JSONArray fields = widgetJsonData.getProps().getJSONArray("fields");
            JSONArray newFields = new JSONArray();
            for (Object obj : fields) {
                Map map = (Map)obj;
                if (entryIdMapping.get(Long.parseLong((String)map.get("entryId"))) != null) {
                    map.put("entryId", ((Long)entryIdMapping.get(Long.parseLong(((String)map.get("entryId")).toString()))).toString());
                }
                if (formIdMap != null) {
                    for (Long key : formIdMap.keySet()) {
                        Long id = Long.parseLong((String)map.get("dataSourceId"));
                        if (!id.equals(key)) continue;
                        map.put("dataSourceId", id.toString());
                    }
                }
                newFields.add((Object)map);
            }
            widgetJsonData.getProps().put("fields", (Object)newFields);
            JSONObject filter = widgetJsonData.getProps().getJSONObject("filter");
            if (formIdMap != null) {
                for (Long key : formIdMap.keySet()) {
                    Long id = Long.parseLong(filter.get((Object)"dataSourceId").toString());
                    if (!id.equals(key)) continue;
                    filter.put("dataSourceId", (Object)id.toString());
                }
            }
            widgetJsonData.getProps().put("filter", (Object)filter);
            components.add((Object)widgetJsonData);
            dashEntry.setEntryOption(JSON.toJSONString((Object)widgetJsonData));
        }
        newEntryList.addAll(filterList);
        panelJsonData.setComponents(components);
        ((DashEntry)newEntryList.get(0)).setEntryOption(JSON.toJSONString(panelJsonData));
        this.saveOrUpdateBatch(newEntryList);
    }
}

