/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.custom.table.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.custom.table.dao.CustomTableMapper;
import com.jxdinfo.hussar.custom.table.enums.CustomExceptionEnums;
import com.jxdinfo.hussar.custom.table.model.CustomCondition;
import com.jxdinfo.hussar.custom.table.model.CustomTable;
import com.jxdinfo.hussar.custom.table.service.CustomTableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import org.springframework.stereotype.Service;

@Service
public class CustomTableServiceImpl
extends HussarServiceImpl<CustomTableMapper, CustomTable>
implements CustomTableService {
    public ApiResponse<CustomTable> queryList(String pageId, String componentId) {
        CustomTable customTable = null;
        try {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            if (ToolUtil.isNotEmpty((Object)securityUser)) {
                customTable = (CustomTable)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomTable::getUserId, (Object)securityUser.getId())).eq(CustomTable::getPageId, (Object)pageId)).eq(CustomTable::getComponentId, (Object)componentId));
            }
            if (customTable != null) {
                return ApiResponse.success(customTable);
            }
            return ApiResponse.success((String)CustomExceptionEnums.CUSTOM_FAIL.getValue());
        }
        catch (Exception e) {
            throw new HussarException(CustomExceptionEnums.CUSTOM_DATA_ACQUISITION_FAILED.getValue());
        }
    }

    @DSTransactional
    public ApiResponse<String> insertOrUpdate(CustomCondition customCondition) {
        try {
            boolean flag;
            CustomTable customTable = null;
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            if (ToolUtil.isNotEmpty((Object)securityUser)) {
                customTable = (CustomTable)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomTable::getUserId, (Object)securityUser.getId())).eq(CustomTable::getPageId, (Object)customCondition.getPageId())).eq(CustomTable::getComponentId, (Object)customCondition.getComponentId()));
                if (customTable == null) {
                    customTable = new CustomTable();
                    customTable.setUserId(securityUser.getId());
                    customTable.setPageId(customCondition.getPageId());
                    customTable.setComponentId(customCondition.getComponentId());
                    customTable.setComponentInfo(customCondition.getComponentInfo());
                    customTable.setCreator(securityUser.getId());
                    customTable.setCreateTime(LocalDateTime.now());
                    customTable.setLastEditor(securityUser.getId());
                    customTable.setLastTime(LocalDateTime.now());
                } else {
                    customTable.setComponentInfo(customCondition.getComponentInfo());
                    customTable.setLastEditor(securityUser.getId());
                    customTable.setLastTime(LocalDateTime.now());
                }
            }
            if (flag = this.saveOrUpdate((BaseEntity)customTable)) {
                return ApiResponse.success((String)CustomExceptionEnums.CUSTOM_SAVE_SUCCESS.getValue());
            }
            return ApiResponse.success((String)CustomExceptionEnums.CUSTOM_SAVE_FAIL.getValue());
        }
        catch (Exception e) {
            throw new HussarException(CustomExceptionEnums.CUSTOM_SAVE_FAIL.getValue());
        }
    }
}

