/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.custom.fields.settings.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.custom.fields.settings.dao.CustomFieldsMapper;
import com.jxdinfo.hussar.custom.fields.settings.dto.CustomFieldsDto;
import com.jxdinfo.hussar.custom.fields.settings.model.CustomFields;
import com.jxdinfo.hussar.custom.fields.settings.service.CustomFieldsService;
import com.jxdinfo.hussar.custom.fields.settings.vo.CustomFieldsVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@HussarTokenDs
@Service
public class CustomFieldsServiceImpl
extends HussarServiceImpl<CustomFieldsMapper, CustomFields>
implements CustomFieldsService {
    private static final String RETURN_CODE = "0";
    @Autowired
    private CustomFieldsMapper customFieldsMapper;

    public ApiResponse<String> insertOrUpdate(CustomFields customFields) {
        if (customFields.getId() == null) {
            customFields.setCreator(BaseSecurityUtil.getUser().getId());
            customFields.setDelFlag(RETURN_CODE);
        }
        customFields.setLastEditor(BaseSecurityUtil.getUser().getId());
        boolean flag = this.saveOrUpdate((BaseEntity)customFields);
        if (flag) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    public ApiResponse<String> delete(String modelId) {
        if (HussarUtils.isEmpty((Object)modelId)) {
            throw new BaseException("\u4f20\u5165\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("MODEL_ID", modelId);
        int flag = this.customFieldsMapper.deleteByMap(map);
        if (flag > 0) {
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
    }

    public ApiResponse<CustomFieldsVo> customFieldsQuery(CustomFieldsDto customFieldsDto) {
        try {
            CustomFieldsVo customFieldsVo = new CustomFieldsVo();
            Page pager = new Page((long)customFieldsDto.getCurrent(), (long)customFieldsDto.getSize());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.like(!StringUtils.isEmpty((Object)customFieldsDto.getModelDesc()), CustomFields::getModelDesc, (Object)customFieldsDto.getModelDesc());
            List list = ((Page)this.page((IPage)pager, (Wrapper)queryWrapper)).getRecords();
            customFieldsVo.setCode(RETURN_CODE);
            customFieldsVo.setCount(Long.valueOf(pager.getTotal()));
            customFieldsVo.setData(list);
            return ApiResponse.success((Object)customFieldsVo);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public ApiResponse<CustomFields> getCustomFieldsByModelId(String modelId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CustomFields::getModelId, (Object)modelId);
        CustomFields customFields = (CustomFields)this.customFieldsMapper.selectOne((Wrapper)queryWrapper);
        return ApiResponse.success((Object)customFields);
    }
}

