/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.consumer.mq;

import com.jxdinfo.hussar.consumer.properties.ConsumerProperties;
import com.jxdinfo.hussar.consumer.service.ConsumerService;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class ConsumerRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerRabbitMqReceiver.class);
    @Resource
    private ConsumerProperties consumerProperties;
    @Resource
    private ConsumerService consumerService;

    @Bean
    private String[] queuesNames() {
        List list = this.consumerProperties.getListenerQueues();
        return list.toArray(new String[list.size()]);
    }

    @RabbitListener(queues={"#{queuesNames}"})
    public void handlePay1(Message message) {
        String json = new String(message.getBody(), StandardCharsets.UTF_8);
        String queuesName = message.getMessageProperties().getConsumerQueue();
        logger.info("consumer json:{}", (Object)json);
        if ("IntelligentAssistantQueue".equals(queuesName)) {
            this.consumerService.processMessageCenter(queuesName, json);
        } else {
            this.consumerService.processMessages(queuesName, json);
        }
    }
}

