/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.consumer.config;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.consumer.dto.InformationDTO;
import com.jxdinfo.hussar.consumer.service.ConsumerService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;

public class ConsumerRejectAndDontRequeueRecoverer
extends RejectAndDontRequeueRecoverer {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerRejectAndDontRequeueRecoverer.class);

    public void recover(Message message, Throwable cause) {
        logger.error("\u6d88\u8d39\u5931\u8d25", cause);
        try {
            ConsumerService consumerService = (ConsumerService)SpringContextUtil.getBean(ConsumerService.class);
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            InformationDTO informationDTO = (InformationDTO)JSONObject.parseObject((String)json, InformationDTO.class);
            String url = informationDTO.getUrl();
            String queuesName = message.getMessageProperties().getConsumerQueue();
            String errorMsg = JSONObject.toJSONString((Object)cause.getCause().getMessage());
            consumerService.saveFailMessage(queuesName, json, errorMsg, url);
        }
        catch (Exception e) {
            logger.error("\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            throw new ListenerExecutionFailedException("Retry Policy Exhausted", (Throwable)new AmqpRejectAndDontRequeueException(cause), new Message[]{message});
        }
    }
}

