/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.consumer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.consumer.dao.SysConsumerRecordMapper;
import com.jxdinfo.hussar.consumer.dto.InformationDTO;
import com.jxdinfo.hussar.consumer.dto.SendDataDTO;
import com.jxdinfo.hussar.consumer.dto.SysConsumerRecordDTO;
import com.jxdinfo.hussar.consumer.model.SysConsumerRecord;
import com.jxdinfo.hussar.consumer.properties.ConsumerProperties;
import com.jxdinfo.hussar.consumer.service.ConsumerService;
import com.jxdinfo.hussar.consumer.util.HttpClientUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.stereotype.Service;

@Service
public class ConsumerServiceImpl
extends ServiceImpl<SysConsumerRecordMapper, SysConsumerRecord>
implements ConsumerService {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerServiceImpl.class);
    private static HashMap<String, String> TOKEN_CACHE = null;
    private static final HashMap<String, String> HUSSAR_TOKEN_CACHE = null;
    @Resource
    private AmqpTemplate rabbitTemplate;
    @Resource
    private ConsumerProperties consumerProperties;

    public void processMessages(String queuesName, String json) {
        InformationDTO informationDTO = (InformationDTO)JSONObject.parseObject((String)json, InformationDTO.class);
        String url = informationDTO.getUrl();
        String sendJson = JSONObject.toJSONString((Object)JSONObject.parseObject((String)json, SendDataDTO.class));
        String clientToken = null;
        boolean hussarSystem = informationDTO.isHussarSystem();
        clientToken = hussarSystem ? this.getHussarToken(informationDTO) : this.getToken();
        String result = HttpClientUtil.postJson(sendJson, url, clientToken);
        ApiResponse apiResponse = (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class);
        if (apiResponse == null || apiResponse.getCode() != ResultCode.SUCCESS.getCode()) {
            String errorMsg = apiResponse != null ? JSONObject.toJSONString((Object)apiResponse.getData()) : "\u8bf7\u6c42\u54cd\u5e94\u4e3a\u7a7a";
            throw new RuntimeException(errorMsg);
        }
        this.saveSuccessMessage(queuesName, sendJson, url);
    }

    public void saveFailMessage(String queuesName, String json, String errorMsg, String url) {
        SysConsumerRecord sysConsumerRecord = new SysConsumerRecord();
        sysConsumerRecord.setQueueName(queuesName);
        sysConsumerRecord.setMessage(json);
        sysConsumerRecord.setUrl(url);
        sysConsumerRecord.setProcessingStatus("1");
        sysConsumerRecord.setConsumeStatus("1");
        sysConsumerRecord.setErrorInfo(errorMsg);
        sysConsumerRecord.setCreateTime(LocalDateTime.now());
        this.save(sysConsumerRecord);
    }

    public void saveSuccessMessage(String queuesName, String json, String url) {
        SysConsumerRecord sysConsumerRecord = new SysConsumerRecord();
        sysConsumerRecord.setQueueName(queuesName);
        sysConsumerRecord.setMessage(json);
        sysConsumerRecord.setUrl(url);
        sysConsumerRecord.setConsumeStatus("0");
        sysConsumerRecord.setCreateTime(LocalDateTime.now());
        this.save(sysConsumerRecord);
    }

    public Page<SysConsumerRecordDTO> getFailConsumerList(Page<SysConsumerRecordDTO> page, SysConsumerRecordDTO sysConsumerRecordDTO) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ((SysConsumerRecordMapper)this.baseMapper).getFailConsumerList(page, sysConsumerRecordDTO);
    }

    public String dealWith(SysConsumerRecordDTO sysConsumerRecordDTO) {
        boolean flag;
        if (ToolUtil.isEmpty((Object)sysConsumerRecordDTO) || StringUtil.isEmpty((Object)sysConsumerRecordDTO.getRecordId()) || StringUtil.isEmpty((Object)sysConsumerRecordDTO.getDealWithType())) {
            throw new BaseException("\u53c2\u6570\u9519\u8bef");
        }
        SysConsumerRecord sysConsumerRecord = (SysConsumerRecord)this.getById(sysConsumerRecordDTO.getRecordId());
        if ("2".equals(sysConsumerRecordDTO.getDealWithType())) {
            boolean retryFlag = this.retry(sysConsumerRecord);
            if (!retryFlag) {
                return "\u91cd\u8bd5\u5931\u8d25";
            }
            sysConsumerRecord.setProcessingStatus("2");
        } else {
            sysConsumerRecord.setProcessingStatus(sysConsumerRecordDTO.getDealWithType());
        }
        sysConsumerRecord.setLastTime(LocalDateTime.now());
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (securityUser != null) {
            sysConsumerRecord.setLastEditor(securityUser.getId());
        }
        if (flag = this.updateById(sysConsumerRecord)) {
            return "\u64cd\u4f5c\u6210\u529f";
        }
        return "\u64cd\u4f5c\u5931\u8d25";
    }

    private boolean retry(SysConsumerRecord sysConsumerRecord) {
        try {
            String json = sysConsumerRecord.getMessage();
            String url = sysConsumerRecord.getUrl();
            InformationDTO informationDTO = (InformationDTO)JSONObject.parseObject((String)json, InformationDTO.class);
            informationDTO.setUrl(url);
            String message = JSONObject.toJSONString((Object)informationDTO);
            this.rabbitTemplate.convertAndSend("bpmDirectExchange", sysConsumerRecord.getQueueName(), (Object)message);
            return true;
        }
        catch (Exception e) {
            logger.error("\u91cd\u8bd5\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private String getHussarToken(InformationDTO informationDTO) {
        HashMap<String, String> cacheToken = HUSSAR_TOKEN_CACHE;
        if (cacheToken != null) {
            String validTime = cacheToken.get("validTime");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            return validTime != null && timeInMillis < Long.parseLong(validTime) ? cacheToken.get("client-token") : this.requestHussarToken(informationDTO);
        }
        return this.requestHussarToken(informationDTO);
    }

    private boolean isEnableAuthHussar(InformationDTO informationDTO) {
        String hussarAuthServer = informationDTO.getCertifiedAddress();
        String hussarClientId = informationDTO.getClientId();
        String hussarClientSecret = informationDTO.getClientSecretKey();
        String hussarGrantType = informationDTO.getAuthenticationType();
        String hussarScope = informationDTO.getContractOwnership();
        return hussarAuthServer != null && hussarAuthServer.length() != 0 && hussarClientId != null && hussarClientId.length() != 0 && hussarClientSecret != null && hussarClientSecret.length() != 0 && hussarGrantType != null && hussarGrantType.length() != 0 && hussarScope != null && hussarScope.length() != 0;
    }

    private String requestHussarToken(InformationDTO informationDTO) {
        try {
            if (!this.isEnableAuthHussar(informationDTO)) {
                return null;
            }
            HashMap<String, String> headerMap = new HashMap<String, String>(2);
            headerMap.put("client-id", informationDTO.getClientId());
            headerMap.put("client-secret", informationDTO.getClientSecretKey());
            String server = informationDTO.getCertifiedAddress();
            ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
            paramList.add((NameValuePair)new BasicNameValuePair("grant_type", informationDTO.getAuthenticationType()));
            paramList.add((NameValuePair)new BasicNameValuePair("scope", informationDTO.getContractOwnership()));
            String result = HttpClientUtil.httpGet(server, paramList, headerMap);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            String data = jsonObject.getString("data");
            HashMap cacheToken = (HashMap)JSONObject.parseObject((String)data, HashMap.class);
            Calendar calendar = Calendar.getInstance();
            String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(String.valueOf(cacheToken.get("expires-in"))));
            cacheToken.put("validTime", timeInMillis);
            TOKEN_CACHE = cacheToken;
            return (String)cacheToken.get("client-token");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6token\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private String getToken() {
        HashMap<String, String> cacheToken = TOKEN_CACHE;
        if (cacheToken != null) {
            String validTime = cacheToken.get("validTime");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            return validTime != null && timeInMillis < Long.parseLong(validTime) ? cacheToken.get("client-token") : this.requestToken();
        }
        return this.requestToken();
    }

    private String requestToken() {
        try {
            if (!this.consumerProperties.isEnableAuth()) {
                return null;
            }
            HashMap<String, String> headerMap = new HashMap<String, String>(3);
            headerMap.put("client-id", this.consumerProperties.getClientId());
            headerMap.put("client-secret", this.consumerProperties.getClientSecret());
            headerMap.put("grant_type", this.consumerProperties.getGrantType());
            String server = this.consumerProperties.getAuthServer();
            String result = HttpClientUtil.httpPost(server, headerMap);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            String data = jsonObject.getString("data");
            HashMap cacheToken = (HashMap)JSONObject.parseObject((String)data, HashMap.class);
            Calendar calendar = Calendar.getInstance();
            String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(String.valueOf(cacheToken.get("expires-in"))));
            cacheToken.put("validTime", timeInMillis);
            TOKEN_CACHE = cacheToken;
            return (String)cacheToken.get("client-token");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6token\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

