/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.consumer.util;

import com.jxdinfo.hussar.consumer.util.StringUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    protected static Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);

    public static String httpGet(String url, List<NameValuePair> param, Map<String, String> headers) {
        String content;
        CloseableHttpResponse httpResponse = null;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            URI uri = new URIBuilder(url).setParameters(param).build();
            HttpGet httpGet = new HttpGet(uri);
            if (StringUtils.isNotEmpty(headers) && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpGet.setHeader(entry.getKey(), entry.getValue());
                }
            }
            httpResponse = httpclient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return content;
    }

    public static String httpPost(String url, Map<String, String> map) {
        String content;
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        try {
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            for (String key : map.keySet()) {
                nameValuePairs.add(new BasicNameValuePair(key, map.get(key)));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8));
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return content;
    }

    public static String postJson(String json, String url, String clientToken) {
        if (StringUtils.isEmpty(json) || StringUtils.isEmpty(url)) {
            return null;
        }
        logger.info("url:{},json:{}", (Object)url, (Object)json);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setHeader("Authorization", clientToken);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
            String responseString = HttpClientUtil.parse(response);
            logger.info("response:{}", (Object)responseString);
            String string = responseString;
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String parse(CloseableHttpResponse response) throws IOException {
        String result = null;
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            result = "";
            if (statusCode != 200) {
                String string = result;
                return string;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            response.close();
        }
        return result;
    }
}

