/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.consumer.config;

import com.jxdinfo.hussar.consumer.config.ConsumerRejectAndDontRequeueRecoverer;
import com.jxdinfo.hussar.consumer.properties.ConsumerProperties;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConsumerRabbitMqConfig {
    @Resource
    private ConsumerProperties consumerProperties;
    @Resource
    private AmqpAdmin amqpAdmin;

    @Bean
    public MessageRecoverer messageRecoverer() {
        return new ConsumerRejectAndDontRequeueRecoverer();
    }

    @Bean(value={"directExchange"})
    public DirectExchange directExchange() {
        return new DirectExchange("bpmDirectExchange", true, false);
    }

    @Bean
    public void initQueueBinding() {
        List queueNames = this.consumerProperties.getListenerQueues();
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("x-queue-type", "classic");
        for (String queueName : queueNames) {
            Queue queue = new Queue(queueName, true, false, false, arguments);
            this.amqpAdmin.declareQueue(queue);
            Binding bindingBuilder = BindingBuilder.bind((Queue)queue).to(this.directExchange()).with(queueName);
            this.amqpAdmin.declareBinding(bindingBuilder);
        }
    }
}

