/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.sysvisualizeconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.base.config.enums.BaseConfigEnum;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.dao.SysVisualizeConfigMapper;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.model.SysVisualizeConfig;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.service.ISysVisualizeConfigService;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.vo.SysVisualizeParamVO;
import com.jxdinfo.hussar.base.config.sysvisualizeconfig.vo.WelcomeJSTreeModelVo;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysVisualizeConfigServiceImpl
extends HussarServiceImpl<SysVisualizeConfigMapper, SysVisualizeConfig>
implements ISysVisualizeConfigService {
    @Resource
    private ISysRoleGroupService sysRoleGroupService;

    @HussarTransactional
    public boolean saveVisualize(SysVisualizeParamVO sysVisualizeParamVO) {
        String types;
        if (ToolUtil.isEmpty((Object)sysVisualizeParamVO)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_WELCOME_PAGE_VO_EMPTY.getValue()));
        }
        ArrayList<SysVisualizeConfig> list = new ArrayList<SysVisualizeConfig>();
        List roleIds = sysVisualizeParamVO.getRoleIds();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        String string = types = roleIds.size() <= 0 ? "0" : "1";
        if ("0".equals(types)) {
            roleIds.add(shiroUser.getId());
        }
        for (Long roleId : roleIds) {
            String key = "welcome_config" + roleId + ":" + types;
            HussarCacheUtil.evict((String)"welcome_config", (Object)key);
        }
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysVisualizeConfig::getUserId, (Collection)roleIds)).eq(SysVisualizeConfig::getTypes, (Object)types));
        this.setLeftComList(sysVisualizeParamVO.getLeftComList1(), roleIds, types, 1, list);
        this.setLeftComList(sysVisualizeParamVO.getLeftComList2(), roleIds, types, 2, list);
        this.setLeftComList(sysVisualizeParamVO.getLeftComList3(), roleIds, types, 3, list);
        this.setLeftComList(sysVisualizeParamVO.getLeftComList4(), roleIds, types, 4, list);
        this.setLeftComList(sysVisualizeParamVO.getWelcomeBg(), roleIds, types, 5, list);
        if (list.size() == 0) {
            return true;
        }
        return this.saveBatch(list);
    }

    private void setLeftComList(List<SysVisualizeConfig> leftComList, List<Long> roles, String types, Integer listId, List<SysVisualizeConfig> sysVisualizeConfigs) {
        for (int i = 0; i < leftComList.size(); ++i) {
            SysVisualizeConfig sysVisualizeConfig = leftComList.get(i);
            sysVisualizeConfig.setTypes(types);
            sysVisualizeConfig.setListId(listId);
            sysVisualizeConfig.setSEQ(Integer.valueOf(i));
            roles.parallelStream().forEach(str -> {
                sysVisualizeConfig.setUserId(str);
                sysVisualizeConfigs.add(sysVisualizeConfig);
            });
        }
    }

    public SysVisualizeParamVO queryVisualizeList(Long roleId) {
        ArrayList<Long> roles = new ArrayList<Long>();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = ToolUtil.isEmpty((Object)roleId) ? user.getId() : roleId;
        String type = ToolUtil.isEmpty((Object)roleId) ? "0" : "1";
        String key = "welcome_config" + userId + ":" + type;
        SysVisualizeParamVO visualizeVo = null;
        Object object = HussarCacheUtil.get((String)"welcome_config", (Object)key);
        if (ToolUtil.isEmpty((Object)object)) {
            List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysVisualizeConfig::getTypes, (Object)type)).eq(SysVisualizeConfig::getUserId, (Object)userId));
            if (list.size() <= 0 && ToolUtil.isEmpty((Object)roleId)) {
                list = HussarUtils.isNotEmpty((Object)user.getRolesList()) ? this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysVisualizeConfig::getTypes, (Object)"1")).eq(SysVisualizeConfig::getUserId, user.getRolesList().get(0))) : this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysVisualizeConfig::getTypes, (Object)"1")).eq(SysVisualizeConfig::getUserId, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
            }
            if (ToolUtil.isNotEmpty((Object)roleId)) {
                roles.add(userId);
            }
            SysVisualizeParamVO sysVisualizeParamVO = new SysVisualizeParamVO();
            sysVisualizeParamVO.setRoleIds(roles);
            sysVisualizeParamVO.setLeftComList1(this.getLeftComList(list, 1));
            sysVisualizeParamVO.setLeftComList2(this.getLeftComList(list, 2));
            sysVisualizeParamVO.setLeftComList3(this.getLeftComList(list, 3));
            sysVisualizeParamVO.setLeftComList4(this.getLeftComList(list, 4));
            sysVisualizeParamVO.setWelcomeBg(this.getLeftComList(list, 5));
            visualizeVo = sysVisualizeParamVO;
        } else {
            visualizeVo = (SysVisualizeParamVO)object;
        }
        return visualizeVo;
    }

    public ApiResponse recoveryDefault() {
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean result = this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysVisualizeConfig::getTypes, (Object)"0")).eq(SysVisualizeConfig::getUserId, (Object)user.getId()));
        if (!result) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_WELCOME_RECOVERY_FAIL_TIP.getValue()));
        }
        String key = "welcome_config" + user.getId() + ":" + "0";
        HussarCacheUtil.evict((String)"welcome_config", (Object)key);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_WELCOME_RECOVERY_SUCCESS_TIP.getValue()));
    }

    private List<SysVisualizeConfig> getLeftComList(List<SysVisualizeConfig> list, Integer index) {
        return list.parallelStream().filter(sysVisualizeConfig -> sysVisualizeConfig.getListId() == index).sorted(Comparator.comparing(SysVisualizeConfig::getSEQ)).collect(Collectors.toList());
    }

    public List<String> queryUserIds() {
        return ((SysVisualizeConfigMapper)this.baseMapper).selectUserIdsByTypes();
    }

    public List<WelcomeJSTreeModelVo> queryLazyRoleTree(Long nodeId) {
        if (ToolUtil.isEmpty((Object)nodeId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_NODE_ID_EMPTY.getValue()));
        }
        List jsTreeModels = this.sysRoleGroupService.getLazyRoleTree(nodeId);
        ArrayList<WelcomeJSTreeModelVo> welcomeJsTreeModelVos = new ArrayList<WelcomeJSTreeModelVo>();
        List<String> userIds = this.queryUserIds();
        jsTreeModels.stream().forEach(jsTreeModel -> {
            WelcomeJSTreeModelVo welcomeJsTreeModelVo = new WelcomeJSTreeModelVo();
            BeanUtils.copyProperties((Object)jsTreeModel, (Object)welcomeJsTreeModelVo);
            welcomeJsTreeModelVo.setShowAdd(userIds.contains(jsTreeModel.getId().toString()));
            welcomeJsTreeModelVos.add(welcomeJsTreeModelVo);
        });
        return welcomeJsTreeModelVos;
    }
}

