/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.baseconfig.service.impl;

import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.base.config.enums.BaseConfigEnum;
import com.jxdinfo.hussar.common.dto.SysBaseConfigDto;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class GlobalServiceImpl
implements IGlobalService {
    @Resource
    ISysBaseConfigService sysBaseConfigService;
    private static final String TITLE = "HussarV8";
    private static final boolean TREE_LAZY_LOAD = true;

    public String getTitle() {
        return TITLE;
    }

    public boolean isTreeLazyLoad() {
        return true;
    }

    public boolean isTabSwitchover() {
        SysBaseConfig baseConfig = this.sysBaseConfigService.getSysBaseConfig("tab_switchover");
        return "0".equals(baseConfig.getConfigValue());
    }

    public String getExceptionAlertEmail() {
        return this.getExceptionAlertEmail("master");
    }

    public String getExceptionAlertEmail(String connName) {
        SysBaseConfigDto baseConfig = this.sysBaseConfigService.getSysBaseConfigDto(connName, "exception_alert_email");
        return baseConfig.getConfigValue();
    }

    public String getExceptionAlertEmail(SecurityUser shiroUser) {
        SysBaseConfig baseConfig = null;
        baseConfig = ToolUtil.isNotEmpty((Object)shiroUser) ? this.sysBaseConfigService.getSysBaseConfigWithUser("exception_alert_email", shiroUser) : this.sysBaseConfigService.getSysBaseConfig("exception_alert_email");
        if (HussarUtils.isEmpty((Object)baseConfig)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_FAIL_SEND_EMAIL_OBTAIN.getValue()));
        }
        return baseConfig.getConfigValue();
    }

    public int getSecuritylogCountAlert() {
        return this.getSecuritylogCountAlert("master");
    }

    @HussarDs(value="#connName")
    public int getSecuritylogCountAlert(String connName) {
        String countAlertStr = this.sysBaseConfigService.getSysBaseConfigDto(connName, "securitylog_count_alert").getConfigValue();
        return ToolUtil.isNotEmpty((Object)countAlertStr) ? Integer.valueOf(countAlertStr) : -1;
    }

    public int getSecuritylogCountAlert(SecurityUser shiroUser) {
        SysBaseConfig baseConfig = null;
        baseConfig = ToolUtil.isNotEmpty((Object)shiroUser) ? this.sysBaseConfigService.getSysBaseConfigWithUser("securitylog_count_alert", shiroUser) : this.sysBaseConfigService.getSysBaseConfig("securitylog_count_alert");
        if (HussarUtils.isEmpty((Object)baseConfig)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_FAILED_OBTAIN_INFO_NUM_LOG.getValue()));
        }
        return Integer.valueOf(baseConfig.getConfigValue());
    }
}

