/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.config.shortcutconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.menu.model.MenuInfo;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysResourcesPartVo;
import com.jxdinfo.hussar.base.config.enums.BaseConfigEnum;
import com.jxdinfo.hussar.base.config.shortcutconfig.dao.ShortCutConfigMapper;
import com.jxdinfo.hussar.base.config.shortcutconfig.model.ShortCutConfig;
import com.jxdinfo.hussar.base.config.shortcutconfig.service.IShortCutConfigService;
import com.jxdinfo.hussar.base.config.shortcutconfig.vo.ShortCutConfigInfo;
import com.jxdinfo.hussar.base.config.shortcutconfig.vo.ShortCutConfigVO;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class ShortCutConfigServiceImpl
extends HussarServiceImpl<ShortCutConfigMapper, ShortCutConfig>
implements IShortCutConfigService {
    @Resource
    private ISysMenuManageService iSysMenuManageService;
    @Value(value="${spring.profiles.active}")
    private String profiles;
    @Resource
    private ShortCutConfigMapper shortCutConfigMapper;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;

    public List<JSTreeModel> getShortCutMenuTree() {
        List menuResources = this.sysResourcesService.getResourcesByType("res_menu", Long.valueOf(1L));
        ArrayList<Long> resIds = new ArrayList<Long>();
        HashMap<Long, SysResources> resMap = new HashMap<Long, SysResources>();
        for (SysResources resources : menuResources) {
            TranslateUtil.translate((Object)resources, SysResources::getAliasLangKey, SysResources::setResourceAlias);
            TranslateUtil.translate((Object)resources, SysResources::getNameLangKey, SysResources::setResourceName);
            resIds.add(resources.getId());
            resMap.put(resources.getId(), resources);
        }
        List menuFunctions = this.sysFunctionsService.getFunsByAllDefaultRes(Long.valueOf(1L));
        List leafMenus = this.iSysMenuManageService.getLeafMenus();
        TranslateUtil.translate((List)leafMenus, SysMenu::getAliasLangKey, SysMenu::setMenuAlias);
        TranslateUtil.translate((List)leafMenus, SysMenu::getTextLangKey, SysMenu::setText);
        List consoleMenus = leafMenus.stream().filter(sysMenu -> "0".equals(sysMenu.getMenuType()) || HussarUtils.equals((Object)"1", (Object)sysMenu.getOpenMode())).collect(Collectors.toList());
        ArrayList<Long> consoleFuncIds = new ArrayList<Long>();
        for (SysMenu menu : consoleMenus) {
            consoleFuncIds.add(menu.getFunctionId());
        }
        List notConsoleMenus = leafMenus.stream().filter(sysMenu -> !"0".equals(sysMenu.getMenuType())).collect(Collectors.toList());
        HashMap<Long, SysMenu> funcAndMenuNotConsoleMap = new HashMap<Long, SysMenu>();
        for (SysMenu menu : notConsoleMenus) {
            funcAndMenuNotConsoleMap.put(menu.getFunctionId(), menu);
        }
        List<ShortCutConfig> shortCutList = this.shortCutConfigMapper.selectOrderShortCut();
        ArrayList<Long> shortCutFuncIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(shortCutList)) {
            for (ShortCutConfig shortCutConfig : shortCutList) {
                shortCutFuncIds.add(shortCutConfig.getFunctionId());
            }
        }
        Iterator iterator = menuFunctions.iterator();
        ArrayList<JSTreeModel> functionsForShortCut = new ArrayList<JSTreeModel>();
        while (iterator.hasNext()) {
            String text;
            SysFunctions menuFunction = (SysFunctions)iterator.next();
            if (HussarUtils.isNotEmpty(consoleFuncIds) && consoleFuncIds.contains(menuFunction.getId())) {
                iterator.remove();
                continue;
            }
            if (HussarUtils.isNotEmpty(shortCutFuncIds) && shortCutFuncIds.contains(menuFunction.getId())) {
                iterator.remove();
                continue;
            }
            if (HussarUtils.equals((Object)"3", (Object)((SysResources)resMap.get(menuFunction.getDefaultResourceId())).getStrategy()) && HussarUtils.isEmpty(funcAndMenuNotConsoleMap.get(menuFunction.getId()))) {
                iterator.remove();
                continue;
            }
            JSTreeModel funcJs = new JSTreeModel();
            funcJs.setFunctionId(menuFunction.getId());
            if (HussarUtils.isEmpty((Object)menuFunction.getNameLangKey())) {
                funcJs.setFunctionName(menuFunction.getFunctionName());
            } else {
                String funcName = TranslateUtil.getTranslateName((String)menuFunction.getNameLangKey());
                funcJs.setFunctionName(HussarUtils.isNotEmpty((Object)funcName) ? funcName : menuFunction.getFunctionName());
            }
            funcJs.setResourceId(menuFunction.getDefaultResourceId());
            funcJs.setResourceName(TranslateUtil.getTranslateName((String)((SysResources)resMap.get(menuFunction.getDefaultResourceId())).getNameLangKey()));
            funcJs.setPath(((SysResources)resMap.get(menuFunction.getDefaultResourceId())).getPath());
            if (HussarUtils.isNotEmpty(funcAndMenuNotConsoleMap.get(menuFunction.getId()))) {
                SysMenu menu = (SysMenu)funcAndMenuNotConsoleMap.get(menuFunction.getId());
                funcJs.setId(menu.getId());
                funcJs.setParent(menu.getParentId());
                funcJs.setIsLeaf(menu.getIsLeaf());
                funcJs.setType(menu.getMenuType());
                funcJs.setSeq(menu.getSeq().toString());
            }
            funcJs.setText(HussarUtils.isNotEmpty((Object)(text = TranslateUtil.getTranslateName((String)menuFunction.getNameLangKey()))) ? text : menuFunction.getFunctionName());
            functionsForShortCut.add(funcJs);
        }
        return functionsForShortCut;
    }

    @HussarTransactional
    public ApiResponse saveShortCutConfig(ShortCutConfig shortCutConfig) {
        boolean result;
        if (ToolUtil.isEmpty((Object)shortCutConfig)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_SHORTCUT_OBJECT_EMPTY.getValue()));
        }
        shortCutConfig.setParentId(Long.valueOf(0L));
        if (HussarUtils.isEmpty((Object)shortCutConfig.getMenuId())) {
            shortCutConfig.setMenuId(null);
        }
        if (HussarUtils.equals((Object)"2", (Object)shortCutConfig.getOpenType())) {
            shortCutConfig.setFunctionId(this.sysFunctionsService.saveOrUpdateFunctionByShortCut(shortCutConfig));
        }
        if (!(result = this.save((BaseEntity)shortCutConfig))) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_FAIL.getValue()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_SUCCESS.getValue()));
    }

    public List<ShortCutConfigVO> queryShortCutConfig() {
        List<ShortCutConfigVO> shortCutConfigVos = this.shortCutConfigMapper.getAllGroup();
        for (ShortCutConfigVO vo : shortCutConfigVos) {
            List shortCutConfigs = this.shortCutConfigMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ShortCutConfig::getGroupId, (Object)vo.getGroupId()));
            if (shortCutConfigs.size() == 1 && HussarUtils.isEmpty((Object)((ShortCutConfig)shortCutConfigs.get(0)).getId())) {
                vo.setShortCutConfigs(new ArrayList());
            } else {
                TranslateUtil.translate((List)shortCutConfigs, ShortCutConfig::getNameLangKey, ShortCutConfig::setName);
                vo.setShortCutConfigs(shortCutConfigs);
            }
            TranslateUtil.translate((Object)vo, ShortCutConfigVO::getGroupNameLangKey, ShortCutConfigVO::setGroupName);
        }
        return shortCutConfigVos;
    }

    public ApiResponse updateShortCutConfig(ShortCutConfig shortCutConfig) {
        boolean result;
        if (ToolUtil.isEmpty((Object)shortCutConfig)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_SHORTCUT_OBJECT_EMPTY.getValue()));
        }
        if (HussarUtils.isEmpty((Object)shortCutConfig.getMenuId())) {
            shortCutConfig.setMenuId(null);
        }
        if (HussarUtils.equals((Object)"2", (Object)shortCutConfig.getOpenType())) {
            this.sysFunctionsService.saveOrUpdateFunctionByShortCut(shortCutConfig);
        }
        if (!(result = this.saveOrUpdate((BaseEntity)shortCutConfig))) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_FAIL.getValue()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_SUCCESS.getValue()));
    }

    @HussarTransactional
    public ApiResponse deleteShortCutConfig(String id) {
        boolean result;
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_DEL_SHORTCUT_ID_EMPTY.getValue()));
        }
        ShortCutConfig shortCutConfig = (ShortCutConfig)this.getById(Long.valueOf(Long.parseLong(id)));
        boolean result1 = true;
        boolean result2 = true;
        boolean result3 = true;
        boolean result4 = true;
        boolean result5 = true;
        boolean result6 = true;
        boolean result7 = true;
        if ("2".equals(shortCutConfig.getOpenType())) {
            SysFunctions function = (SysFunctions)this.sysFunctionsService.getById((Serializable)shortCutConfig.getFunctionId());
            result1 = this.sysFunctionModulesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getId, (Object)function.getFunctionModuleId()));
            result2 = this.sysFunctionsService.removeById((Object)function);
            result3 = this.sysFunctionResourcesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getFunctionId, (Object)function.getId()));
            SysResources resources = (SysResources)this.sysResourcesService.getById((Serializable)function.getDefaultResourceId());
            result4 = this.sysResourceMosulesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getId, (Object)resources.getModuleId()));
            result5 = this.sysResourcesService.removeById((Serializable)function.getDefaultResourceId());
            result6 = this.sysRoleResourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)function.getDefaultResourceId()));
            result7 = this.sysRoleFunctionsService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getFunctionId, (Object)function.getId()));
        }
        if (!((result = this.removeById(Long.valueOf(Long.parseLong(id)))) && result1 && result2 && result3 && result4 && result5 && result6 && result7)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_FAIL.getValue()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_SUCCESS.getValue()));
    }

    public ShortCutConfig viewShortCutConfig(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_ID_PARAMETER_EMPTY.getValue()));
        }
        ShortCutConfig config = (ShortCutConfig)this.getById(id);
        ShortCutConfigInfo result = new ShortCutConfigInfo();
        BeanUtils.copyProperties((Object)config, (Object)result);
        SysFunctions function = (SysFunctions)this.sysFunctionsService.getById((Serializable)config.getFunctionId());
        result.setFunctionCode(function.getFunctionCode());
        Long menuId = result.getMenuId();
        if (HussarUtils.isNotEmpty((Object)menuId)) {
            SysMenu sysMenu = (SysMenu)this.iSysMenuManageService.getById((Serializable)menuId);
        }
        result.setText(function.getFunctionName());
        return result;
    }

    public List<ShortCutConfig> queryShortCutConfigUserList() {
        List<Long> userRolesFunIds = this.getFunctionIdsByUserRoles();
        List<ShortCutConfig> shortCutConfigList = ((ShortCutConfigMapper)this.baseMapper).selectOrderShortCut();
        Iterator<ShortCutConfig> iterator = shortCutConfigList.iterator();
        while (iterator.hasNext()) {
            ShortCutConfig shortCutConfig = iterator.next();
            if (!userRolesFunIds.contains(shortCutConfig.getFunctionId())) {
                iterator.remove();
            }
            TranslateUtil.translate((Object)shortCutConfig, ShortCutConfig::getNameLangKey, ShortCutConfig::setName);
        }
        return shortCutConfigList;
    }

    @HussarTransactional
    public ApiResponse saveShortCutUserConfig(String ids) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarBaseEntity::getCreator, (Object)shiroUser.getId())).ne(ShortCutConfig::getParentId, (Object)0));
        if (HussarUtils.isBlank((CharSequence)ids)) {
            ShortCutConfig shortCutConfig = new ShortCutConfig();
            shortCutConfig.setParentId(Long.valueOf(1450785648213684226L));
            this.save((BaseEntity)shortCutConfig);
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_ADD_SUCCESS.getValue()));
        }
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<ShortCutConfig> shortCutConfigList = new ArrayList<ShortCutConfig>();
        for (int i = 0; i < idList.size(); ++i) {
            String id = idList.get(i);
            ShortCutConfig shortCutConfig = new ShortCutConfig();
            shortCutConfig.setParentId(Long.valueOf(Long.parseLong(id)));
            shortCutConfig.setSeq(Integer.valueOf(i + 1));
            shortCutConfigList.add(shortCutConfig);
        }
        boolean flag = this.saveBatch(shortCutConfigList);
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_FAIL.getValue()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)BaseConfigEnum.BASE_CONFIG_UPDATE_SUCCESS.getValue()));
    }

    public List<ShortCutConfig> queryUserShortCut() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long userId = shiroUser.getId();
        List list = ((ShortCutConfigMapper)this.baseMapper).selectShortCutListByUserId(userId);
        List parentIdList = list.stream().map(ShortCutConfig::getParentId).distinct().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(parentIdList) && parentIdList.contains(1450785648213684226L)) {
            return Collections.emptyList();
        }
        List<Long> funcIdList = list.stream().map(ShortCutConfig::getFunctionId).distinct().collect(Collectors.toList());
        Map<Long, String> funIdAndServiceNameMap = this.getFuncServiceName(funcIdList, shiroUser);
        if (list.size() == 1 && "1450785648213684226".equals(String.valueOf(list.get(0).getParentId()))) {
            list.remove(0);
        } else if (HussarUtils.isEmpty(list)) {
            list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ShortCutConfig::getParentId, (Object)0)).eq(ShortCutConfig::getIsDefault, (Object)"1"));
        } else {
            List<Long> functionIds = this.getFunctionIdsByUserRoles();
            Iterator<ShortCutConfig> iterator = list.iterator();
            while (iterator.hasNext()) {
                Long functionId;
                String serviceName;
                ShortCutConfig shortCutConfig = iterator.next();
                if (!functionIds.contains(shortCutConfig.getFunctionId())) {
                    iterator.remove();
                }
                if (!HussarUtils.isNotBlank((CharSequence)(serviceName = funIdAndServiceNameMap.get(functionId = shortCutConfig.getFunctionId())))) continue;
                shortCutConfig.setShortCutUrl("/" + serviceName + shortCutConfig.getShortCutUrl());
            }
        }
        TranslateUtil.translate(list, ShortCutConfig::getNameLangKey, ShortCutConfig::setName);
        return list;
    }

    private Map<Long, String> getFuncServiceName(List<Long> funcIdList, SecurityUser shiroUser) {
        HashMap<Long, String> funIdAndServiceNameMap = new HashMap<Long, String>();
        if (HussarUtils.isNotEmpty(funcIdList)) {
            return funIdAndServiceNameMap;
        }
        List funcResVoList = this.sysFunctionsService.getDefaultResIdByFuncIds(funcIdList);
        if (HussarUtils.isNotEmpty((Object)funcResVoList)) {
            String locale = LocaleContextHolder.getLocale().toLanguageTag();
            List partVoList = (List)HussarCacheUtil.get((String)"resource_info", (Object)("hussar_resource:" + shiroUser.getId() + ":" + "1" + ":" + locale));
            if (HussarUtils.isNotEmpty((Object)partVoList)) {
                Map map = partVoList.stream().collect(Collectors.toMap(SysResourcesPartVo::getId, Function.identity()));
                for (FuncResVo funcResVo : funcResVoList) {
                    SysResourcesPartVo res = (SysResourcesPartVo)map.get(funcResVo.getResourceId());
                    if (!HussarUtils.isNotEmpty((Object)res)) continue;
                    funIdAndServiceNameMap.put(funcResVo.getFunctionId(), res.getServiceName());
                }
            }
        }
        return funIdAndServiceNameMap;
    }

    public List<Long> getMenuIds() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        List roleIdList = shiroUser.getRolesList();
        if (roleIdList == null || roleIdList.size() <= 0) {
            return new ArrayList<Long>();
        }
        String locale = LocaleContextHolder.getLocale().toString();
        List menus = this.iSysMenuManageService.getMenuByRoles(shiroUser.getId(), roleIdList, this.profiles, null, locale, null, Boolean.valueOf(true));
        ArrayList<Long> menuInfoList = new ArrayList<Long>();
        this.getMenuInfo(menuInfoList, menus);
        return menuInfoList;
    }

    public List<Long> getFunctionIdsByUserRoles() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        List roleIdList = shiroUser.getRolesList();
        if (roleIdList == null || roleIdList.size() <= 0) {
            return new ArrayList<Long>();
        }
        List functions = this.sysRoleFunctionsService.listByRoleIds(roleIdList);
        ArrayList<Long> functionIds = new ArrayList<Long>();
        for (SysRoleFunctions roleFunctions : functions) {
            functionIds.add(roleFunctions.getFunctionId());
        }
        return functionIds;
    }

    private void getMenuInfo(List<Long> menuInfoList, List<MenuInfo> menuInfos) {
        for (MenuInfo menuInfo : menuInfos) {
            menuInfoList.add(menuInfo.getMenuId());
            if (menuInfo.getChildMenus().size() <= 0) continue;
            this.getMenuInfo(menuInfoList, menuInfo.getChildMenus());
        }
    }
}

