/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.extend.migration.service.impl;

import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.config.extend.migration.excel.entity.ConfigInfoExcel;
import com.jxdinfo.hussar.config.extend.migration.excel.entity.ConfigInfoExcelExportDesc;
import com.jxdinfo.hussar.config.extend.migration.service.HussarConfigMigrationExcelService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigGroupDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.dto.GetConfigInfoDto;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.ConfigInfoDaoService;
import com.jxdinfo.hussar.config.manager.plugin.mybatis.service.impl.ConfigGroupDaoServiceImpl;
import com.jxdinfo.hussar.excel.builder.ConcreteExcelBuilder;
import com.jxdinfo.hussar.excel.builder.ExcelProduct;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.model.ImportSheetMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.excel.util.CustomVerticalCellStyleStrategy;
import com.jxdinfo.hussar.excel.util.HussarBaseExcelWriteUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.beans.ClassPathResource;
import com.jxdinfo.hussar.support.config.manager.core.constants.ConfigConstant;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigGroupEntity;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigInfoEntity;
import com.jxdinfo.hussar.support.config.manager.entity.ConfigOptionEntity;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.thread.support.executor.HussarTaskExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class HussarConfigMigrationExcelServiceImpl
implements HussarConfigMigrationExcelService {
    @Autowired
    private ConfigGroupDaoServiceImpl configGroupDaoService;
    @Autowired
    private ConfigInfoDaoService configInfoDaoService;
    @Resource
    private IHussarBaseExcelService hussarBaseExcelService;
    @Autowired
    private HussarTaskExecutor hussarTaskExecutor;
    @Resource
    private ISysExcelTaskService sysExcelTaskServiceImpl;
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;
    @Resource(name="com.jxdinfo.hussar.config.extend.migration.service.impl.HussarConfigCustomExcelServiceImpl")
    private IHussarBaseCustomExcelService hussarBaseCustomExcelService;

    public void exportConfigExcel(HttpServletResponse response, Long taskId, List<Long> groupIds) {
        if (HussarUtils.isEmpty(groupIds)) {
            return;
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        this.hussarTaskExecutor.execute(() -> {
            List result;
            if (ConfigConstant.defaultParentId.equals(groupIds.get(0))) {
                result = this.configInfoDaoService.getConfigInfo(new GetConfigInfoDto());
            } else {
                result = new ArrayList();
                GetConfigGroupDto getGroupDto = new GetConfigGroupDto();
                String[] ids = (String[])groupIds.stream().map(String::valueOf).toArray(String[]::new);
                getGroupDto.addParameter("groupId_in", ids);
                List configGroups = this.configGroupDaoService.getConfigGroup(getGroupDto);
                for (ConfigGroupEntity configGroup : configGroups) {
                    GetConfigInfoDto getConfigInfoDto = new GetConfigInfoDto();
                    getConfigInfoDto.addParameter("configKey_rightLike", configGroup.getGroupPath());
                    result.addAll(this.configInfoDaoService.getConfigInfo(getConfigInfoDto));
                }
            }
            ArrayList<ConfigInfoExcel> configInfoExcels = new ArrayList<ConfigInfoExcel>();
            for (ConfigInfoEntity configInfoEntity : result) {
                ConfigInfoExcel configInfoExcel = (ConfigInfoExcel)BeanUtil.copyProperties((Object)configInfoEntity, ConfigInfoExcel.class);
                List configOptions = configInfoEntity.getConfigOptions();
                if (HussarUtils.isNotEmpty((Object)configOptions)) {
                    List OptionValues = configOptions.stream().map(ConfigOptionEntity::getOptionValue).collect(Collectors.toList());
                    configInfoExcel.setConfigOptionValues(JSON.toJSONString(OptionValues));
                }
                configInfoExcels.add(configInfoExcel);
            }
            ClassSheetMsg classSheetMsg1 = new ClassSheetMsg(ConfigInfoExcel.class, configInfoExcels, "\u914d\u7f6e\u4e2d\u5fc3\u5bfc\u51fa\u4fe1\u606f", 0);
            List<String> alignList = Arrays.asList(new String[6]);
            alignList.set(0, "left");
            alignList.set(2, "left");
            alignList.set(3, "left");
            alignList.set(4, "left");
            alignList.set(5, "left");
            CustomVerticalCellStyleStrategy customVerticalCellStyleStrategy = new CustomVerticalCellStyleStrategy(alignList, false);
            classSheetMsg1.addHandler((WriteHandler)customVerticalCellStyleStrategy);
            ConfigInfoExcelExportDesc configExportDesc = new ConfigInfoExcelExportDesc();
            configExportDesc.setExportOperator(securityUser.getUserName());
            String exportTime = Java8DateUtils.getCurrentDateDTimeStr();
            configExportDesc.setExportTime(Java8DateUtils.getCurrentDateTimeStr());
            ArrayList<ConfigInfoExcelExportDesc> configInfoExcelExportDescs = new ArrayList<ConfigInfoExcelExportDesc>();
            configInfoExcelExportDescs.add(configExportDesc);
            ClassSheetMsg classSheetMsg2 = new ClassSheetMsg(ConfigInfoExcelExportDesc.class, configInfoExcelExportDescs, "\u5bfc\u51fa\u63cf\u8ff0", 1);
            try {
                ExcelProduct excelProduct = new ConcreteExcelBuilder("\u7ec4\u7ec7\u673a\u6784\u5bfc\u51fa\u4fe1\u606f" + exportTime + ".xlsx", taskId, this.hussarBaseExcelService).makeClassSheet(classSheetMsg1).makeClassSheet(classSheetMsg2).buildExcelProduct();
                this.sysExcelTaskServiceImpl.updateById((Object)excelProduct.getTask());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void downloadConfigExcelTpl(HttpServletResponse response) {
        String filePath = "static/ConfigImportTemplate.xlsx";
        ClassPathResource resource = new ClassPathResource(filePath);
        try (InputStream inputStream = resource.getStream();
             ServletOutputStream out = response.getOutputStream();){
            response.setContentType("multipart/form-data");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u914d\u7f6e\u4e2d\u5fc3Excel\u5bfc\u5165\u6a21\u677f.xlsx", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename*=utf-8''" + fileName);
            Workbook workbook = HussarBaseExcelWriteUtils.judegExcelEdition((String)"\u7ec4\u7ec7\u673a\u6784Excel\u5bfc\u5165\u6a21\u677f", (InputStream)inputStream);
            workbook.write((OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkConfigExcel(MultipartFile file, String scenario, Long taskId) {
        InputStream input;
        try {
            input = file.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileName = file.getOriginalFilename();
        ApiResponse fileResponse = this.ossService.backgroundUpload(file);
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setFileName(fileName);
        task.setCheckScenario(scenario);
        task.setTaskFile((Long)fileResponse.getData());
        this.iSysExcelTaskService.updateById((Object)task);
        this.hussarTaskExecutor.execute(() -> {
            ImportSheetMsg importSheetMsg1 = new ImportSheetMsg(Integer.valueOf(0), ConfigInfoExcel.class, this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg1);
            this.hussarBaseExcelService.checkExcelSheets(input, importSheetMsgs, scenario, taskId, new HashMap(), new HashMap());
        });
    }

    public void importConfigExcel(String scenario, Long taskId) {
        this.hussarTaskExecutor.execute(() -> {
            ImportSheetMsg importSheetMsg = new ImportSheetMsg(Integer.valueOf(0), ConfigInfoExcel.class, this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg);
            this.hussarBaseExcelService.importExcelSheets(importSheetMsgs, scenario, taskId, new HashMap());
        });
    }
}

