/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils;

import com.jxdinfo.hussar.common.utils.ByteArrayUtils;
import com.jxdinfo.hussar.core.util.SM4Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeUtils {
    private static Logger logger = LoggerFactory.getLogger(SerializeUtils.class);
    private static String sm4Key = "hussarencryptkey";

    public static Object deserialize(byte[] bytes) throws UnsupportedEncodingException, ClassNotFoundException, IOException {
        byte[] newBytes = bytes;
        Object result = null;
        if (SerializeUtils.isEmpty(newBytes)) {
            return null;
        }
        try {
            newBytes = ByteArrayUtils.toByteArray(SM4Util.decrypt((String)new String(newBytes, "utf-8"), (String)sm4Key));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("Failed to decrypt", (Throwable)ex);
            throw ex;
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(newBytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteStream);
            result = objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            logger.error("Failed to deserialize");
            throw ex;
        }
        return result;
    }

    public static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    public static byte[] serialize(Object object) throws IOException {
        byte[] result = null;
        if (object == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(128);
        try {
            if (!(object instanceof Serializable)) {
                throw new IllegalArgumentException(SerializeUtils.class.getSimpleName() + " requires a Serializable payload but received an object of type [" + object.getClass().getName() + "]");
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            result = byteStream.toByteArray();
            if (result != null) {
                result = SM4Util.encrypt((String)ByteArrayUtils.toHexString(result), (String)sm4Key).getBytes();
            }
        }
        catch (IOException ex) {
            logger.error("Failed to deserialize");
            throw ex;
        }
        return result;
    }
}

