/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.jxdinfo.hussar.common.exception.IdempotentJsonException;
import com.jxdinfo.hussar.platform.core.serialize.HussarJavaTimeModule;
import com.jxdinfo.hussar.platform.core.serialize.HussarNumberModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.lang.Nullable;

public final class IdempotentJsonUtils {
    private static final ObjectMapperWrapper WRAPPER = new ObjectMapperWrapper();

    private IdempotentJsonUtils() {
    }

    public static ObjectMapperWrapper getWrapper() {
        return WRAPPER;
    }

    public static ObjectMapper getObjectMapper() {
        return IdempotentJsonUtils.getWrapper().getObjectMapper();
    }

    public static TypeFactory getTypeFactory() {
        return IdempotentJsonUtils.getWrapper().getTypeFactory();
    }

    public static String toString(Object value) {
        return IdempotentJsonUtils.getWrapper().toString(value);
    }

    public static byte[] toByteArray(Object value) {
        return IdempotentJsonUtils.getWrapper().toByteArray(value);
    }

    public static void write(Object value, OutputStream output) throws IOException {
        IdempotentJsonUtils.getWrapper().write(value, output);
    }

    public static void write(Object value, File output) throws IOException {
        IdempotentJsonUtils.getWrapper().write(value, output);
    }

    public static <T> T parse(String text, Class<T> clazz) {
        return IdempotentJsonUtils.getWrapper().parse(text, clazz);
    }

    public static <T> T parse(String text, TypeReference<T> typeReference) {
        return IdempotentJsonUtils.getWrapper().parse(text, typeReference);
    }

    public static <T> T parse(byte[] bytes, Class<T> clazz) {
        return IdempotentJsonUtils.getWrapper().parse(bytes, clazz);
    }

    public static <T> T parse(byte[] bytes, TypeReference<T> typeReference) {
        return IdempotentJsonUtils.getWrapper().parse(bytes, typeReference);
    }

    public static <T> T parse(InputStream input, Class<T> clazz) {
        return IdempotentJsonUtils.getWrapper().parse(input, clazz);
    }

    public static <T> T parse(InputStream input, TypeReference<T> typeReference) {
        return IdempotentJsonUtils.getWrapper().parse(input, typeReference);
    }

    public static <T> T convert(Object original, Class<T> clazz) {
        return IdempotentJsonUtils.getWrapper().convert(original, clazz);
    }

    public static <T> T convert(Object original, TypeReference<T> typeReference) {
        return IdempotentJsonUtils.getWrapper().convert(original, typeReference);
    }

    public static boolean serializable(@Nullable Object value) {
        return IdempotentJsonUtils.getWrapper().serializable(value);
    }

    private static class MigrationObjectMapper
    extends ObjectMapper {
        private static final Locale LOCALE = Locale.CHINA;
        private static final MigrationObjectMapper INSTANCE = new MigrationObjectMapper();

        public MigrationObjectMapper() {
            this.setLocale(LOCALE);
            this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            this.setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
            this.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA));
            this.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            this.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
            this.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true);
            this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.configure(JsonReadFeature.ALLOW_SINGLE_QUOTES.mappedFeature(), true);
            this.getDeserializationConfig().withoutFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
            this.registerModule((Module)new HussarJavaTimeModule());
            this.registerModules(new Module[]{HussarNumberModule.INSTANCE});
            this.findAndRegisterModules();
        }

        public static MigrationObjectMapper getInstance() {
            return INSTANCE;
        }
    }

    public static final class ObjectMapperWrapper {
        private final ObjectMapper OBJECT_MAPPER;

        public ObjectMapperWrapper() {
            this(null);
        }

        public ObjectMapperWrapper(ObjectMapper objectMapper) {
            if (objectMapper == null) {
                objectMapper = MigrationObjectMapper.getInstance();
            }
            this.OBJECT_MAPPER = objectMapper;
        }

        public ObjectMapper getObjectMapper() {
            return this.OBJECT_MAPPER;
        }

        public TypeFactory getTypeFactory() {
            return this.getObjectMapper().getTypeFactory();
        }

        public String toString(Object value) {
            try {
                return this.getObjectMapper().writeValueAsString(value);
            }
            catch (JsonProcessingException ex) {
                throw new IdempotentJsonException(ex);
            }
        }

        public byte[] toByteArray(Object value) {
            try {
                return this.getObjectMapper().writeValueAsBytes(value);
            }
            catch (JsonProcessingException ex) {
                throw new IdempotentJsonException(ex);
            }
        }

        public void write(Object value, OutputStream output) throws IOException {
            this.getObjectMapper().writeValue(output, value);
        }

        public void write(Object value, File output) throws IOException {
            this.getObjectMapper().writeValue(output, value);
        }

        public <T> T parse(String text, Class<T> clazz) {
            try {
                return (T)this.getObjectMapper().readValue(text, clazz);
            }
            catch (JsonProcessingException ex) {
                throw new IdempotentJsonException(ex);
            }
        }

        public <T> T parse(String text, TypeReference<T> typeReference) {
            try {
                return (T)this.getObjectMapper().readValue(text, typeReference);
            }
            catch (JsonProcessingException ex) {
                throw new IdempotentJsonException(ex);
            }
        }

        public <T> T parse(byte[] bytes, Class<T> clazz) {
            try {
                return (T)this.getObjectMapper().readValue(bytes, clazz);
            }
            catch (IOException ex) {
                throw new IdempotentJsonException(ex);
            }
        }

        public <T> T parse(byte[] bytes, TypeReference<T> typeReference) {
            try {
                return (T)this.getObjectMapper().readValue(bytes, typeReference);
            }
            catch (IOException ex) {
                throw new IdempotentJsonException(ex);
            }
        }

        public <T> T parse(InputStream input, Class<T> clazz) {
            try {
                return (T)this.getObjectMapper().readValue(input, clazz);
            }
            catch (IOException ex) {
                throw new IdempotentJsonException(ex);
            }
        }

        public <T> T parse(InputStream input, TypeReference<T> typeReference) {
            try {
                return (T)this.getObjectMapper().readValue(input, typeReference);
            }
            catch (IOException ex) {
                throw new IdempotentJsonException(ex);
            }
        }

        public <T> T convert(Object original, Class<T> clazz) {
            try {
                return (T)this.getObjectMapper().convertValue(original, clazz);
            }
            catch (IllegalArgumentException ex) {
                throw new IdempotentJsonException(ex);
            }
        }

        public <T> T convert(Object original, TypeReference<T> typeReference) {
            try {
                return (T)this.getObjectMapper().convertValue(original, typeReference);
            }
            catch (IllegalArgumentException ex) {
                throw new IdempotentJsonException(ex);
            }
        }

        public boolean serializable(@Nullable Object value) {
            return value == null || this.getObjectMapper().canSerialize(value.getClass());
        }
    }
}

