/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.treemodel;

import com.jxdinfo.hussar.common.treemodel.HussarLazyTreeDefinition;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public final class HussarTreeParser {
    private HussarTreeParser() {
    }

    public static <T extends HussarLazyTreeDefinition> List<T> getTreeList(Collection<T> dataList) {
        HussarLazyTreeDefinition temp;
        ArrayList<HussarLazyTreeDefinition> roots = new ArrayList<HussarLazyTreeDefinition>();
        if (HussarUtils.isEmpty(dataList)) {
            return new ArrayList();
        }
        ArrayList<Serializable> parentIds = new ArrayList<Serializable>();
        LinkedHashMap<Serializable, HussarLazyTreeDefinition> map = new LinkedHashMap<Serializable, HussarLazyTreeDefinition>();
        for (HussarLazyTreeDefinition item : dataList) {
            map.put((Serializable)item.getId(), item);
        }
        for (HussarLazyTreeDefinition item : dataList) {
            temp = (HussarLazyTreeDefinition)map.get(item.getParentId());
            if (temp != null) {
                temp.getChildren().add(item);
                continue;
            }
            parentIds.add((Serializable)item.getId());
        }
        for (Serializable id : parentIds) {
            temp = (HussarLazyTreeDefinition)map.get(id);
            if (!HussarUtils.isNotEmpty((Object)temp)) continue;
            roots.add(temp);
        }
        return roots;
    }
}

