/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.core.encrypt;

import com.jxdinfo.hussar.common.core.encrypt.AbstractCryptoProvider;
import com.jxdinfo.hussar.common.core.encrypt.condition.Base64Condition;
import com.jxdinfo.hussar.core.util.EncryptUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Repository;

@Repository
@Conditional(value={Base64Condition.class})
public class Base64CryptoProvider
extends AbstractCryptoProvider {
    @Override
    public String encode(Map<String, String> dataMap) {
        if (!this.check(dataMap)) {
            return null;
        }
        String data = dataMap.get("data");
        try {
            return new String(EncryptUtil.Base64Encode((byte[])data.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Override
    public String decode(Map<String, String> dataMap) {
        if (!this.check(dataMap)) {
            return null;
        }
        String data = dataMap.get("data");
        try {
            return new String(EncryptUtil.Base64Decode((byte[])data.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Override
    public Map<String, String> getKeyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("publicKey", "base64");
        map.put("privateKey", "base64");
        return map;
    }
}

