/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class EntityUtils {
    public static final Long ROOT_ID = 1L;

    private EntityUtils() {
    }

    public static <T, R> List<R> toList(Collection<T> list, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        if (Objects.nonNull(list)) {
            return list.stream().map(action).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static <T, R> Set<R> toSet(Collection<T> data, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        if (Objects.nonNull(data)) {
            return data.stream().map(action).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static <R, T> Map<R, T> toMap(Collection<T> list, Function<? super T, ? extends R> function) {
        return list.stream().collect(Collectors.toMap(function, Function.identity()));
    }

    public static <T> Collection<T> recursiveGetData(Collection<Long> selectIds, Collection<T> allData, Collection<T> result, Function<T, Long> idAction, Function<T, Long> pkAction) {
        if (HussarUtils.isEmpty(selectIds) || selectIds.size() == 1) {
            return result;
        }
        HashSet<Long> parentModuleList = new HashSet<Long>();
        for (T item : allData) {
            if (!selectIds.contains(idAction.apply(item))) continue;
            result.add(item);
            parentModuleList.add(pkAction.apply(item));
        }
        return EntityUtils.recursiveGetData(new ArrayList<Long>(parentModuleList), allData, result, idAction, pkAction);
    }

    public static <T> Collection<T> subtract(Collection<T> a, Collection<T> b, Function<T, Long> idAction) {
        Collection idList = b.stream().map(item -> (Long)idAction.apply(item)).collect(Collectors.toList());
        Collection subtract = a.stream().filter(item -> !idList.contains(idAction.apply(item))).collect(Collectors.toList());
        return subtract;
    }

    public static <T> Collection<Long> subtractId(Collection<T> a, Collection<T> b, Function<T, Long> idAction) {
        Collection aids = a.stream().map(item -> (Long)idAction.apply(item)).collect(Collectors.toList());
        Collection bids = b.stream().map(item -> (Long)idAction.apply(item)).collect(Collectors.toList());
        return CollectionUtils.subtract((Collection)aids, (Collection)bids);
    }
}

