/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.datasource.service.impl;

import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.datasource.support.service.dto.DynamicDataSourceDto;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DynamicDataSourceServiceImpl
implements IDynamicDataSourceService {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSourceServiceImpl.class);
    @Resource
    private DynamicDatasourceService dynamicDatasourceService;

    @Override
    public void addDataSource(DynamicDataSourceDto dynamicDataSourceDto) {
        this.dynamicDatasourceService.addDynamicDatasource(dynamicDataSourceDto);
    }

    @Override
    public void removeDataSource(String name) {
        this.dynamicDatasourceService.removeDynamicDatasource(name);
    }

    @Override
    public DataSource getDataSource(String name) {
        return this.dynamicDatasourceService.getDatasourceByPoolName(name);
    }

    @Override
    public DataSource getDataSource() {
        return this.dynamicDatasourceService.getCurrentDatasource();
    }

    @Override
    public Connection getConnection(String url, String username, String password) throws SQLException {
        if (url.startsWith("jdbc:oscar")) {
            try {
                Class.forName("com.oscar.Driver");
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return DriverManager.getConnection(url, username, password);
    }

    @Override
    public Connection getConnection(String name) throws SQLException {
        return this.getDataSource(name).getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public String currentDsName() {
        return this.dynamicDatasourceService.getCurrentDatasourceName();
    }
}

