/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;

public class LambdaQueryUtil {
    private static final int MAX_IN_LIMIT = 1000;
    private static final int MAX_OR_LIMIT = 2000;
    private static final int MAX_SQL_LENGTH = 0xA00000;

    public static <T, R, Func> void wrapperWithMultiQuery(LambdaQueryWrapper<T> queryWrapper, SFunction<T, Func> function, List<R> list) {
        queryWrapper.and(qw -> {
            if (ToolUtil.isNotEmpty((Object)list)) {
                List splitList = LambdaQueryUtil.getSplitList(list);
                for (List item : splitList) {
                    ((LambdaQueryWrapper)qw.or()).in((Object)function, item);
                }
            }
        });
    }

    public static <T, R, Func> LambdaQueryWrapper<T> getMultiQueryWrapper(SFunction<T, Func> function, List<R> list) {
        return (LambdaQueryWrapper)new LambdaQueryWrapper().and(qw -> {
            if (ToolUtil.isNotEmpty((Object)list)) {
                List splitList = LambdaQueryUtil.getSplitList(list);
                for (List item : splitList) {
                    ((LambdaQueryWrapper)qw.or()).in((Object)function, item);
                }
            }
        });
    }

    public static <R> List<List<R>> getSplitList(List<R> list) {
        ArrayList<List<R>> splitList = new ArrayList<List<R>>();
        int size = list.size();
        if (size < 1000) {
            splitList.add(list);
        } else {
            int splitNum = size % 1000 == 0 ? size / 1000 : size / 1000 + 1;
            for (int i = 0; i < splitNum; ++i) {
                List<R> element = i < splitNum - 1 ? list.subList(i * 1000, (i + 1) * 1000) : list.subList(i * 1000, list.size());
                splitList.add(element);
            }
        }
        return splitList;
    }

    public static <R> List<List<R>> getSplitListLt(List<R> list, int lt) {
        ArrayList<List<R>> splitList = new ArrayList<List<R>>();
        int size = list.size();
        if (size < lt) {
            splitList.add(list);
        } else {
            int splitNum = size % lt == 0 ? size / lt : size / lt + 1;
            for (int i = 0; i < splitNum; ++i) {
                List<R> element = i < splitNum - 1 ? list.subList(i * lt, (i + 1) * lt) : list.subList(i * lt, list.size());
                splitList.add(element);
            }
        }
        return splitList;
    }
}

