/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils;

import org.springframework.util.StringUtils;

public class ByteArrayUtils {
    public static byte[] toByteArray(String hexString) {
        String newHexString = hexString;
        if (StringUtils.isEmpty((Object)newHexString)) {
            throw new IllegalArgumentException("this hexString must not be empty");
        }
        newHexString = newHexString.toLowerCase();
        byte[] byteArray = new byte[newHexString.length() / 2];
        int k = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            byte high = (byte)(Character.digit(newHexString.charAt(k), 16) & 0xFF);
            byte low = (byte)(Character.digit(newHexString.charAt(k + 1), 16) & 0xFF);
            byteArray[i] = (byte)(high << 4 | low & 0xFF);
            k += 2;
        }
        return byteArray;
    }

    public static String toHexString(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 1) {
            throw new IllegalArgumentException("this byteArray must not be null or empty");
        }
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if ((byteArray[i] & 0xFF) < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return hexString.toString().toLowerCase();
    }
}

