/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.config;

import com.jxdinfo.hussar.common.cache.DefaultDynamicCachePrefixServiceImpl;
import com.jxdinfo.hussar.common.config.CoreConfig;
import com.jxdinfo.hussar.common.core.config.WebHandleConfig;
import com.jxdinfo.hussar.common.datasource.support.BaseHeaderDatasourceKeyProcesser;
import com.jxdinfo.hussar.core.HussarCoreAutoConfiguration;
import com.jxdinfo.hussar.platform.core.support.service.CacheCreatorService;
import com.jxdinfo.hussar.support.cache.config.HussarCacheConfiguration;
import com.jxdinfo.hussar.support.datasource.config.DynamicDatasourceConfig;
import com.jxdinfo.hussar.support.datasource.support.HeaderDatasourceKey;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ImportAutoConfiguration(value={HussarCoreAutoConfiguration.class})
@AutoConfigureAfter(value={HussarCacheConfiguration.class})
@AutoConfigureBefore(value={DynamicDatasourceConfig.class})
@ServletComponentScan(basePackages={"com.jxdinfo.hussar.common"})
@ComponentScan(basePackages={"com.jxdinfo.hussar.common"})
@Import(value={WebHandleConfig.class, CoreConfig.class})
public class HussarCommonAutoConfig {
    @Bean
    @ConditionalOnProperty(prefix="hussar.core.tenant", name={"enabled"}, havingValue="false", matchIfMissing=true)
    public HeaderDatasourceKey headerDatasourceKey() {
        return new BaseHeaderDatasourceKeyProcesser();
    }

    @Bean(value={"com.jxdinfo.hussar.common.executorService"})
    @ConditionalOnMissingBean
    public ExecutorService executorService() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 50, 60L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        return executor;
    }

    @ConditionalOnProperty(prefix="hussar.core.tenant", name={"enabled"}, havingValue="false")
    @Bean(value={"com.jxdinfo.hussar.common.defaultCacheCreatorService"})
    public CacheCreatorService defaultCacheCreatorService() {
        return new DefaultDynamicCachePrefixServiceImpl();
    }
}

