/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils.lowcodeutils;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;
import java.util.List;
import java.util.Map;

public class DataModelSqlUtil {
    public static <T> String getTargetsSql(T searchObj, List<Map<String, String>> maps) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map<String, String> map : maps) {
            String columnName = map.get("columnName");
            String fieldName = columnName;
            String column = DataModelSqlUtil.getAlias(searchObj, fieldName);
            if (!ToolUtil.isNotEmpty((Object)column)) continue;
            String function = map.get("agg");
            if ("DISTINCT".equalsIgnoreCase(function)) {
                stringBuilder.append("count(").append(function).append("(").append(column).append(")) AS ").append(map.get("asAlias")).append(",");
                continue;
            }
            stringBuilder.append(function).append("(").append(column).append(") AS ").append(map.get("asAlias")).append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static <T> String getDimsSql(T searchObj, List<String> dims) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String dim : dims) {
            String column = DataModelSqlUtil.getAlias(searchObj, dim);
            if (!ToolUtil.isNotEmpty((Object)column)) continue;
            stringBuilder.append(column).append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static <T> String getAlias(T searchObj, String name) {
        return MpUtils.getTableFieldName(searchObj.getClass(), (String)name);
    }

    public static <T> String getOrderSql(T searchObj, List<OrderItem> orders) {
        StringBuilder returnOrders = new StringBuilder();
        if (ToolUtil.isNotEmpty(orders)) {
            returnOrders.append("ORDER BY ");
            for (OrderItem orderItem : orders) {
                returnOrders.append(orderItem.getColumn()).append("Order").append(orderItem.isAsc() ? " ASC" : " DESC").append(", ");
            }
        }
        if (ToolUtil.isNotEmpty((Object)returnOrders.toString())) {
            returnOrders = new StringBuilder(returnOrders.substring(0, returnOrders.lastIndexOf(",")));
        }
        return returnOrders.toString();
    }

    public static String getSnakeCaseOrderSql(List<OrderItem> orders) {
        StringBuilder returnOrders = new StringBuilder();
        if (ToolUtil.isNotEmpty(orders)) {
            returnOrders.append("ORDER BY ");
            for (OrderItem orderItem : orders) {
                returnOrders.append(orderItem.getColumn().replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase()).append(orderItem.isAsc() ? " ASC" : " DESC").append(", ");
            }
        }
        if (ToolUtil.isNotEmpty((Object)returnOrders.toString())) {
            returnOrders = new StringBuilder(returnOrders.substring(0, returnOrders.lastIndexOf(",")));
        }
        return returnOrders.toString();
    }

    public static <T> String addOrderSelect(T searchObj, List<OrderItem> orders) {
        StringBuilder addOrders = new StringBuilder();
        String function = "MAX";
        if (ToolUtil.isNotEmpty(orders)) {
            addOrders.append(", ");
            for (OrderItem orderItem : orders) {
                String column = DataModelSqlUtil.getAlias(searchObj, orderItem.getColumn()).replace("(", "").replace(")", "");
                addOrders.append(function).append("(").append(column).append(") AS ").append(orderItem.getColumn()).append("Order,");
            }
        }
        if (addOrders.length() > 0) {
            addOrders.deleteCharAt(addOrders.length() - 1);
        }
        return addOrders.toString();
    }
}

