/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.treemodel;

import com.jxdinfo.hussar.common.treemodel.TreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public final class TreeParser {
    private TreeParser() {
    }

    public static <T extends TreeModel<T>> List<T> getTreeList(Collection<T> dataList) {
        TreeModel temp;
        ArrayList<TreeModel> roots = new ArrayList<TreeModel>();
        AssertUtil.isNotEmpty(dataList, "\u672a\u4f20\u9012\u6570\u636e");
        ArrayList<Long> parentIds = new ArrayList<Long>();
        LinkedHashMap<Long, TreeModel> map = new LinkedHashMap<Long, TreeModel>();
        for (TreeModel item : dataList) {
            map.put(item.getId(), item);
        }
        for (TreeModel item : dataList) {
            temp = (TreeModel)map.get(item.getParent());
            if (temp != null) {
                temp.getChildrenList().add(item);
                continue;
            }
            parentIds.add(item.getId());
        }
        for (Long id : parentIds) {
            temp = (TreeModel)map.get(id);
            if (!HussarUtils.isNotEmpty((Object)temp)) continue;
            roots.add(temp);
        }
        return roots;
    }
}

