/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.core.intercept;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.encrypt.util.SM3Util;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.plugin.oauth2.SecurityOAuth2Manager;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class GetRequestInterceptor
implements HandlerInterceptor {
    @Autowired
    private SecureAssesmentProperties secureAssesmentProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.secureAssesmentProperties.isOpen()) {
            String token = request.getHeader("Authorization");
            if (token == null) {
                return true;
            }
            SecurityOAuth2Config config = SecurityOAuth2Manager.getConfig();
            if (!config.isEnableIsolateFeign() && HussarUtils.isNotEmpty((Object)request.getHeader(config.getFeignKey())) && config.getFeignSign().equals(request.getHeader(config.getFeignKey()))) {
                return true;
            }
            String dataDigest = request.getHeader("data-digest");
            if (HussarUtils.isNotBlank((CharSequence)dataDigest)) {
                String jsonStr;
                String digest;
                JSONObject jsonObject = new JSONObject(new LinkedHashMap());
                jsonObject.put("token", (Object)token);
                String urlParameter = request.getQueryString();
                if (urlParameter != null) {
                    try {
                        urlParameter = URLDecoder.decode(urlParameter, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    String[] keyAndValue = urlParameter.split("&");
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < keyAndValue.length; ++i) {
                        String value = StringUtils.substringAfter((String)keyAndValue[i], (String)"=");
                        if (!HussarUtils.isNotBlank((CharSequence)value)) continue;
                        sb.append(keyAndValue[i]).append("&");
                    }
                    if (sb.length() > 0) {
                        jsonObject.put("param", (Object)sb.substring(0, sb.length() - 1));
                    }
                }
                if ((digest = SM3Util.digest((String)(jsonStr = jsonObject.toString()))).equals(dataDigest)) {
                    return true;
                }
                throw new HussarException("\u68c0\u6d4b\u5230\u8d8a\u6743\u64cd\u4f5c\uff01");
            }
            throw new HussarException("\u68c0\u6d4b\u5230\u8d8a\u6743\u64cd\u4f5c\uff01");
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

