/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.core.config;

import com.jxdinfo.hussar.common.core.intercept.GetRequestInterceptor;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class InterceptorConfig
implements WebMvcConfigurer {
    @Autowired
    private GetRequestInterceptor getRequestInterceptor;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;

    public void addInterceptors(InterceptorRegistry registry) {
        if (this.secureAssesmentProperties.isOpen()) {
            ArrayList<String> excludePathPatterns = new ArrayList<String>(Arrays.asList("/global/sessionError", "/global/error", "/exception/repeat", "/speed/**", "/unifiedtodo/saveTask", "/unifiedtodo/updateTask", "/unifiedtodo/deleteTask", "/unifiedtodo/updateTaskStatus", "/unifiedtodo/updateUserStatus", "/unifiedtodo/updateTaskUser", "/unifiedtodo/addTaskUser", "/unifiedtodo/deleteTaskUser", "/themeConfig/**", "/server/acquire", "/server/assert", "/importComponent/**", "/**/importComponent/**", "/formdesign/**", "/configure/**", "/speedcode/**", "/pageTemplate/**", "/clientQuery", "/hussarBase/application/**", "/query", "/remote*/**", "/queryAppName"));
            if (this.secureAssesmentProperties.getExcludePathPatterns() != null && this.secureAssesmentProperties.getExcludePathPatterns().size() > 0) {
                excludePathPatterns.addAll(this.secureAssesmentProperties.getExcludePathPatterns());
            }
            registry.addInterceptor((HandlerInterceptor)this.getRequestInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(excludePathPatterns);
        }
    }
}

