/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.colony.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.colony.dao.SysSynchronousAddressMapper;
import com.jxdinfo.hussar.colony.model.SysSynchronousAddress;
import com.jxdinfo.hussar.colony.service.IHussarBaseSynchronousAddressService;
import com.jxdinfo.hussar.colony.service.ISysSynchronousAddressService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.handler.LogObjectHolder;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.colony.service.impl.hussarBaseSynchronousAddressServiceImpl")
public class HussarBaseSynchronousAddressServiceImpl
implements IHussarBaseSynchronousAddressService {
    @Autowired
    private SysSynchronousAddressMapper synchronousAddresseMapper;
    @Autowired
    private ISysSynchronousAddressService synchronousAddressService;
    @Autowired
    private LogObjectHolder logObjectHolder;

    public Page<SysSynchronousAddress> hussarQueryPage(PageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<SysSynchronousAddress> sysSynchronousAddresses = this.synchronousAddresseMapper.hussarQueryPage(page);
        page.setRecords(sysSynchronousAddresses);
        return page;
    }

    public boolean del(Long[] ids) {
        Set idSet = Arrays.stream(ids).collect(Collectors.toSet());
        List list = this.synchronousAddressService.listByIds(idSet);
        List tenantNames = list.stream().map(SysSynchronousAddress::getAddress).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("address", StringUtils.join((Object[])tenantNames.toArray(), (String)","));
        this.logObjectHolder.set("edit_object_after", map);
        if (idSet.size() > 0) {
            this.synchronousAddressService.removeByIds(idSet);
        }
        return true;
    }

    public Long insertOrUpdate(SysSynchronousAddress sysSynchronousAddress) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysSynchronousAddress::getAddress, (Object)sysSynchronousAddress.getAddress());
        if (ToolUtil.isEmpty((Object)sysSynchronousAddress.getId())) {
            sysSynchronousAddress.setCreateTime(LocalDateTime.now());
        } else {
            sysSynchronousAddress.setUpdateTime(LocalDateTime.now());
            queryWrapper.ne(SysSynchronousAddress::getId, (Object)sysSynchronousAddress.getId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", sysSynchronousAddress.getId());
            map.put("address", sysSynchronousAddress.getAddress());
            this.logObjectHolder.set(map);
        }
        long count = this.synchronousAddressService.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new BaseException("\u8bbf\u95ee\u5730\u5740\u5df2\u7ecf\u5b58\u5728");
        }
        this.synchronousAddressService.saveOrUpdate((Object)sysSynchronousAddress);
        return sysSynchronousAddress.getId();
    }

    public SysSynchronousAddress formQuery(Long id) {
        return (SysSynchronousAddress)this.synchronousAddressService.getById((Serializable)id);
    }
}

