/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.code.plus.dao.SysCodeRuleInfoMapper;
import com.jxdinfo.hussar.code.plus.dao.SysCodeRuleIsLevelMapper;
import com.jxdinfo.hussar.code.plus.dao.SysCodeRuleMapper;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleConfigDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeSaveDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeUpdateDto;
import com.jxdinfo.hussar.code.plus.enums.TipConstantsEnum;
import com.jxdinfo.hussar.code.plus.model.SysCodeRule;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleIsLevel;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleInfoService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRulesIsLevel;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.model.SysIdtableInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.code.plus.service.impl.SysCodeRuleServiceImpl")
public class SysCodeRuleServiceImpl
extends HussarServiceImpl<SysCodeRuleMapper, SysCodeRule>
implements ISysCodeRuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysCodeRuleServiceImpl.class);
    @Resource
    private ISysCodeRuleService sysCodeRuleService;
    @Resource
    private ISysCodeRuleInfoService sysCodeRuleInfoService;
    @Resource
    private ISysCodeRulesIsLevel sysCodeRulesIsLevel;
    @Resource
    private SysCodeRuleMapper sysCodeRuleMapper;
    @Resource
    private SysCodeRuleInfoMapper sysCodeRuleInfoMapper;
    @Resource
    private SysCodeRuleIsLevelMapper sysCodeRuleIsLevelMapper;
    @Autowired
    private ISysCodeRuleRefService sysCodeRuleRefService;

    public ApiResponse<SysCodeRuleVo> getCodeRule(Long codeRuleId) {
        SysCodeRuleDto sysCodeRuleDto = new SysCodeRuleDto();
        sysCodeRuleDto.setRuleId(codeRuleId);
        SysCodeRuleVo sysCodeRuleVo = this.sysCodeRuleMapper.listCodeRules(sysCodeRuleDto);
        return ApiResponse.success((Object)sysCodeRuleVo);
    }

    public List<SysCodeRuleVo> getCodeRulesList(SysCodeRuleDto sysCodeRuleDto) {
        return this.sysCodeRuleMapper.listCodeRulesByIds(sysCodeRuleDto);
    }

    public ApiResponse<Page<SysCodeRuleVo>> listCodeRules(SysCodeRuleDto sysCodeRuleDto) {
        String tenantCode = sysCodeRuleDto.getTenantCode();
        String connName = "master";
        HussarTenantDefinition hussarTenantDefinition = null;
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
            if (null != hussarTenantDefinition) {
                connName = hussarTenantDefinition.getConnName();
            }
        } else {
            connName = HussarContextHolder.getConnName();
        }
        this.sysCodeRuleRefService.updateScheduled(connName);
        if (hussarTenantDefinition != null) {
            HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
        }
        String ruleCode = sysCodeRuleDto.getRuleCode();
        String codeRuleName = sysCodeRuleDto.getCodeRuleName();
        String codeRuleDesc = sysCodeRuleDto.getCodeRuleDesc();
        Long appId = sysCodeRuleDto.getAppId();
        sysCodeRuleDto.setRuleCode(SqlQueryUtil.transferSpecialChar((String)ruleCode));
        sysCodeRuleDto.setCodeRuleName(SqlQueryUtil.transferSpecialChar((String)codeRuleName));
        sysCodeRuleDto.setCodeRuleDesc(SqlQueryUtil.transferSpecialChar((String)codeRuleDesc));
        sysCodeRuleDto.setAppId(appId);
        sysCodeRuleDto.setEscapeSymbol("|");
        Page pager = new Page((long)sysCodeRuleDto.getPageNo().intValue(), (long)sysCodeRuleDto.getPageSize().intValue());
        List<SysCodeRuleVo> sysCodeRuleVoList = this.sysCodeRuleMapper.listCodeRules((Page<SysCodeRuleVo>)pager, sysCodeRuleDto);
        pager.setRecords(sysCodeRuleVoList);
        return ApiResponse.success((Object)pager);
    }

    public ApiResponse<Page<SysCodeRuleVo>> listCodeRulesNoSys(SysCodeRuleDto sysCodeRuleDto) {
        sysCodeRuleDto.setIsSys("0");
        return this.sysCodeRuleService.listCodeRules(sysCodeRuleDto);
    }

    public Page<SysCodeRuleVo> getPageListCodeRules(SysCodeRuleDto sysCodeRuleDto) {
        String ruleCode = sysCodeRuleDto.getRuleCode();
        String codeRuleName = sysCodeRuleDto.getCodeRuleName();
        String codeRuleDesc = sysCodeRuleDto.getCodeRuleDesc();
        sysCodeRuleDto.setRuleCode(SqlQueryUtil.transferSpecialChar((String)ruleCode));
        sysCodeRuleDto.setCodeRuleName(SqlQueryUtil.transferSpecialChar((String)codeRuleName));
        sysCodeRuleDto.setCodeRuleDesc(SqlQueryUtil.transferSpecialChar((String)codeRuleDesc));
        sysCodeRuleDto.setEscapeSymbol("|");
        Page pager = new Page((long)sysCodeRuleDto.getPageNo().intValue(), (long)sysCodeRuleDto.getPageSize().intValue());
        List<SysCodeRuleVo> sysCodeRuleVoList = this.sysCodeRuleMapper.listCodeRules((Page<SysCodeRuleVo>)pager, sysCodeRuleDto);
        pager.setRecords(sysCodeRuleVoList);
        return pager;
    }

    @HussarTransactional
    public ApiResponse<String> saveCodeRule(SysCodeSaveDto sysCodeSaveDto) {
        SysCodeRule one;
        SysCodeRule sysCodeRule = new SysCodeRule();
        if (HussarUtils.isNotEmpty((Object)sysCodeSaveDto.getCodeRuleCode()) && HussarUtils.isNotEmpty((Object)(one = (SysCodeRule)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SysCodeRule::getCodeRuleCode, (Object)sysCodeSaveDto.getCodeRuleCode())).eq(sysCodeSaveDto.getAppId() != null, SysCodeRule::getAppId, (Object)sysCodeSaveDto.getAppId())).isNull(HussarUtils.isNull((Object)sysCodeSaveDto.getAppId()), SysCodeRule::getAppId)).one()))) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_IDENTIFIER_EXIST.getMessage()));
        }
        String codeRule = StringUtils.trimToEmpty((String)sysCodeSaveDto.getCodeRuleCode());
        String codeRuleName = StringUtils.trimToEmpty((String)sysCodeSaveDto.getCodeRuleName());
        String codeRuleDesc = StringUtils.trimToEmpty((String)sysCodeSaveDto.getCodeRuleDesc());
        String sys = sysCodeSaveDto.getSys();
        String level = sysCodeSaveDto.getLevel();
        Long appId = sysCodeSaveDto.getAppId();
        sysCodeRule.setId(Long.valueOf(IdWorker.getId((Object)sysCodeSaveDto)));
        sysCodeRule.setCodeRuleCode(codeRule);
        if (HussarUtils.isNotEmpty((Object)codeRuleName)) {
            sysCodeRule.setCodeRuleName(codeRuleName);
        }
        if (HussarUtils.isNotEmpty((Object)codeRuleDesc)) {
            sysCodeRule.setCodeRuleDesc(codeRuleDesc);
        }
        if (HussarUtils.isNotEmpty((Object)sys)) {
            sysCodeRule.setSys(sys);
        }
        if (HussarUtils.isNotEmpty((Object)level)) {
            sysCodeRule.setCodeRuleLevel(level);
        }
        if (HussarUtils.isNotEmpty((Object)appId)) {
            sysCodeRule.setAppId(appId);
        }
        this.sysCodeRuleService.save((Object)sysCodeRule);
        List sysCodeRuleConfigList = sysCodeSaveDto.getSysCodeRuleConfigList();
        if (HussarUtils.isNotEmpty((Object)sysCodeRuleConfigList)) {
            ArrayList<SysCodeRuleInfo> sysCodeRuleInfoList = new ArrayList<SysCodeRuleInfo>();
            for (int i = 0; i < sysCodeRuleConfigList.size(); ++i) {
                SysCodeRuleConfigDto sysCodeRuleConfigDto = (SysCodeRuleConfigDto)sysCodeRuleConfigList.get(i);
                Long codeRuleInfoId = sysCodeRuleConfigDto.getCodeRuleInfoId();
                String elementType = StringUtils.trimToEmpty((String)sysCodeRuleConfigDto.getElementType());
                SysCodeRuleInfo temp = new SysCodeRuleInfo();
                temp.setCodeRuleSort(Integer.valueOf(i + 1));
                temp.setCodeRuleId(sysCodeRule.getId());
                temp.setResetPeriod(StringUtils.isNotBlank((CharSequence)sysCodeRuleConfigDto.getResetPeriod()) ? sysCodeRuleConfigDto.getResetPeriod() : "1");
                temp.setElementType(sysCodeRuleConfigDto.getElementType());
                temp.setElementPattern(sysCodeRuleConfigDto.getElementPattern());
                temp.setSerialNumberLength(sysCodeRuleConfigDto.getSerialNumberLength());
                temp.setEnableCache(sysCodeRuleConfigDto.getEnableCache());
                if (elementType.equals("serialNumber") && sysCodeRuleConfigDto.getSerialNumberStart() == null) {
                    temp.setSerialNumberStart(Long.valueOf(1L));
                } else {
                    temp.setSerialNumberStart(sysCodeRuleConfigDto.getSerialNumberStart());
                }
                if (codeRuleInfoId != null) {
                    temp.setId(codeRuleInfoId);
                }
                sysCodeRuleInfoList.add(temp);
            }
            this.sysCodeRuleInfoService.saveBatch(sysCodeRuleInfoList);
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_ADD_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public ApiResponse<String> updateCodeRule(SysCodeUpdateDto sysCodeUpdateDto) {
        String oldRuleCode = this.sysCodeRuleMapper.getRuleCode(sysCodeUpdateDto.getCodeRuleId());
        this.sysCodeRuleRefService.updateBeforeRuleChanged(oldRuleCode);
        String codeRule = StringUtils.trimToEmpty((String)sysCodeUpdateDto.getCodeRuleCode());
        String codeRuleName = StringUtils.trimToEmpty((String)sysCodeUpdateDto.getCodeRuleName());
        String codeRuleDesc = StringUtils.trimToEmpty((String)sysCodeUpdateDto.getCodeRuleDesc());
        String sys = sysCodeUpdateDto.getSys();
        String level = sysCodeUpdateDto.getLevel();
        if (HussarUtils.isEmpty((Object)codeRule)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_IDENTIFIER_EMPTY.getMessage()));
        }
        if (!codeRule.equals(oldRuleCode)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysCodeRule::getCodeRuleCode, (Object)codeRule)).eq(sysCodeUpdateDto.getAppId() != null, SysCodeRule::getAppId, (Object)sysCodeUpdateDto.getAppId())).isNull(HussarUtils.isNull((Object)sysCodeUpdateDto.getAppId()), SysCodeRule::getAppId);
            SysCodeRule sysCodeRule = (SysCodeRule)this.sysCodeRuleService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysCodeRule)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_IDENTIFIER_EXIST.getMessage()));
            }
        }
        SysCodeRule sysCodeRule = new SysCodeRule();
        sysCodeRule.setId(sysCodeUpdateDto.getCodeRuleId());
        sysCodeRule.setCodeRuleCode(codeRule);
        if (HussarUtils.isNotBlank((CharSequence)codeRuleName)) {
            sysCodeRule.setCodeRuleName(sysCodeUpdateDto.getCodeRuleName());
        }
        if (HussarUtils.isNotBlank((CharSequence)codeRuleDesc)) {
            sysCodeRule.setCodeRuleDesc(codeRuleDesc);
        }
        if (HussarUtils.isNotBlank((CharSequence)sys)) {
            sysCodeRule.setSys(sys);
        }
        if (HussarUtils.isNotBlank((CharSequence)level)) {
            sysCodeRule.setCodeRuleLevel(level);
        }
        this.sysCodeRuleService.updateById((Object)sysCodeRule);
        List sysCodeRuleConfigList = sysCodeUpdateDto.getSysCodeRuleConfigList();
        AssertUtil.isNotEmpty((Collection)sysCodeRuleConfigList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_CONFIG_EMPTY.getMessage()));
        ArrayList<SysCodeRuleInfo> sysCodeRuleInfoList = new ArrayList<SysCodeRuleInfo>();
        List configList = sysCodeRuleConfigList.stream().filter(item -> item.getCodeRuleInfoId() != null).collect(Collectors.toList());
        ArrayList<Long> updateIds = new ArrayList();
        if (HussarUtils.isNotEmpty(configList)) {
            Map map = EntityUtils.toMap(configList, SysCodeRuleConfigDto::getCodeRuleInfoId);
            List sysCodeRuleInfos = this.sysCodeRuleInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysCodeRuleInfo::getId, map.keySet())).eq(SysCodeRuleInfo::getCodeRuleId, (Object)sysCodeUpdateDto.getCodeRuleId()));
            List deleteList = this.sysCodeRuleInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(SysCodeRuleInfo::getId, map.keySet())).eq(SysCodeRuleInfo::getCodeRuleId, (Object)sysCodeUpdateDto.getCodeRuleId()));
            Map<Long, Object> configMap = new HashMap<Long, SysCodeRuleInfo>();
            if (HussarUtils.isNotEmpty((Object)sysCodeRuleInfos)) {
                updateIds = sysCodeRuleInfos.stream().map(item -> item.getId()).collect(Collectors.toList());
                configMap = EntityUtils.toMap((Collection)sysCodeRuleInfos, SysCodeRuleInfo::getId);
            }
            if (HussarUtils.isNotEmpty((Object)deleteList)) {
                this.sysCodeRuleInfoService.removeByIds((Collection)deleteList);
            }
            this.initCodeRuleInfo(sysCodeRule, sysCodeRuleConfigList, sysCodeRuleInfoList, updateIds, configMap);
            this.sysCodeRuleInfoService.saveOrUpdateBatch(sysCodeRuleInfoList);
        } else {
            this.sysCodeRuleInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(SysCodeRuleInfo::getCodeRuleId, (Object)sysCodeUpdateDto.getCodeRuleId()));
            this.initCodeRuleInfo(sysCodeRule, sysCodeRuleConfigList, sysCodeRuleInfoList, null, null);
            this.sysCodeRuleInfoService.saveOrUpdateBatch(sysCodeRuleInfoList);
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_MODIFY_SUCCESS.getMessage()));
    }

    private void initCodeRuleInfo(SysCodeRule sysCodeRule, List<SysCodeRuleConfigDto> sysCodeRuleConfigList, List<SysCodeRuleInfo> sysCodeRuleInfoList, List<Long> updateIds, Map<Long, SysCodeRuleInfo> oldConfigMap) {
        for (int i = 0; i < sysCodeRuleConfigList.size(); ++i) {
            SysCodeRuleConfigDto sysCodeRuleConfigDto = sysCodeRuleConfigList.get(i);
            String elementType = StringUtils.trimToEmpty((String)sysCodeRuleConfigDto.getElementType());
            String elementPattern = sysCodeRuleConfigDto.getElementPattern();
            Integer serialNumberLength = sysCodeRuleConfigDto.getSerialNumberLength();
            Long serialNumberStart = sysCodeRuleConfigDto.getSerialNumberStart();
            String resetPeriod = StringUtils.isNotBlank((CharSequence)sysCodeRuleConfigDto.getResetPeriod()) ? sysCodeRuleConfigDto.getResetPeriod() : "1";
            Integer enableCache = sysCodeRuleConfigDto.getEnableCache();
            Long codeRuleInfoId = sysCodeRuleConfigDto.getCodeRuleInfoId();
            SysCodeRuleInfo temp = new SysCodeRuleInfo();
            if (HussarUtils.isNotEmpty(updateIds)) {
                boolean updateFlag;
                boolean bl = updateFlag = codeRuleInfoId != null && updateIds.contains(codeRuleInfoId);
                if (updateFlag) {
                    temp.setId(codeRuleInfoId);
                    temp.setSerialNumberCode(oldConfigMap.get(codeRuleInfoId).getSerialNumberCode());
                }
            } else if (HussarUtils.isNotEmpty((Object)codeRuleInfoId)) {
                temp.setId(codeRuleInfoId);
            }
            temp.setCodeRuleSort(Integer.valueOf(i + 1));
            temp.setCodeRuleId(sysCodeRule.getId());
            temp.setResetPeriod(resetPeriod);
            temp.setElementType(elementType);
            temp.setElementPattern(elementPattern);
            temp.setSerialNumberLength(serialNumberLength);
            temp.setEnableCache(enableCache);
            if (elementType.equals("serialNumber") && serialNumberStart == null) {
                temp.setSerialNumberStart(Long.valueOf(1L));
            } else {
                temp.setSerialNumberStart(serialNumberStart);
            }
            sysCodeRuleInfoList.add(temp);
        }
    }

    @HussarTransactional
    public ApiResponse<String> deleteCodeRule(List<Long> codeRuleIds) {
        if (HussarUtils.isEmpty(codeRuleIds)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_PARAMETER_EMPTY.getMessage()));
        }
        for (Long codeRuleId : codeRuleIds) {
            String ruleCode = this.sysCodeRuleMapper.getRuleCode(codeRuleId);
            this.sysCodeRuleRefService.updateBeforeRuleChanged(ruleCode);
            String isSys = this.sysCodeRuleMapper.getIsSys(codeRuleId);
            if (!"1".equals(isSys)) continue;
            return ApiResponse.fail((String)(ruleCode + TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_SYS_NOT_DELETE.getMessage())));
        }
        if (!this.removeByIds(codeRuleIds)) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_DELETE_FAIL.getMessage()));
        }
        this.sysCodeRuleInfoMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysCodeRuleInfo::getCodeRuleId, codeRuleIds));
        this.sysCodeRuleIsLevelMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysCodeRuleIsLevel::getIdtableId, codeRuleIds));
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_DELETE_SUCCESS.getMessage()));
    }

    public ApiResponse<String> saveOldToNew() {
        List<SysIdtable> sysIdtableList = this.sysCodeRuleMapper.listSysIdtable();
        ArrayList<SysCodeSaveDto> sysCodeDTOList = new ArrayList<SysCodeSaveDto>();
        for (SysIdtable sysIdtable : sysIdtableList) {
            SysCodeRuleConfigDto sysCodeRuleConfigDto;
            SysCodeSaveDto sysCodeSaveDto = new SysCodeSaveDto();
            ArrayList sysCodeRuleConfigList = new ArrayList();
            sysCodeSaveDto.setCodeRuleCode(sysIdtable.getTableName() + ":" + sysIdtable.getFieldName());
            if (HussarUtils.isNotEmpty((Object)sysIdtable.getIdDesc())) {
                sysCodeSaveDto.setCodeRuleName(sysIdtable.getIdDesc());
                sysCodeSaveDto.setCodeRuleDesc(sysIdtable.getIdDesc());
            }
            if (HussarUtils.isNotEmpty((Object)sysIdtable.getIsSys())) {
                sysCodeSaveDto.setSys(sysIdtable.getIsSys());
            }
            if (HussarUtils.isNotEmpty((Object)sysIdtable.getIsLevel())) {
                sysCodeSaveDto.setLevel(sysIdtable.getIsLevel());
            }
            if ("1".equals(sysIdtable.getIsPrefix())) {
                sysCodeRuleConfigDto = new SysCodeRuleConfigDto();
                if (sysIdtable.getIdPrefix().indexOf("[") == 0 && sysIdtable.getIdPrefix().indexOf("]") == sysIdtable.getIdPrefix().length() - 1) {
                    sysCodeRuleConfigDto.setElementType("codeDateTime");
                } else {
                    sysCodeRuleConfigDto.setElementType("constant");
                }
                sysCodeRuleConfigDto.setElementPattern(sysIdtable.getIdPrefix());
                sysCodeRuleConfigList.add(sysCodeRuleConfigDto);
            }
            if (HussarUtils.isNotEmpty((Object)sysIdtable.getCacheSize()) && HussarUtils.isNotEmpty((Object)sysIdtable.getIdValue())) {
                sysCodeRuleConfigDto = new SysCodeRuleConfigDto();
                sysCodeRuleConfigDto.setElementType("serialNumber");
                sysCodeRuleConfigDto.setElementPattern(sysIdtable.getCacheSize().toString());
                sysCodeRuleConfigDto.setSerialNumberLength(sysIdtable.getIdLength());
                sysCodeRuleConfigDto.setSerialNumberCode(Long.valueOf((long)sysIdtable.getIdValue().intValue() + 0L));
                sysCodeRuleConfigDto.setSerialNumberStart(Long.valueOf(1L));
                sysCodeRuleConfigDto.setResetPeriod("1");
                sysCodeRuleConfigList.add(sysCodeRuleConfigDto);
            }
            if ("1".equals(sysIdtable.getIsSuffix())) {
                sysCodeRuleConfigDto = new SysCodeRuleConfigDto();
                sysCodeRuleConfigDto.setElementType("constant");
                sysCodeRuleConfigDto.setElementPattern(sysIdtable.getIdSuffix());
                sysCodeRuleConfigList.add(sysCodeRuleConfigDto);
            }
            sysCodeSaveDto.setSysCodeRuleConfigList((List)sysCodeRuleConfigList);
            sysCodeDTOList.add(sysCodeSaveDto);
        }
        if (sysCodeDTOList.size() != sysIdtableList.size()) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_MIGRATION_FAIL.getMessage()));
        }
        int count = 0;
        for (SysCodeSaveDto sysCodeSaveDto : sysCodeDTOList) {
            this.saveCodeRule(sysCodeSaveDto);
            ++count;
        }
        if (count != sysCodeDTOList.size()) {
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_MIGRATION_FAIL.getMessage()));
        }
        List<SysIdtableInfo> list = this.sysCodeRuleMapper.listSysIdtableInfo();
        ArrayList<SysCodeRuleIsLevel> sysCodeRuleIsLevelList = new ArrayList<SysCodeRuleIsLevel>();
        if (HussarUtils.isNotEmpty(list)) {
            for (SysIdtableInfo sysIdtableInfo : list) {
                SysCodeRuleIsLevel sysCodeRuleIsLevel = new SysCodeRuleIsLevel();
                sysCodeRuleIsLevel.setId(sysIdtableInfo.getId());
                if (HussarUtils.isNotEmpty((Object)sysIdtableInfo.getIdValue())) {
                    sysCodeRuleIsLevel.setIdValue(sysIdtableInfo.getIdValue());
                }
                if (HussarUtils.isNotEmpty((Object)sysIdtableInfo.getIdtableId())) {
                    sysCodeRuleIsLevel.setIdtableId(sysIdtableInfo.getIdtableId());
                }
                if (HussarUtils.isNotEmpty((Object)sysIdtableInfo.getParentNumber())) {
                    sysCodeRuleIsLevel.setParentNumber(sysIdtableInfo.getParentNumber());
                }
                sysCodeRuleIsLevelList.add(sysCodeRuleIsLevel);
            }
            boolean flag = this.sysCodeRulesIsLevel.saveOrUpdateBatch(sysCodeRuleIsLevelList);
            if (!flag) {
                return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_OLD_VERSION_RULE_LEVEL_MIGRATION_FAIL.getMessage()));
            }
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_MIGRATION_SUCCESS.getMessage()));
    }

    @HussarTransactional
    public String getCurrentCode(CodePlusDto codePlusDto) {
        String ruleCode = codePlusDto.getRuleCode();
        String level = codePlusDto.getLevel();
        if (HussarUtils.isBlank((CharSequence)level)) {
            level = "0";
        }
        if (level.equalsIgnoreCase("1")) {
            String parentNumber = codePlusDto.getParentNumber();
            return this.sysCodeRuleRefService.getCurrentCodeByParentNumber(codePlusDto);
        }
        return this.sysCodeRuleRefService.getCurrentCode(codePlusDto);
    }

    @HussarTransactional
    public List<String> getBatchCurrentCodes(List<CodePlusDto> codePlusDtoList) {
        ArrayList<String> result = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(codePlusDtoList)) {
            for (CodePlusDto codePlusDto : codePlusDtoList) {
                result.add(this.getCurrentCode(codePlusDto));
            }
        }
        return result;
    }

    @HussarTransactional
    public ApiResponse<String> resetSerialNumber(String ruleCode, Long appId) {
        SysCodeRule sysCodeRule = (SysCodeRule)this.sysCodeRuleMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCodeRule::getCodeRuleCode, (Object)ruleCode)).eq(appId != null, SysCodeRule::getAppId, (Object)appId)).isNull(HussarUtils.isNull((Object)appId), SysCodeRule::getAppId));
        AssertUtil.isNotNull((Object)sysCodeRule, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_NOT_FOUND_CODE_RULE.getMessage()));
        List sysCodeRuleInfoList = this.sysCodeRuleInfoMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysCodeRuleInfo::getCodeRuleId, (Object)sysCodeRule.getId()));
        if (HussarUtils.isEmpty((Object)sysCodeRuleInfoList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_NOT_FOUND_CODE_RULE.getMessage()));
        }
        String connName = HussarContextHolder.getConnName();
        this.sysCodeRuleRefService.updateScheduled(connName);
        String codeRuleCode = sysCodeRule.getCodeRuleCode();
        String ruleCodeCacheKey = codeRuleCode + "ruleCodeSet";
        for (SysCodeRuleInfo sysCodeRuleInfo : sysCodeRuleInfoList) {
            if (!StringUtils.isNotBlank((CharSequence)sysCodeRuleInfo.getElementType()) || !sysCodeRuleInfo.getElementType().equals("serialNumber")) continue;
            sysCodeRuleInfo.setSerialNumberCode(null);
            HussarCacheUtil.evict((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
        }
        this.sysCodeRuleInfoService.updateBatchById((Collection)sysCodeRuleInfoList);
        ArrayList<Map<String, Object>> listMapIsLevel = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotBlank((CharSequence)sysCodeRule.getCodeRuleLevel()) && "1".equals(sysCodeRule.getCodeRuleLevel())) {
            List<SysCodeRuleIsLevel> idTableByParentNumberList = this.sysCodeRuleMapper.getIdTableByParentNumber(ruleCode, "");
            for (SysCodeRuleIsLevel idTableByParentNumber : idTableByParentNumberList) {
                String parentNumber = idTableByParentNumber.getParentNumber();
                String codeRuleIsLevelKey = ruleCodeCacheKey + "isLevel" + parentNumber;
                HussarCacheUtil.evict((String)"codePlusCacheName", (Object)codeRuleIsLevelKey);
                HashMap<String, Object> mapIsLevel = new HashMap<String, Object>();
                mapIsLevel.put("ruleCodeId", sysCodeRule.getId());
                mapIsLevel.put("parentNumber", parentNumber);
                mapIsLevel.put("idValue", "0");
                listMapIsLevel.add(mapIsLevel);
            }
            if (HussarUtils.isNotEmpty(listMapIsLevel)) {
                this.sysCodeRuleMapper.updateCodeRuleIsLevelByParentNumber(listMapIsLevel);
            }
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_RESET_SERIAL_NUMBER_SUCCESS.getMessage()));
    }

    public ApiResponse<String> resetSerialNumber(String ruleCode) {
        return this.resetSerialNumber(ruleCode, null);
    }

    public ApiResponse<Long> getSerialNumberCode(String ruleCode) {
        SysCodeRule sysCodeRule = (SysCodeRule)this.sysCodeRuleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysCodeRule::getCodeRuleCode, (Object)ruleCode));
        AssertUtil.isNotNull((Object)sysCodeRule, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_NOT_FOUND_CODE_RULE.getMessage()));
        List sysCodeRuleInfoList = this.sysCodeRuleInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCodeRuleInfo::getCodeRuleId, (Object)sysCodeRule.getId())).eq(SysCodeRuleInfo::getElementType, (Object)"serialNumber")).orderByDesc(SysCodeRuleInfo::getCodeRuleSort));
        if (HussarUtils.isEmpty((Object)sysCodeRuleInfoList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_ENCODING_CONFIG_SERIAL_NUMBER_NOT_FOUND.getMessage()));
        }
        SysCodeRuleInfo sysCodeRuleInfo = (SysCodeRuleInfo)sysCodeRuleInfoList.get(0);
        return ApiResponse.success((Object)sysCodeRuleInfo.getSerialNumberCode());
    }

    public Long getSerialNumberCodeValue(String ruleCode) {
        return (Long)this.getSerialNumberCode(ruleCode).getData();
    }

    public String getCurrentCodeByCache(CodePlusDto codePlusDto) {
        String level = codePlusDto.getLevel();
        if (HussarUtils.isBlank((CharSequence)level)) {
            level = "0";
        }
        if (level.equalsIgnoreCase("1")) {
            return this.sysCodeRuleRefService.getCurrentCodeByParentNumberCache(codePlusDto);
        }
        return this.sysCodeRuleRefService.getCurrentCodeByCache(codePlusDto);
    }

    public void updateCacheToDb(CodePlusDto codePlusDto) {
        this.sysCodeRuleRefService.updateCacheToDb(codePlusDto);
    }

    public ApiResponse<SysCodeRuleVo> getCodeRuleByCode(String ruleCode) {
        return ApiResponse.success((Object)this.sysCodeRuleMapper.getCodeRule(ruleCode, null));
    }

    public ApiResponse<SysCodeRuleVo> getCodeRuleByCode(SysCodeRuleDto sysCodeRuleDto) {
        String ruleCode = sysCodeRuleDto.getRuleCode();
        Long appId = sysCodeRuleDto.getAppId();
        return ApiResponse.success((Object)this.sysCodeRuleMapper.getCodeRule(ruleCode, appId));
    }
}

