/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.service.impl;

import com.jxdinfo.hussar.code.plus.factory.GenerateValueFactory;
import com.jxdinfo.hussar.code.plus.factory.StrategyFactory;
import com.jxdinfo.hussar.code.plus.model.SysCodeRule;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.service.IGenerateValueService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleInfoService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.NumberUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.lock.HussarLockGuard;
import com.jxdinfo.hussar.support.lock.HussarLockManager;
import com.jxdinfo.hussar.support.lock.HussarLockType;
import com.jxdinfo.hussar.support.lock.annotation.HussarLockExecutionStrategy;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.code.plus.service.impl.serialNumberGenerateValueServiceImpl")
public class SerialNumberGenerateValueServiceImpl
implements IGenerateValueService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SerialNumberGenerateValueServiceImpl.class);
    private static final Integer MAX_RETRY_COUNT = 3;
    private static final Integer ENABLE_CACHE = 1;
    @Autowired
    private ISysCodeRuleInfoService sysCodeRuleInfoService;
    @Autowired
    private HussarLockManager lockManager;

    public String parse(SysCodeRuleInfo sysCodeRuleInfo, String ruleCode, SysCodeRuleVo sysCodeRuleVo, Map<String, Object> variableMap) {
        return this.parse(sysCodeRuleInfo, null, ruleCode, sysCodeRuleVo, variableMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parse(SysCodeRuleInfo sysCodeRuleInfo, SysCodeRule sysCodeRule, String ruleCode, SysCodeRuleVo sysCodeRuleVo, Map<String, Object> variableMap) {
        String lockKey = this.generateLockKey(ruleCode);
        HussarLockGuard lockGuard = this.acquireLock(lockKey);
        try {
            String elementPattern;
            Integer enableCache = sysCodeRuleInfo.getEnableCache();
            if (HussarUtils.isNotEmpty((Object)enableCache) && !HussarUtils.equals((Object)enableCache, (Object)ENABLE_CACHE)) {
                sysCodeRuleInfo = (SysCodeRuleInfo)this.sysCodeRuleInfoService.getById((Serializable)sysCodeRuleInfo.getId());
            }
            if (StringUtils.isBlank((CharSequence)(elementPattern = StringUtils.trimToEmpty((String)sysCodeRuleInfo.getElementPattern()))) || !NumberUtil.isNumber((CharSequence)elementPattern)) {
                throw new BaseException("\u6d41\u6c34\u53f7\u9012\u589e\u503c\u683c\u5f0f\u9519\u8bef!");
            }
            String key = ruleCode + "ruleCodeSet";
            SerialNumberGenerateValueServiceImpl.resetPeriod(sysCodeRuleInfo, key);
            Integer serialNumberLength = sysCodeRuleInfo.getSerialNumberLength();
            if (serialNumberLength == null) {
                throw new BaseException("\u6d41\u6c34\u53f7\u957f\u5ea6\u683c\u5f0f\u9519\u8bef!");
            }
            Long serialNumber = this.getSerialNumber(sysCodeRuleInfo, sysCodeRuleVo, serialNumberLength, elementPattern, key);
            String string = String.format("%0" + serialNumberLength + "d", serialNumber);
            return string;
        }
        finally {
            if (lockGuard != null) {
                lockGuard.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseByCache(SysCodeRuleInfo sysCodeRuleInfo, String ruleCode, SysCodeRuleVo sysCodeRuleVo, Map<String, Object> variableMap) {
        String lockKey = this.generateLockKey(ruleCode);
        HussarLockGuard lockGuard = this.acquireLock(lockKey);
        try {
            String elementPattern = StringUtils.trimToEmpty((String)sysCodeRuleInfo.getElementPattern());
            if (StringUtils.isBlank((CharSequence)elementPattern) || !NumberUtil.isNumber((CharSequence)elementPattern)) {
                throw new BaseException("\u6d41\u6c34\u53f7\u9012\u589e\u503c\u683c\u5f0f\u9519\u8bef!");
            }
            String key = ruleCode + "ruleCodeSet";
            SerialNumberGenerateValueServiceImpl.resetPeriod(sysCodeRuleInfo, key);
            Integer serialNumberLength = sysCodeRuleInfo.getSerialNumberLength();
            if (serialNumberLength == null) {
                throw new BaseException("\u6d41\u6c34\u53f7\u957f\u5ea6\u683c\u5f0f\u9519\u8bef!");
            }
            Long serialNumber = this.getSerialNumber(sysCodeRuleInfo, sysCodeRuleVo, serialNumberLength, elementPattern, key);
            sysCodeRuleInfo.setSerialNumberCode(serialNumber);
            List sysCodeRuleInfoList = sysCodeRuleVo.getSysCodeRuleInfoList();
            sysCodeRuleVo.setSysCodeRuleInfoList(sysCodeRuleInfoList);
            HussarCacheUtil.put((String)"codePlusCacheName", (Object)key, (Object)sysCodeRuleVo);
            String string = String.format("%0" + serialNumberLength + "d", serialNumber);
            return string;
        }
        finally {
            if (lockGuard != null) {
                lockGuard.releaseLock();
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        GenerateValueFactory.add((String)"serialNumber", (IGenerateValueService)this);
    }

    @Nullable
    private Long getSerialNumber(SysCodeRuleInfo sysCodeRuleInfo, SysCodeRuleVo sysCodeRuleVo, Integer serialNumberLength, String elementPattern, String key) {
        Long codeRuleInfoId = sysCodeRuleInfo.getId();
        for (int i = 0; i < MAX_RETRY_COUNT; ++i) {
            if (i > 0) {
                sysCodeRuleInfo = (SysCodeRuleInfo)this.sysCodeRuleInfoService.getById((Serializable)codeRuleInfoId);
            }
            Long serialNumber = SerialNumberGenerateValueServiceImpl.generateSerialNumber(sysCodeRuleInfo, serialNumberLength, elementPattern);
            Long version = this.getVersion(sysCodeRuleInfo);
            SysCodeRuleInfo temp = new SysCodeRuleInfo();
            temp.setId(codeRuleInfoId);
            temp.setSerialNumberCode(serialNumber);
            temp.setInfoVersion(version);
            boolean flag = this.sysCodeRuleInfoService.updateByIdAndVersion(temp);
            if (!flag) continue;
            SerialNumberGenerateValueServiceImpl.overwriteCache(sysCodeRuleInfo, sysCodeRuleVo, serialNumber, version, key);
            return serialNumber;
        }
        throw new BaseException("\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
    }

    private Long getVersion(SysCodeRuleInfo sysCodeRuleInfo) {
        Long version = sysCodeRuleInfo.getInfoVersion();
        if (HussarUtils.isEmpty((Object)version)) {
            SysCodeRuleInfo codeRuleInfo = (SysCodeRuleInfo)this.sysCodeRuleInfoService.getById((Serializable)sysCodeRuleInfo.getId());
            version = HussarUtils.isNotEmpty((Object)codeRuleInfo) && HussarUtils.isNotEmpty((Object)codeRuleInfo.getInfoVersion()) ? codeRuleInfo.getInfoVersion() : Long.valueOf(1L);
        }
        return version;
    }

    private static void overwriteCache(SysCodeRuleInfo sysCodeRuleInfo, SysCodeRuleVo sysCodeRuleVo, Long serialNumber, Long version, String key) {
        if (HussarUtils.isNotEmpty((Object)sysCodeRuleInfo.getEnableCache()) && !HussarUtils.equals((Object)sysCodeRuleInfo.getEnableCache(), (Object)ENABLE_CACHE)) {
            return;
        }
        sysCodeRuleInfo.setSerialNumberCode(serialNumber);
        sysCodeRuleInfo.setInfoVersion(Long.valueOf(version + 1L));
        List sysCodeRuleInfoList = sysCodeRuleVo.getSysCodeRuleInfoList();
        sysCodeRuleVo.setSysCodeRuleInfoList(sysCodeRuleInfoList);
        try {
            HussarCacheUtil.put((String)"codePlusCacheName", (Object)key, (Object)sysCodeRuleVo);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6d41\u6c34\u53f7\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            throw new BaseException("\u66f4\u65b0\u6d41\u6c34\u53f7\u7f13\u5b58\u5f02\u5e38");
        }
    }

    private static Long generateSerialNumber(SysCodeRuleInfo sysCodeRuleInfo, Integer serialNumberLength, String elementPattern) {
        int zeroLength;
        Long serialNumberStart = sysCodeRuleInfo.getSerialNumberStart();
        if (serialNumberStart == null) {
            serialNumberStart = 1L;
        }
        Long serialNumberCode = sysCodeRuleInfo.getSerialNumberCode();
        Long serialNumber = 0L;
        double maxValue = Math.pow(10.0, serialNumberLength.intValue()) - 1.0;
        if (serialNumberCode != null) {
            if ((double)(serialNumberCode + Long.parseLong(elementPattern)) <= maxValue) {
                serialNumber = serialNumberCode + Long.parseLong(elementPattern);
            }
        } else {
            serialNumber = serialNumberStart;
        }
        if ((zeroLength = serialNumberLength - String.valueOf(serialNumber).length()) < 0) {
            throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6!");
        }
        return serialNumber;
    }

    private static void resetPeriod(SysCodeRuleInfo sysCodeRuleInfo, String key) {
        String nowPeriod = sysCodeRuleInfo.getNowPeriod();
        String resetPeriod = sysCodeRuleInfo.getResetPeriod();
        if (HussarUtils.isNotEmpty((Object)resetPeriod) && !"1".equals(resetPeriod)) {
            String newPeriod = StrategyFactory.get((String)resetPeriod).getNewPeriod();
            if (StringUtils.isEmpty((CharSequence)nowPeriod) || !nowPeriod.equals(newPeriod)) {
                sysCodeRuleInfo.setNowPeriod(newPeriod);
                sysCodeRuleInfo.setSerialNumberCode(null);
                HussarCacheUtil.evict((String)"codePlusCacheName", (Object)key);
            }
        }
    }

    private String generateLockKey(String ruleCode) {
        TenantDetails tenant = HussarTenantContextHolder.getTenant();
        String tenantCode = tenant != null && StringUtils.isNotBlank((CharSequence)tenant.getTenantCode()) ? tenant.getTenantCode() : "0";
        return "ruleCodeLock" + ruleCode + ":" + tenantCode;
    }

    private HussarLockGuard acquireLock(String lockKey) {
        for (int i = 0; i < 5; ++i) {
            HussarLockGuard lockGuard = this.lockManager.acquire(HussarLockType.REENTRANT_LOCK, HussarLockExecutionStrategy.UNLIMITED, lockKey, Duration.ofMillis(100L));
            if (HussarUtils.isNotEmpty((Object)lockGuard)) {
                return lockGuard;
            }
            try {
                Thread.sleep(50L * (long)(i + 1));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new HussarException("\u83b7\u53d6\u9501\u8fc7\u7a0b\u4e2d\u7ebf\u7a0b\u88ab\u4e2d\u65ad");
            }
        }
        throw new HussarException("\u52a0\u9501\u5931\u8d25\uff0c\u5df2\u6709\u7a0b\u5e8f\u5728\u4f7f\u7528\u672c\u63a5\u53e3\uff01");
    }
}

