/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.service.impl;

import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.code.plus.dao.SysCodeRuleIsLevelMapper;
import com.jxdinfo.hussar.code.plus.dao.SysCodeRuleMapper;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleIsLevel;
import com.jxdinfo.hussar.code.plus.service.ICreateElementCodeService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleInfoService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.code.plus.utils.DistributionLock;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.code.plus.service.impl.SysCodeRuleRefServiceImpl")
public class SysCodeRuleRefServiceImpl
implements ISysCodeRuleRefService {
    private final Logger logger = LoggerFactory.getLogger(SysCodeRuleRefServiceImpl.class);
    @Resource
    private SysCodeRuleMapper sysCodeRuleMapper;
    @Resource
    private SysCodeRuleIsLevelMapper sysCodeRuleIsLevelMapper;
    @Autowired
    private ICreateElementCodeService createElementCodeService;
    @Autowired
    private ISysCodeRuleInfoService sysCodeRuleInfoService;
    @Autowired
    private ISysBaseConfigService sysBaseConfigService;

    public String getCurrentCode(CodePlusDto codePlusDto) {
        return this.getCurrentCode(codePlusDto, true);
    }

    public String getCurrentCodeByCache(CodePlusDto codePlusDto) {
        return this.getCurrentCode(codePlusDto, false);
    }

    private synchronized String getCurrentCode(CodePlusDto codePlusDto, Boolean updateDb) {
        String codePlus;
        String ruleCode = codePlusDto.getRuleCode();
        AssertUtil.isNotEmpty((String)ruleCode, (String)"\u89c4\u5219Code\u4e3a\u7a7a\uff01");
        Map variableMap = codePlusDto.getVariableMap();
        DistributionLock distributionLock = new DistributionLock(ruleCode);
        distributionLock.lock();
        String ruleCodeCacheKey = ruleCode + "ruleCodeSet";
        SysCodeRuleVo sysCodeRuleVo = (SysCodeRuleVo)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
        if (sysCodeRuleVo == null) {
            try {
                this.getCodeRuleByRuleCode(ruleCode);
            }
            catch (Exception e) {
                distributionLock.release();
                throw new BaseException(e.getMessage());
            }
            sysCodeRuleVo = (SysCodeRuleVo)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
        }
        try {
            codePlus = updateDb.booleanValue() ? this.createElementCodeService.createElementCode(ruleCode, sysCodeRuleVo, variableMap) : this.createElementCodeService.createElementCodeByCache(ruleCode, sysCodeRuleVo, variableMap);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        finally {
            distributionLock.release();
        }
        return codePlus;
    }

    public String getCurrentCodeByParentNumber(String ruleCode, String parentNumber) {
        return this.getCurrentCodeByParentNumber(ruleCode, parentNumber, true);
    }

    public String getCurrentCodeByParentNumberCache(String ruleCode, String parentNumber) {
        return this.getCurrentCodeByParentNumber(ruleCode, parentNumber, false);
    }

    private synchronized String getCurrentCodeByParentNumber(String ruleCode, String parentNumber, Boolean updateDb) {
        SysCodeRuleIsLevel sysCodeRuleIsLevel;
        StringBuilder currentCode = new StringBuilder();
        DistributionLock distributionLock = new DistributionLock(ruleCode);
        distributionLock.lock();
        String ruleCodeCacheKey = ruleCode + "ruleCodeSet";
        String codeRuleIsLevelKey = ruleCodeCacheKey + "isLevel" + parentNumber;
        SysCodeRuleVo sysCodeRuleVo = (SysCodeRuleVo)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
        if (sysCodeRuleVo == null) {
            try {
                this.getCodeRuleByRuleCode(ruleCode);
            }
            catch (Exception e) {
                distributionLock.release();
                throw new BaseException(e.getMessage());
            }
            sysCodeRuleVo = (SysCodeRuleVo)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
        }
        List sysCodeRuleInfoList = sysCodeRuleVo.getSysCodeRuleInfoList();
        String isLevel = sysCodeRuleVo.getLevel();
        if (StringUtils.isBlank((CharSequence)isLevel) || !"1".equals(isLevel)) {
            distributionLock.release();
            throw new BaseException("\u7f16\u7801\u89c4\u5219\u4e0d\u662f\u5c42\u7ea7\u7801!");
        }
        boolean isContain = HussarCacheUtil.containKey((String)"codePlusCacheName", (Object)codeRuleIsLevelKey);
        if (!isContain) {
            sysCodeRuleIsLevel = new SysCodeRuleIsLevel();
            sysCodeRuleIsLevel.setId(null);
            sysCodeRuleIsLevel.setIdValue("0");
            sysCodeRuleIsLevel.setIdtableId(Long.valueOf(Long.parseLong(this.sysCodeRuleMapper.getRuleCodeId(ruleCode))));
            sysCodeRuleIsLevel.setParentNumber(parentNumber);
            this.sysCodeRuleIsLevelMapper.insert(sysCodeRuleIsLevel);
            HussarCacheUtil.putIfAbsent((String)"codePlusCacheName", (Object)codeRuleIsLevelKey, (Object)sysCodeRuleIsLevel);
            String ruleCodeIsLevelCacheKey = ruleCode + "isLevelRuleCodeSet";
            List<String> ruleCodeSetIsLevelList = HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeIsLevelCacheKey) == null ? new ArrayList() : (List)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeIsLevelCacheKey);
            ruleCodeSetIsLevelList.add(String.valueOf(codeRuleIsLevelKey));
            HussarCacheUtil.put((String)"codePlusCacheName", (Object)ruleCodeIsLevelCacheKey, ruleCodeSetIsLevelList);
        }
        sysCodeRuleIsLevel = (SysCodeRuleIsLevel)HussarCacheUtil.get((String)"codePlusCacheName", (Object)codeRuleIsLevelKey);
        String elementPatternSerialNumber = ((SysCodeRuleInfo)sysCodeRuleInfoList.get(0)).getElementPattern();
        Integer serialNumberLengthSerialNumber = ((SysCodeRuleInfo)sysCodeRuleInfoList.get(0)).getSerialNumberLength();
        String elementPatternParentNumber = sysCodeRuleIsLevel.getIdValue();
        int result = Integer.parseInt(elementPatternParentNumber) + Integer.parseInt(elementPatternSerialNumber);
        String resultCode = String.valueOf(result);
        int zeroLength = serialNumberLengthSerialNumber - resultCode.length();
        if (zeroLength < 0) {
            distributionLock.release();
            throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6!");
        }
        if (ToolUtil.isNotEmpty((Object)parentNumber)) {
            currentCode.append(parentNumber);
        }
        for (int i = 0; i < zeroLength; ++i) {
            currentCode.append("0");
        }
        currentCode.append(result);
        sysCodeRuleIsLevel.setIdValue(String.valueOf(result));
        HussarCacheUtil.put((String)"codePlusCacheName", (Object)codeRuleIsLevelKey, (Object)sysCodeRuleIsLevel);
        if (this.sysBaseConfigService.isNotRedis() && updateDb.booleanValue()) {
            this.sysCodeRuleIsLevelMapper.updateById(sysCodeRuleIsLevel);
        }
        distributionLock.release();
        return currentCode.toString();
    }

    public void getCodeRuleByRuleCode(String ruleCode) {
        List<String> ruleCodeSetList;
        SysCodeRuleVo sysCodeRuleVo = this.sysCodeRuleMapper.getCodeRule(ruleCode);
        if (HussarUtils.isEmpty((Object)sysCodeRuleVo)) {
            throw new BaseException("\u672a\u627e\u5230\u7f16\u7801\u89c4\u5219");
        }
        String codeRuleCode = sysCodeRuleVo.getCodeRuleCode();
        String ruleCodeCacheKey = codeRuleCode + "ruleCodeSet";
        List list = ruleCodeSetList = HussarCacheUtil.get((String)"codePlusCacheName", (Object)"ruleCodeSet") == null ? new ArrayList() : (List)HussarCacheUtil.get((String)"codePlusCacheName", (Object)"ruleCodeSet");
        if (!ruleCodeSetList.contains(codeRuleCode)) {
            ruleCodeSetList.add(codeRuleCode);
        }
        HussarCacheUtil.put((String)"codePlusCacheName", (Object)"ruleCodeSet", ruleCodeSetList);
        Object codeRuleValueResponse = HussarCacheUtil.putIfAbsent((String)"codePlusCacheName", (Object)ruleCodeCacheKey, (Object)sysCodeRuleVo);
        if (!sysCodeRuleVo.equals(codeRuleValueResponse)) {
            throw new BaseException(ruleCode + "\u89c4\u5219\u5b58\u5165\u7f13\u5b58\u5931\u8d25\uff01");
        }
        String isLevel = sysCodeRuleVo.getLevel();
        if (!StringUtils.isEmpty((CharSequence)isLevel) && "1".equals(isLevel)) {
            List<SysCodeRuleIsLevel> idTableByParentNumberList = this.sysCodeRuleMapper.getIdTableByParentNumber(ruleCode, "");
            for (SysCodeRuleIsLevel idTableByParentNumber : idTableByParentNumberList) {
                List<String> ruleCodeSetIsLevelList;
                String parentNumber = idTableByParentNumber.getParentNumber();
                String codeRuleIsLevelKey = ruleCodeCacheKey + "isLevel" + parentNumber;
                String ruleCodeIsLevelCacheKey = ruleCode + "isLevelRuleCodeSet";
                List list2 = ruleCodeSetIsLevelList = HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeIsLevelCacheKey) == null ? new ArrayList() : (List)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeIsLevelCacheKey);
                if (!ruleCodeSetIsLevelList.contains(String.valueOf(codeRuleIsLevelKey))) {
                    ruleCodeSetIsLevelList.add(String.valueOf(codeRuleIsLevelKey));
                }
                HussarCacheUtil.put((String)"codePlusCacheName", (Object)ruleCodeIsLevelCacheKey, ruleCodeSetIsLevelList);
                SysCodeRuleIsLevel sysCodeRuleIsLevel = (SysCodeRuleIsLevel)HussarCacheUtil.putIfAbsent((String)"codePlusCacheName", (Object)codeRuleIsLevelKey, (Object)idTableByParentNumber);
                if (idTableByParentNumber.equals(sysCodeRuleIsLevel)) continue;
                throw new BaseException(codeRuleIsLevelKey + "\u5c42\u7ea7\u89c4\u5219\u5b58\u5165\u7f13\u5b58\u5931\u8d25\uff01");
            }
        }
    }

    public void updateScheduled() {
        this.updateScheduled("master");
    }

    @HussarDs(value="#connName")
    public void updateScheduled(String connName) {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1(\u5c06\u7f16\u7801\u89c4\u5219\u7f13\u5b58\u66f4\u65b0\u5230\u6570\u636e\u5e93)");
        ArrayList ruleCodeSetList = (ArrayList)HussarCacheUtil.get((String)"codePlusCacheName", (Object)"ruleCodeSet");
        if (HussarUtils.isEmpty((Object)ruleCodeSetList)) {
            return;
        }
        ArrayList<Map<String, Object>> listMapIsLevel = new ArrayList<Map<String, Object>>();
        ArrayList<SysCodeRuleInfo> updateList = new ArrayList<SysCodeRuleInfo>();
        ruleCodeSetList = new ArrayList(new HashSet(ruleCodeSetList));
        for (String ruleCode : ruleCodeSetList) {
            String ruleCodeIsLevelCacheKey;
            ArrayList ruleCodeSetIsLevelList;
            String ruleCodeCacheKey = (ruleCode = ruleCode.replace("codePlusCacheName::", "").replace("ruleCodeSet", "")) + "ruleCodeSet";
            SysCodeRuleVo sysCodeRuleVo = (SysCodeRuleVo)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
            if (HussarUtils.isEmpty((Object)sysCodeRuleVo)) {
                HussarCacheUtil.evict((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
                continue;
            }
            List sysCodeRuleInfoList = sysCodeRuleVo.getSysCodeRuleInfoList();
            String isLevel = sysCodeRuleVo.getLevel();
            if (HussarUtils.isEmpty((Object)sysCodeRuleInfoList)) continue;
            for (SysCodeRuleInfo sysCodeRuleInfo : sysCodeRuleInfoList) {
                String elementType = sysCodeRuleInfo.getElementType();
                if (!"serialNumber".equals(elementType)) continue;
                SysCodeRuleInfo temp = new SysCodeRuleInfo();
                BeanUtils.copyProperties((Object)sysCodeRuleInfo, (Object)temp);
                updateList.add(temp);
            }
            if (!StringUtils.isNotBlank((CharSequence)isLevel) || !"1".equals(isLevel) || !HussarUtils.isNotEmpty((Object)(ruleCodeSetIsLevelList = (ArrayList)HussarCacheUtil.get((String)"codePlusCacheName", (Object)(ruleCodeIsLevelCacheKey = ruleCode + "isLevelRuleCodeSet"))))) continue;
            ruleCodeSetIsLevelList = new ArrayList(new HashSet(ruleCodeSetIsLevelList));
            for (String ruleCodeIsLevel : ruleCodeSetIsLevelList) {
                SysCodeRuleIsLevel sysCodeRuleIsLevel = (SysCodeRuleIsLevel)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeIsLevel);
                Long ruleCodeId = Long.parseLong(this.sysCodeRuleMapper.getRuleCodeId(ruleCode));
                String parentNumber = sysCodeRuleIsLevel.getParentNumber();
                String idValue = sysCodeRuleIsLevel.getIdValue();
                HashMap<String, Object> mapIsLevel = new HashMap<String, Object>();
                mapIsLevel.put("ruleCodeId", ruleCodeId);
                mapIsLevel.put("parentNumber", parentNumber);
                mapIsLevel.put("idValue", idValue);
                listMapIsLevel.add(mapIsLevel);
            }
        }
        if (HussarUtils.isNotEmpty(listMapIsLevel)) {
            this.sysCodeRuleMapper.updateCodeRuleIsLevelByParentNumber(listMapIsLevel);
        }
        if (HussarUtils.isNotEmpty(updateList)) {
            this.sysCodeRuleInfoService.updateBatchById(connName, updateList);
        }
    }

    public void updateCacheToDb(CodePlusDto codePlusDto) {
        block5: {
            SysCodeRuleVo sysCodeRuleVo;
            String ruleCode;
            block4: {
                ruleCode = codePlusDto.getRuleCode();
                AssertUtil.isNotEmpty((String)ruleCode, (String)"\u89c4\u5219Code\u4e3a\u7a7a\uff01");
                String ruleCodeCacheKey = ruleCode + "ruleCodeSet";
                sysCodeRuleVo = (SysCodeRuleVo)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
                if (sysCodeRuleVo == null) {
                    return;
                }
                String level = codePlusDto.getLevel();
                if (HussarUtils.isBlank((CharSequence)level)) {
                    level = "0";
                }
                if (!level.equalsIgnoreCase("1")) break block4;
                String parentNumber = codePlusDto.getParentNumber();
                String codeRuleIsLevelKey = ruleCodeCacheKey + "isLevel" + parentNumber;
                String isLevel = sysCodeRuleVo.getLevel();
                if (StringUtils.isBlank((CharSequence)isLevel) || !"1".equals(isLevel)) {
                    throw new BaseException("\u7f16\u7801\u89c4\u5219\u4e0d\u662f\u5c42\u7ea7\u7801!");
                }
                boolean isContain = HussarCacheUtil.containKey((String)"codePlusCacheName", (Object)codeRuleIsLevelKey);
                if (!isContain) break block5;
                SysCodeRuleIsLevel sysCodeRuleIsLevel = (SysCodeRuleIsLevel)HussarCacheUtil.get((String)"codePlusCacheName", (Object)codeRuleIsLevelKey);
                this.sysCodeRuleIsLevelMapper.updateById(sysCodeRuleIsLevel);
                break block5;
            }
            List sysCodeRuleInfoList = sysCodeRuleVo.getSysCodeRuleInfoList();
            for (SysCodeRuleInfo sysCodeRuleInfo : sysCodeRuleInfoList) {
                String elementType = sysCodeRuleInfo.getElementType();
                if (!HussarUtils.equals((Object)elementType, (Object)"serialNumber")) continue;
                SysCodeRuleInfo temp = new SysCodeRuleInfo();
                BeanUtils.copyProperties((Object)sysCodeRuleInfo, (Object)temp);
                Long ruleCodeId = Long.parseLong(this.sysCodeRuleMapper.getRuleCodeId(ruleCode));
                temp.setCodeRuleId(ruleCodeId);
                this.sysCodeRuleInfoService.updateById((Object)temp);
                break;
            }
        }
    }

    public void deleteCache(String ruleCode) {
        String ruleCodeCacheKey = ruleCode + "ruleCodeSet";
        String ruleCodeIsLevelCacheKey = ruleCode + "isLevelRuleCodeSet";
        DistributionLock distributionLock = new DistributionLock(ruleCode);
        distributionLock.lock();
        List ruleCodeSetList = (List)HussarCacheUtil.get((String)"codePlusCacheName", (Object)"ruleCodeSet");
        for (int i = 0; i < ruleCodeSetList.size(); ++i) {
            if (!ruleCode.equals(ruleCodeSetList.get(i))) continue;
            ruleCodeSetList.remove(i);
            if (!ruleCodeSetList.isEmpty()) {
                HussarCacheUtil.put((String)"codePlusCacheName", (Object)"ruleCodeSet", (Object)ruleCodeSetList);
                break;
            }
            HussarCacheUtil.evict((String)"codePlusCacheName", (Object)"ruleCodeSet");
            break;
        }
        HussarCacheUtil.evict((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
        List ruleCodeSetIsLevelList = (List)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeIsLevelCacheKey);
        if (ruleCodeSetIsLevelList != null && !ruleCodeSetIsLevelList.isEmpty()) {
            for (String ruleCodeIsLevel : ruleCodeSetIsLevelList) {
                HussarCacheUtil.evict((String)"codePlusCacheName", (Object)ruleCodeIsLevel);
            }
            HussarCacheUtil.evict((String)"codePlusCacheName", (Object)ruleCodeIsLevelCacheKey);
        }
        distributionLock.release();
    }

    public int updateBeforeRuleChanged(String ruleCode) {
        String ruleCodeCacheKey = ruleCode + "ruleCodeSet";
        SysCodeRuleVo sysCodeRuleVo = (SysCodeRuleVo)HussarCacheUtil.get((String)"codePlusCacheName", (Object)ruleCodeCacheKey);
        if (HussarUtils.isEmpty((Object)sysCodeRuleVo)) {
            return 204;
        }
        this.updateScheduled();
        this.deleteCache(ruleCode);
        return 200;
    }
}

