/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.service.impl;

import com.jxdinfo.hussar.code.plus.dao.SysCodeRuleMapper;
import com.jxdinfo.hussar.code.plus.factory.GenerateValueFactory;
import com.jxdinfo.hussar.code.plus.model.SysCodeRule;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.service.ICreateElementCodeService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.code.plus.service.impl.createElementCodeServiceImpl")
public class CreateElementCodeServiceImpl
implements ICreateElementCodeService {
    @Resource
    private SysCodeRuleMapper sysCodeRuleMapper;

    public String createElementCode(String ruleCode, SysCodeRuleVo sysCodeRuleVo, Map<String, Object> variableMap) {
        StringBuilder currentCode = new StringBuilder();
        List sysCodeRuleInfoList = sysCodeRuleVo.getSysCodeRuleInfoList();
        ArrayList<Long> sysCodeRuleInfoCodeRoleIds = new ArrayList<Long>();
        for (SysCodeRuleInfo sysCodeRuleInfo : sysCodeRuleInfoList) {
            sysCodeRuleInfoCodeRoleIds.add(sysCodeRuleInfo.getCodeRuleId());
        }
        List sysCodeRules = this.sysCodeRuleMapper.selectBatchIds(sysCodeRuleInfoCodeRoleIds);
        for (int i = 0; i < sysCodeRuleInfoList.size(); ++i) {
            SysCodeRuleInfo sysCodeRuleInfo = (SysCodeRuleInfo)sysCodeRuleInfoList.get(i);
            String elementType = sysCodeRuleInfo.getElementType();
            Optional<SysCodeRule> osysCodeRule = sysCodeRules.stream().filter(sysCodeRule -> Objects.equals(sysCodeRule.getId(), sysCodeRuleInfo.getCodeRuleId())).findFirst();
            currentCode.append(GenerateValueFactory.get((String)elementType).parse(sysCodeRuleInfo, osysCodeRule.get(), ruleCode, sysCodeRuleVo, variableMap));
        }
        return currentCode.toString();
    }

    public String createElementCodeByCache(String ruleCode, SysCodeRuleVo sysCodeRuleVo, Map<String, Object> variableMap) {
        StringBuilder currentCode = new StringBuilder();
        List sysCodeRuleInfoList = sysCodeRuleVo.getSysCodeRuleInfoList();
        ArrayList<Long> sysCodeRuleInfoCodeRoleIds = new ArrayList<Long>();
        for (SysCodeRuleInfo sysCodeRuleInfo : sysCodeRuleInfoList) {
            sysCodeRuleInfoCodeRoleIds.add(sysCodeRuleInfo.getCodeRuleId());
        }
        List sysCodeRules = this.sysCodeRuleMapper.selectBatchIds(sysCodeRuleInfoCodeRoleIds);
        for (SysCodeRuleInfo sysCodeRuleInfo : sysCodeRuleInfoList) {
            String elementType = sysCodeRuleInfo.getElementType();
            if (HussarUtils.equals((Object)elementType, (Object)"serialNumber")) {
                currentCode.append(GenerateValueFactory.get((String)elementType).parseByCache(sysCodeRuleInfo, ruleCode, sysCodeRuleVo, variableMap));
                continue;
            }
            Optional<SysCodeRule> osysCodeRule = sysCodeRules.stream().filter(sysCodeRule -> Objects.equals(sysCodeRule.getId(), sysCodeRuleInfo.getCodeRuleId())).findFirst();
            currentCode.append(GenerateValueFactory.get((String)elementType).parse(sysCodeRuleInfo, osysCodeRule.get(), ruleCode, sysCodeRuleVo, variableMap));
        }
        return currentCode.toString();
    }
}

