/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeSaveDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeUpdateDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarBase/code/plus/rule"})
@Api(tags={"\u7f16\u7801\u89c4\u5219\u7ba1\u7406"})
public class HussarBaseCodeRuleController {
    @Autowired
    private ISysCodeRuleService sysCodeRuleService;
    @Autowired
    private ISysCodeRuleRefService sysCodeRuleRefService;

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u7f16\u7801\u89c4\u5219", notes="\u6839\u636eID\u67e5\u8be2\u7f16\u7801\u89c4\u5219")
    @AuditLog(moduleName="\u7f16\u7801\u89c4\u5219\u7ba1\u7406", eventDesc="\u6839\u636eID\u67e5\u8be2\u7f16\u7801\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getCodeRule"})
    public ApiResponse<SysCodeRuleVo> getCodeRule(@ApiParam(value="\u7f16\u7801\u89c4\u5219ID") @RequestParam Long codeRuleId) {
        return this.sysCodeRuleService.getCodeRule(codeRuleId);
    }

    @ApiOperation(value="\u67e5\u8be2\u7f16\u7801\u89c4\u5219", notes="\u67e5\u8be2\u7f16\u7801\u89c4\u5219")
    @AuditLog(moduleName="\u7f16\u7801\u89c4\u5219\u7ba1\u7406", eventDesc="\u67e5\u8be2\u7f16\u7801\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/listCodeRules"})
    public ApiResponse<Page<SysCodeRuleVo>> listCodeRules(@ApiParam(value="\u7f16\u7801\u89c4\u5219\u67e5\u8be2DTO") SysCodeRuleDto sysCodeRuleDto) {
        this.sysCodeRuleRefService.updateScheduled();
        return this.sysCodeRuleService.listCodeRules(sysCodeRuleDto);
    }

    @ApiOperation(value="\u65b0\u589e\u7f16\u7801\u89c4\u5219", notes="\u65b0\u589e\u7f16\u7801\u89c4\u5219")
    @AuditLog(moduleName="\u7f16\u7801\u89c4\u5219\u7ba1\u7406", eventDesc="\u65b0\u589e\u7f16\u7801\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/saveCodeRule"})
    public ApiResponse<String> saveCodeRule(@ApiParam(value="\u65b0\u589e\u7f16\u7801\u89c4\u5219DTO") @RequestBody SysCodeSaveDto sysCodeDto) {
        return this.sysCodeRuleService.saveCodeRule(sysCodeDto);
    }

    @ApiOperation(value="\u4fee\u6539\u7f16\u7801\u89c4\u5219", notes="\u4fee\u6539\u7f16\u7801\u89c4\u5219")
    @AuditLog(moduleName="\u7f16\u7801\u89c4\u5219\u7ba1\u7406", eventDesc="\u4fee\u6539\u7f16\u7801\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/updateCodeRule"})
    public ApiResponse<String> updateCodeRule(@ApiParam(value="\u4fee\u6539\u7f16\u7801DTO") @RequestBody SysCodeUpdateDto sysCodeUpdateDto) {
        return this.sysCodeRuleService.updateCodeRule(sysCodeUpdateDto);
    }

    @ApiOperation(value="\u5220\u9664\u7f16\u7801\u89c4\u5219", notes="\u5220\u9664\u7f16\u7801\u89c4\u5219")
    @AuditLog(moduleName="\u7f16\u7801\u89c4\u5219\u7ba1\u7406", eventDesc="\u5220\u9664\u7f16\u7801\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @PostMapping(value={"/deleteCodeRule"})
    public ApiResponse<String> deleteCodeRule(@ApiParam(value="\u7f16\u7801\u89c4\u5219ID\u96c6\u5408") @RequestBody List<Long> codeRuleIds) {
        return this.sysCodeRuleService.deleteCodeRule(codeRuleIds);
    }

    @ApiOperation(value="\u65e7\u7f16\u7801\u89c4\u5219\u8fc1\u79fb\u65b0\u7248\u7f16\u7801\u89c4\u5219", notes="\u65e7\u7f16\u7801\u89c4\u5219\u8fc1\u79fb\u65b0\u7248\u7f16\u7801\u89c4\u5219")
    @AuditLog(moduleName="\u7f16\u7801\u89c4\u5219\u7ba1\u7406", eventDesc="\u65e7\u7f16\u7801\u89c4\u5219\u8fc1\u79fb\u65b0\u7248\u7f16\u7801\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/saveOldToNew"})
    public ApiResponse<String> saveOldToNew() {
        return this.sysCodeRuleService.saveOldToNew();
    }

    @ApiOperation(value="\u91cd\u7f6e\u6d41\u6c34\u53f7", notes="\u91cd\u7f6e\u6d41\u6c34\u53f7")
    @AuditLog(moduleName="\u7f16\u7801\u89c4\u5219\u7ba1\u7406", eventDesc="\u91cd\u7f6e\u6d41\u6c34\u53f7", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/resetSerialNumber"})
    public ApiResponse<String> resetSerialNumber(@ApiParam(value="\u7f16\u7801\u6807\u8bc6") @RequestBody String ruleCode) {
        return this.sysCodeRuleService.resetSerialNumber(ruleCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7f16\u7801", notes="\u83b7\u53d6\u5f53\u524d\u7f16\u7801")
    @AuditLog(moduleName="\u7f16\u7801\u89c4\u5219\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u7f16\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getCurrentCode"})
    public ApiResponse<String> getCurrentCode(@ApiParam(value="\u7f16\u7801\u751f\u6210DTO") CodePlusDto codePlusDto) {
        String result = this.sysCodeRuleService.getCurrentCode(codePlusDto);
        return ApiResponse.success((Object)result, (String)"\u83b7\u53d6\u5f53\u524d\u7f16\u7801\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u83b7\u53d6\u7f16\u7801", notes="\u6279\u91cf\u83b7\u53d6\u7f16\u7801")
    @AuditLog(moduleName="\u7f16\u7801\u89c4\u5219\u7ba1\u7406", eventDesc="\u6279\u91cf\u83b7\u53d6\u7f16\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getBatchCurrentCodes"})
    public ApiResponse<List<String>> getBatchCurrentCodes(@ApiParam(value="\u6279\u91cf\u7f16\u7801\u751f\u6210DTO\u96c6\u5408") List<CodePlusDto> codePlusDtoList) {
        List result = this.sysCodeRuleService.getBatchCurrentCodes(codePlusDtoList);
        return ApiResponse.success((Object)result, (String)"\u6279\u91cf\u83b7\u53d6\u5f53\u524d\u7f16\u7801\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u6c34\u53f7\u89c4\u5219\u5f53\u524d\u7f16\u7801", notes="\u83b7\u53d6\u6d41\u6c34\u53f7\u89c4\u5219\u5f53\u524d\u7f16\u7801")
    @AuditLog(moduleName="\u7f16\u7801\u89c4\u5219\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6d41\u6c34\u53f7\u89c4\u5219\u5f53\u524d\u7f16\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getSerialNumberCode"})
    public ApiResponse<Long> getSerialNumberCode(@ApiParam(value="\u7f16\u7801\u6807\u8bc6") @RequestParam(value="ruleCode") String ruleCode) {
        return this.sysCodeRuleService.getSerialNumberCode(ruleCode);
    }
}

