/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.service.impl;

import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.code.plus.dao.SysCodeRuleMapper;
import com.jxdinfo.hussar.code.plus.factory.GenerateValueFactory;
import com.jxdinfo.hussar.code.plus.factory.StrategyFactory;
import com.jxdinfo.hussar.code.plus.model.SysCodeRule;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.service.IGenerateValueService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleInfoService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.NumberUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.code.plus.service.impl.serialNumberGenerateValueServiceImpl")
public class SerialNumberGenerateValueServiceImpl
implements IGenerateValueService,
InitializingBean {
    @Resource
    private SysCodeRuleMapper sysCodeRuleMapper;
    @Autowired
    private ISysBaseConfigService sysBaseConfigService;

    public String parse(SysCodeRuleInfo sysCodeRuleInfo, String ruleCode, SysCodeRuleVo sysCodeRuleVo, Map<String, Object> variableMap) {
        int zeroLength;
        Integer serialNumberLength;
        String elementPattern = StringUtils.trimToEmpty((String)sysCodeRuleInfo.getElementPattern());
        if (StringUtils.isBlank((CharSequence)elementPattern) || !NumberUtil.isNumber((CharSequence)elementPattern)) {
            throw new BaseException("\u6d41\u6c34\u53f7\u9012\u589e\u503c\u683c\u5f0f\u9519\u8bef!");
        }
        String nowPeriod = sysCodeRuleInfo.getNowPeriod();
        String resetPeriod = sysCodeRuleInfo.getResetPeriod();
        Long serialNumberStart = sysCodeRuleInfo.getSerialNumberStart();
        if (serialNumberStart == null) {
            serialNumberStart = 1L;
        }
        SysCodeRule sysCodeRule = (SysCodeRule)this.sysCodeRuleMapper.selectById(sysCodeRuleInfo.getCodeRuleId());
        String key = sysCodeRule.getCodeRuleCode() + "ruleCodeSet";
        if (HussarUtils.isNotEmpty((Object)resetPeriod) && !"1".equals(resetPeriod)) {
            String newPeriod = StrategyFactory.get((String)resetPeriod).getNewPeriod();
            if (StringUtils.isEmpty((CharSequence)nowPeriod) || !nowPeriod.equals(newPeriod)) {
                sysCodeRuleInfo.setNowPeriod(newPeriod);
                sysCodeRuleInfo.setSerialNumberCode(null);
                HussarCacheUtil.evict((String)"codePlusCacheName", (Object)key);
            }
        }
        if ((serialNumberLength = sysCodeRuleInfo.getSerialNumberLength()) == null) {
            throw new BaseException("\u6d41\u6c34\u53f7\u957f\u5ea6\u683c\u5f0f\u9519\u8bef!");
        }
        Long serialNumberCode = sysCodeRuleInfo.getSerialNumberCode();
        Long serialNumber = 0L;
        Double maxValue = Math.pow(10.0, serialNumberLength.intValue()) - 1.0;
        if (serialNumberCode != null) {
            if ((double)(serialNumberCode + Long.parseLong(elementPattern)) <= maxValue) {
                serialNumber = serialNumberCode + Long.parseLong(elementPattern);
            }
        } else {
            serialNumber = serialNumberStart;
        }
        if ((zeroLength = serialNumberLength - String.valueOf(serialNumber).length()) < 0) {
            throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6!");
        }
        sysCodeRuleInfo.setSerialNumberCode(serialNumber);
        List sysCodeRuleInfoList = sysCodeRuleVo.getSysCodeRuleInfoList();
        sysCodeRuleVo.setSysCodeRuleInfoList(sysCodeRuleInfoList);
        HussarCacheUtil.put((String)"codePlusCacheName", (Object)key, (Object)sysCodeRuleVo);
        if (this.sysBaseConfigService.isNotRedis()) {
            SysCodeRuleInfo temp = new SysCodeRuleInfo();
            BeanUtils.copyProperties((Object)sysCodeRuleInfo, (Object)temp);
            Long ruleCodeId = Long.parseLong(this.sysCodeRuleMapper.getRuleCodeId(ruleCode));
            temp.setCodeRuleId(ruleCodeId);
            ((ISysCodeRuleInfoService)SpringContextHolder.getBean(ISysCodeRuleInfoService.class)).updateById((Object)temp);
        }
        return String.format("%0" + serialNumberLength + "d", serialNumber);
    }

    public String parseByCache(SysCodeRuleInfo sysCodeRuleInfo, String ruleCode, SysCodeRuleVo sysCodeRuleVo, Map<String, Object> variableMap) {
        int zeroLength;
        Integer serialNumberLength;
        String elementPattern = StringUtils.trimToEmpty((String)sysCodeRuleInfo.getElementPattern());
        if (StringUtils.isBlank((CharSequence)elementPattern) || !NumberUtil.isNumber((CharSequence)elementPattern)) {
            throw new BaseException("\u6d41\u6c34\u53f7\u9012\u589e\u503c\u683c\u5f0f\u9519\u8bef!");
        }
        String nowPeriod = sysCodeRuleInfo.getNowPeriod();
        String resetPeriod = sysCodeRuleInfo.getResetPeriod();
        Long serialNumberStart = sysCodeRuleInfo.getSerialNumberStart();
        if (serialNumberStart == null) {
            serialNumberStart = 1L;
        }
        String key = ruleCode + "ruleCodeSet";
        if (HussarUtils.isNotEmpty((Object)resetPeriod) && !"1".equals(resetPeriod)) {
            String newPeriod = StrategyFactory.get((String)resetPeriod).getNewPeriod();
            if (StringUtils.isEmpty((CharSequence)nowPeriod) || !nowPeriod.equals(newPeriod)) {
                sysCodeRuleInfo.setNowPeriod(newPeriod);
                sysCodeRuleInfo.setSerialNumberCode(null);
                HussarCacheUtil.evict((String)"codePlusCacheName", (Object)key);
            }
        }
        if ((serialNumberLength = sysCodeRuleInfo.getSerialNumberLength()) == null) {
            throw new BaseException("\u6d41\u6c34\u53f7\u957f\u5ea6\u683c\u5f0f\u9519\u8bef!");
        }
        Long serialNumberCode = sysCodeRuleInfo.getSerialNumberCode();
        Long serialNumber = 0L;
        Double maxValue = Math.pow(10.0, serialNumberLength.intValue()) - 1.0;
        if (serialNumberCode != null) {
            if ((double)(serialNumberCode + Long.parseLong(elementPattern)) <= maxValue) {
                serialNumber = serialNumberCode + Long.parseLong(elementPattern);
            }
        } else {
            serialNumber = serialNumberStart;
        }
        if ((zeroLength = serialNumberLength - String.valueOf(serialNumber).length()) < 0) {
            throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6!");
        }
        sysCodeRuleInfo.setSerialNumberCode(serialNumber);
        List sysCodeRuleInfoList = sysCodeRuleVo.getSysCodeRuleInfoList();
        sysCodeRuleVo.setSysCodeRuleInfoList(sysCodeRuleInfoList);
        HussarCacheUtil.put((String)"codePlusCacheName", (Object)key, (Object)sysCodeRuleVo);
        return String.format("%0" + serialNumberLength + "d", serialNumber);
    }

    public void afterPropertiesSet() throws Exception {
        GenerateValueFactory.add((String)"serialNumber", (IGenerateValueService)this);
    }
}

