/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.service.impl;

import com.jxdinfo.hussar.code.plus.factory.GenerateValueFactory;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.service.IGenerateValueService;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.NumberUtil;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.code.plus.service.impl.randomNumberGenerateValueServiceImpl")
public class RandomNumberGenerateValueServiceImpl
implements IGenerateValueService,
InitializingBean {
    public String parse(SysCodeRuleInfo sysCodeRuleInfo, String ruleCode, SysCodeRuleVo sysCodeRuleVo, Map<String, Object> variableMap) {
        String elementPattern = StringUtils.trimToEmpty((String)sysCodeRuleInfo.getElementPattern());
        if (!NumberUtil.isNumber((CharSequence)elementPattern)) {
            throw new BaseException("\u968f\u673a\u6570\u683c\u5f0f\u9519\u8bef\uff01");
        }
        String base = "0123456789";
        StringBuilder randomCodeBuilder = new StringBuilder();
        for (int j = 0; j < Integer.parseInt(elementPattern); ++j) {
            int number = RandomUtil.randomInt((int)base.length());
            randomCodeBuilder.append(base.charAt(number));
        }
        return randomCodeBuilder.toString();
    }

    public void afterPropertiesSet() throws Exception {
        GenerateValueFactory.add((String)"randomNumber", (IGenerateValueService)this);
    }
}

