/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.code.plus.dao.SysCodeRuleInfoMapper;
import com.jxdinfo.hussar.code.plus.dao.SysCodeRuleIsLevelMapper;
import com.jxdinfo.hussar.code.plus.dao.SysCodeRuleMapper;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleConfigDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeRuleDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeSaveDto;
import com.jxdinfo.hussar.code.plus.dto.SysCodeUpdateDto;
import com.jxdinfo.hussar.code.plus.model.SysCodeRule;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleInfo;
import com.jxdinfo.hussar.code.plus.model.SysCodeRuleIsLevel;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleInfoService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRulesIsLevel;
import com.jxdinfo.hussar.code.plus.vo.SysCodeRuleVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.model.SysIdtableInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.code.plus.service.impl.SysCodeRuleServiceImpl")
public class SysCodeRuleServiceImpl
extends HussarServiceImpl<SysCodeRuleMapper, SysCodeRule>
implements ISysCodeRuleService {
    private final Logger logger = LoggerFactory.getLogger(SysCodeRuleServiceImpl.class);
    @Resource
    private ISysCodeRuleService sysCodeRuleService;
    @Resource
    private ISysCodeRuleInfoService sysCodeRuleInfoService;
    @Resource
    private ISysCodeRulesIsLevel sysCodeRulesIsLevel;
    @Resource
    private SysCodeRuleMapper sysCodeRuleMapper;
    @Resource
    private SysCodeRuleInfoMapper sysCodeRuleInfoMapper;
    @Resource
    private SysCodeRuleIsLevelMapper sysCodeRuleIsLevelMapper;
    @Autowired
    private ISysCodeRuleRefService sysCodeRuleRefService;

    public ApiResponse<SysCodeRuleVo> getCodeRule(Long codeRuleId) {
        SysCodeRuleDto sysCodeRuleDto = new SysCodeRuleDto();
        sysCodeRuleDto.setRuleId(codeRuleId);
        SysCodeRuleVo sysCodeRuleVo = this.sysCodeRuleMapper.listCodeRules(sysCodeRuleDto);
        return ApiResponse.success((Object)sysCodeRuleVo);
    }

    public ApiResponse<Page<SysCodeRuleVo>> listCodeRules(SysCodeRuleDto sysCodeRuleDto) {
        String ruleCode = sysCodeRuleDto.getRuleCode();
        String codeRuleName = sysCodeRuleDto.getCodeRuleName();
        String codeRuleDesc = sysCodeRuleDto.getCodeRuleDesc();
        sysCodeRuleDto.setRuleCode(SqlQueryUtil.transferSpecialChar((String)ruleCode));
        sysCodeRuleDto.setCodeRuleName(SqlQueryUtil.transferSpecialChar((String)codeRuleName));
        sysCodeRuleDto.setCodeRuleDesc(SqlQueryUtil.transferSpecialChar((String)codeRuleDesc));
        sysCodeRuleDto.setEscapeSymbol("|");
        Page pager = new Page((long)sysCodeRuleDto.getPageNo().intValue(), (long)sysCodeRuleDto.getPageSize().intValue());
        List<SysCodeRuleVo> sysCodeRuleVoList = this.sysCodeRuleMapper.listCodeRules((Page<SysCodeRuleVo>)pager, sysCodeRuleDto);
        pager.setRecords(sysCodeRuleVoList);
        return ApiResponse.success((Object)pager);
    }

    @HussarTransactional
    public ApiResponse<String> saveCodeRule(SysCodeSaveDto sysCodeSaveDto) {
        String codeRuleId;
        SysCodeRule sysCodeRule = new SysCodeRule();
        if (HussarUtils.isNotEmpty((Object)sysCodeSaveDto.getCodeRuleCode()) && HussarUtils.isNotEmpty((Object)(codeRuleId = this.sysCodeRuleMapper.getRuleCodeId(sysCodeSaveDto.getCodeRuleCode())))) {
            return ApiResponse.fail((String)"\u8be5\u7f16\u7801\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        String codeRule = StringUtils.trimToEmpty((String)sysCodeSaveDto.getCodeRuleCode());
        String codeRuleName = StringUtils.trimToEmpty((String)sysCodeSaveDto.getCodeRuleName());
        String codeRuleDesc = StringUtils.trimToEmpty((String)sysCodeSaveDto.getCodeRuleDesc());
        String sys = sysCodeSaveDto.getSys();
        String level = sysCodeSaveDto.getLevel();
        sysCodeRule.setId(Long.valueOf(IdWorker.getId((Object)sysCodeSaveDto)));
        sysCodeRule.setCodeRuleCode(codeRule);
        if (HussarUtils.isNotEmpty((Object)codeRuleName)) {
            sysCodeRule.setCodeRuleName(codeRuleName);
        }
        if (HussarUtils.isNotEmpty((Object)codeRuleDesc)) {
            sysCodeRule.setCodeRuleDesc(codeRuleDesc);
        }
        if (HussarUtils.isNotEmpty((Object)sys)) {
            sysCodeRule.setSys(sys);
        }
        if (HussarUtils.isNotEmpty((Object)level)) {
            sysCodeRule.setCodeRuleLevel(level);
        }
        this.sysCodeRuleService.save((Object)sysCodeRule);
        List sysCodeRuleConfigList = sysCodeSaveDto.getSysCodeRuleConfigList();
        if (HussarUtils.isNotEmpty((Object)sysCodeRuleConfigList)) {
            ArrayList<SysCodeRuleInfo> sysCodeRuleInfoList = new ArrayList<SysCodeRuleInfo>();
            for (int i = 0; i < sysCodeRuleConfigList.size(); ++i) {
                SysCodeRuleConfigDto sysCodeRuleConfigDto = (SysCodeRuleConfigDto)sysCodeRuleConfigList.get(i);
                Long codeRuleInfoId = sysCodeRuleConfigDto.getCodeRuleInfoId();
                String elementType = StringUtils.trimToEmpty((String)sysCodeRuleConfigDto.getElementType());
                SysCodeRuleInfo temp = new SysCodeRuleInfo();
                temp.setCodeRuleSort(Integer.valueOf(i + 1));
                temp.setCodeRuleId(sysCodeRule.getId());
                temp.setResetPeriod(StringUtils.isNotBlank((CharSequence)sysCodeRuleConfigDto.getResetPeriod()) ? sysCodeRuleConfigDto.getResetPeriod() : "1");
                temp.setElementType(sysCodeRuleConfigDto.getElementType());
                temp.setElementPattern(sysCodeRuleConfigDto.getElementPattern());
                temp.setSerialNumberLength(sysCodeRuleConfigDto.getSerialNumberLength());
                if (elementType.equals("serialNumber") && sysCodeRuleConfigDto.getSerialNumberStart() == null) {
                    temp.setSerialNumberStart(Long.valueOf(1L));
                } else {
                    temp.setSerialNumberStart(sysCodeRuleConfigDto.getSerialNumberStart());
                }
                if (codeRuleInfoId != null) {
                    temp.setId(codeRuleInfoId);
                }
                sysCodeRuleInfoList.add(temp);
            }
            this.sysCodeRuleInfoService.saveBatch(sysCodeRuleInfoList);
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @HussarTransactional
    public ApiResponse<String> updateCodeRule(SysCodeUpdateDto sysCodeUpdateDto) {
        String ruleCodeId;
        String oldRuleCode = this.sysCodeRuleMapper.getRuleCode(sysCodeUpdateDto.getCodeRuleId());
        this.sysCodeRuleRefService.updateBeforeRuleChanged(oldRuleCode);
        String codeRule = StringUtils.trimToEmpty((String)sysCodeUpdateDto.getCodeRuleCode());
        String codeRuleName = StringUtils.trimToEmpty((String)sysCodeUpdateDto.getCodeRuleName());
        String codeRuleDesc = StringUtils.trimToEmpty((String)sysCodeUpdateDto.getCodeRuleDesc());
        String sys = sysCodeUpdateDto.getSys();
        String level = sysCodeUpdateDto.getLevel();
        if (HussarUtils.isEmpty((Object)codeRule)) {
            throw new BaseException("\u7f16\u7801\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!codeRule.equals(oldRuleCode) && HussarUtils.isNotEmpty((Object)(ruleCodeId = this.sysCodeRuleMapper.getRuleCodeId(codeRule)))) {
            throw new BaseException("\u8be5\u7f16\u7801\u6807\u8bc6\u5df2\u5b58\u5728\uff01");
        }
        SysCodeRule sysCodeRule = new SysCodeRule();
        sysCodeRule.setId(sysCodeUpdateDto.getCodeRuleId());
        sysCodeRule.setCodeRuleCode(codeRule);
        if (HussarUtils.isNotBlank((CharSequence)codeRuleName)) {
            sysCodeRule.setCodeRuleName(sysCodeUpdateDto.getCodeRuleName());
        }
        if (HussarUtils.isNotBlank((CharSequence)codeRuleDesc)) {
            sysCodeRule.setCodeRuleDesc(codeRuleDesc);
        }
        if (HussarUtils.isNotBlank((CharSequence)sys)) {
            sysCodeRule.setSys(sys);
        }
        if (HussarUtils.isNotBlank((CharSequence)level)) {
            sysCodeRule.setCodeRuleLevel(level);
        }
        this.sysCodeRuleService.updateById((Object)sysCodeRule);
        List sysCodeRuleConfigList = sysCodeUpdateDto.getSysCodeRuleConfigList();
        AssertUtil.isNotEmpty((Collection)sysCodeRuleConfigList, (String)"\u7f16\u7801\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList<SysCodeRuleInfo> sysCodeRuleInfoList = new ArrayList<SysCodeRuleInfo>();
        List configList = sysCodeRuleConfigList.stream().filter(item -> item.getCodeRuleInfoId() != null).collect(Collectors.toList());
        ArrayList<Long> updateIds = new ArrayList();
        if (HussarUtils.isNotEmpty(configList)) {
            Map map = EntityUtils.toMap(configList, SysCodeRuleConfigDto::getCodeRuleInfoId);
            List sysCodeRuleInfos = this.sysCodeRuleInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysCodeRuleInfo::getId, map.keySet())).eq(SysCodeRuleInfo::getCodeRuleId, (Object)sysCodeUpdateDto.getCodeRuleId()));
            List deleteList = this.sysCodeRuleInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(SysCodeRuleInfo::getId, map.keySet())).eq(SysCodeRuleInfo::getCodeRuleId, (Object)sysCodeUpdateDto.getCodeRuleId()));
            Map<Long, Object> configMap = new HashMap<Long, SysCodeRuleInfo>();
            if (HussarUtils.isNotEmpty((Object)sysCodeRuleInfos)) {
                updateIds = sysCodeRuleInfos.stream().map(item -> item.getId()).collect(Collectors.toList());
                configMap = EntityUtils.toMap((Collection)sysCodeRuleInfos, SysCodeRuleInfo::getId);
            }
            if (HussarUtils.isNotEmpty((Object)deleteList)) {
                this.sysCodeRuleInfoService.removeByIds((Collection)deleteList);
            }
            this.initCodeRuleInfo(sysCodeRule, sysCodeRuleConfigList, sysCodeRuleInfoList, updateIds, configMap);
            this.sysCodeRuleInfoService.saveOrUpdateBatch(sysCodeRuleInfoList);
        } else {
            this.sysCodeRuleInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(SysCodeRuleInfo::getCodeRuleId, (Object)sysCodeUpdateDto.getCodeRuleId()));
            this.initCodeRuleInfo(sysCodeRule, sysCodeRuleConfigList, sysCodeRuleInfoList, null, null);
            this.sysCodeRuleInfoService.saveOrUpdateBatch(sysCodeRuleInfoList);
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    private void initCodeRuleInfo(SysCodeRule sysCodeRule, List<SysCodeRuleConfigDto> sysCodeRuleConfigList, List<SysCodeRuleInfo> sysCodeRuleInfoList, List<Long> updateIds, Map<Long, SysCodeRuleInfo> oldConfigMap) {
        for (int i = 0; i < sysCodeRuleConfigList.size(); ++i) {
            SysCodeRuleConfigDto sysCodeRuleConfigDto = sysCodeRuleConfigList.get(i);
            String elementType = StringUtils.trimToEmpty((String)sysCodeRuleConfigDto.getElementType());
            String elementPattern = sysCodeRuleConfigDto.getElementPattern();
            Integer serialNumberLength = sysCodeRuleConfigDto.getSerialNumberLength();
            Long serialNumberStart = sysCodeRuleConfigDto.getSerialNumberStart();
            String resetPeriod = StringUtils.isNotBlank((CharSequence)sysCodeRuleConfigDto.getResetPeriod()) ? sysCodeRuleConfigDto.getResetPeriod() : "1";
            Long codeRuleInfoId = sysCodeRuleConfigDto.getCodeRuleInfoId();
            SysCodeRuleInfo temp = new SysCodeRuleInfo();
            if (HussarUtils.isNotEmpty(updateIds)) {
                boolean updateFlag;
                boolean bl = updateFlag = codeRuleInfoId != null && updateIds.contains(codeRuleInfoId);
                if (updateFlag) {
                    temp.setId(codeRuleInfoId);
                    temp.setSerialNumberCode(oldConfigMap.get(codeRuleInfoId).getSerialNumberCode());
                }
            }
            temp.setCodeRuleSort(Integer.valueOf(i + 1));
            temp.setCodeRuleId(sysCodeRule.getId());
            temp.setResetPeriod(resetPeriod);
            temp.setElementType(elementType);
            temp.setElementPattern(elementPattern);
            temp.setSerialNumberLength(serialNumberLength);
            if (elementType.equals("serialNumber") && serialNumberStart == null) {
                temp.setSerialNumberStart(Long.valueOf(1L));
            } else {
                temp.setSerialNumberStart(serialNumberStart);
            }
            sysCodeRuleInfoList.add(temp);
        }
    }

    @HussarTransactional
    public ApiResponse<String> deleteCodeRule(List<Long> codeRuleIds) {
        if (HussarUtils.isEmpty(codeRuleIds)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u5220\u9664\uff01");
        }
        for (Long codeRuleId : codeRuleIds) {
            String ruleCode = this.sysCodeRuleMapper.getRuleCode(codeRuleId);
            this.sysCodeRuleRefService.updateBeforeRuleChanged(ruleCode);
            String isSys = this.sysCodeRuleMapper.getIsSys(codeRuleId);
            if (!"1".equals(isSys)) continue;
            return ApiResponse.fail((String)(ruleCode + "\u4e3a\u7cfb\u7edf\u89c4\u5219\uff0c\u4e0d\u53ef\u5220\u9664\uff01"));
        }
        if (!this.removeByIds(codeRuleIds)) {
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff01");
        }
        this.sysCodeRuleInfoMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysCodeRuleInfo::getCodeRuleId, codeRuleIds));
        this.sysCodeRuleIsLevelMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysCodeRuleIsLevel::getIdtableId, codeRuleIds));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<String> saveOldToNew() {
        List<SysIdtable> sysIdtableList = this.sysCodeRuleMapper.listSysIdtable();
        ArrayList<SysCodeSaveDto> sysCodeDTOList = new ArrayList<SysCodeSaveDto>();
        for (SysIdtable sysIdtable : sysIdtableList) {
            SysCodeRuleConfigDto sysCodeRuleConfigDto;
            SysCodeSaveDto sysCodeSaveDto = new SysCodeSaveDto();
            ArrayList sysCodeRuleConfigList = new ArrayList();
            sysCodeSaveDto.setCodeRuleCode(sysIdtable.getTableName() + ":" + sysIdtable.getFieldName());
            if (HussarUtils.isNotEmpty((Object)sysIdtable.getIdDesc())) {
                sysCodeSaveDto.setCodeRuleName(sysIdtable.getIdDesc());
                sysCodeSaveDto.setCodeRuleDesc(sysIdtable.getIdDesc());
            }
            if (HussarUtils.isNotEmpty((Object)sysIdtable.getIsSys())) {
                sysCodeSaveDto.setSys(sysIdtable.getIsSys());
            }
            if (HussarUtils.isNotEmpty((Object)sysIdtable.getIsLevel())) {
                sysCodeSaveDto.setLevel(sysIdtable.getIsLevel());
            }
            if ("1".equals(sysIdtable.getIsPrefix())) {
                sysCodeRuleConfigDto = new SysCodeRuleConfigDto();
                if (sysIdtable.getIdPrefix().indexOf("[") == 0 && sysIdtable.getIdPrefix().indexOf("]") == sysIdtable.getIdPrefix().length() - 1) {
                    sysCodeRuleConfigDto.setElementType("codeDateTime");
                } else {
                    sysCodeRuleConfigDto.setElementType("constant");
                }
                sysCodeRuleConfigDto.setElementPattern(sysIdtable.getIdPrefix());
                sysCodeRuleConfigList.add(sysCodeRuleConfigDto);
            }
            if (HussarUtils.isNotEmpty((Object)sysIdtable.getCacheSize()) && HussarUtils.isNotEmpty((Object)sysIdtable.getIdValue())) {
                sysCodeRuleConfigDto = new SysCodeRuleConfigDto();
                sysCodeRuleConfigDto.setElementType("serialNumber");
                sysCodeRuleConfigDto.setElementPattern(sysIdtable.getCacheSize().toString());
                sysCodeRuleConfigDto.setSerialNumberLength(sysIdtable.getIdLength());
                sysCodeRuleConfigDto.setSerialNumberCode(Long.valueOf((long)sysIdtable.getIdValue().intValue() + 0L));
                sysCodeRuleConfigDto.setSerialNumberStart(Long.valueOf(1L));
                sysCodeRuleConfigDto.setResetPeriod("1");
                sysCodeRuleConfigList.add(sysCodeRuleConfigDto);
            }
            if ("1".equals(sysIdtable.getIsSuffix())) {
                sysCodeRuleConfigDto = new SysCodeRuleConfigDto();
                sysCodeRuleConfigDto.setElementType("constant");
                sysCodeRuleConfigDto.setElementPattern(sysIdtable.getIdSuffix());
                sysCodeRuleConfigList.add(sysCodeRuleConfigDto);
            }
            sysCodeSaveDto.setSysCodeRuleConfigList((List)sysCodeRuleConfigList);
            sysCodeDTOList.add(sysCodeSaveDto);
        }
        if (sysCodeDTOList.size() != sysIdtableList.size()) {
            return ApiResponse.fail((String)"\u8fc1\u79fb\u5931\u8d25\uff01");
        }
        int count = 0;
        for (SysCodeSaveDto sysCodeSaveDto : sysCodeDTOList) {
            this.saveCodeRule(sysCodeSaveDto);
            ++count;
        }
        if (count != sysCodeDTOList.size()) {
            return ApiResponse.fail((String)"\u8fc1\u79fb\u5931\u8d25\uff01");
        }
        List<SysIdtableInfo> list = this.sysCodeRuleMapper.listSysIdtableInfo();
        ArrayList<SysCodeRuleIsLevel> sysCodeRuleIsLevelList = new ArrayList<SysCodeRuleIsLevel>();
        if (HussarUtils.isNotEmpty(list)) {
            for (SysIdtableInfo sysIdtableInfo : list) {
                SysCodeRuleIsLevel sysCodeRuleIsLevel = new SysCodeRuleIsLevel();
                sysCodeRuleIsLevel.setId(sysIdtableInfo.getId());
                if (HussarUtils.isNotEmpty((Object)sysIdtableInfo.getIdValue())) {
                    sysCodeRuleIsLevel.setIdValue(sysIdtableInfo.getIdValue());
                }
                if (HussarUtils.isNotEmpty((Object)sysIdtableInfo.getIdtableId())) {
                    sysCodeRuleIsLevel.setIdtableId(sysIdtableInfo.getIdtableId());
                }
                if (HussarUtils.isNotEmpty((Object)sysIdtableInfo.getParentNumber())) {
                    sysCodeRuleIsLevel.setParentNumber(sysIdtableInfo.getParentNumber());
                }
                sysCodeRuleIsLevelList.add(sysCodeRuleIsLevel);
            }
            boolean flag = this.sysCodeRulesIsLevel.saveOrUpdateBatch(sysCodeRuleIsLevelList);
            if (!flag) {
                return ApiResponse.fail((String)"\u65e7\u7248\u672c\u89c4\u5219\u5c42\u7ea7\u8868\u8fc1\u79fb\u5931\u8d25\uff01");
            }
        }
        return ApiResponse.success((String)"\u8fc1\u79fb\u6210\u529f\uff01");
    }

    @HussarTransactional
    public String getCurrentCode(CodePlusDto codePlusDto) {
        String ruleCode = codePlusDto.getRuleCode();
        String level = codePlusDto.getLevel();
        if (HussarUtils.isBlank((CharSequence)level)) {
            level = "0";
        }
        if (level.equalsIgnoreCase("1")) {
            String parentNumber = codePlusDto.getParentNumber();
            return this.sysCodeRuleRefService.getCurrentCodeByParentNumber(ruleCode, parentNumber);
        }
        return this.sysCodeRuleRefService.getCurrentCode(codePlusDto);
    }

    @HussarTransactional
    public List<String> getBatchCurrentCodes(List<CodePlusDto> codePlusDtoList) {
        ArrayList<String> result = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(codePlusDtoList)) {
            for (CodePlusDto codePlusDto : codePlusDtoList) {
                result.add(this.getCurrentCode(codePlusDto));
            }
        }
        return result;
    }

    @HussarTransactional
    public ApiResponse<String> resetSerialNumber(String ruleCode) {
        SysCodeRule sysCodeRule = (SysCodeRule)this.sysCodeRuleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysCodeRule::getCodeRuleCode, (Object)ruleCode));
        AssertUtil.isNotNull((Object)sysCodeRule, (String)"\u672a\u67e5\u8be2\u5230\u6b64\u7f16\u7801\u89c4\u5219\uff01");
        List sysCodeRuleInfoList = this.sysCodeRuleInfoMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysCodeRuleInfo::getCodeRuleId, (Object)sysCodeRule.getId()));
        if (HussarUtils.isEmpty((Object)sysCodeRuleInfoList)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u6b64\u7f16\u7801\u89c4\u5219\uff01");
        }
        this.sysCodeRuleRefService.updateScheduled();
        for (SysCodeRuleInfo sysCodeRuleInfo : sysCodeRuleInfoList) {
            if (!StringUtils.isNotBlank((CharSequence)sysCodeRuleInfo.getElementType()) || !sysCodeRuleInfo.getElementType().equals("serialNumber")) continue;
            sysCodeRuleInfo.setSerialNumberCode(null);
            String key = sysCodeRule.getCodeRuleCode() + "ruleCodeSet";
            HussarCacheUtil.evict((String)"codePlusCacheName", (Object)key);
        }
        this.sysCodeRuleInfoService.updateBatchById((Collection)sysCodeRuleInfoList);
        return ApiResponse.success((String)"\u91cd\u7f6e\u6d41\u6c34\u53f7\u6210\u529f\uff01");
    }

    public ApiResponse<Long> getSerialNumberCode(String ruleCode) {
        SysCodeRule sysCodeRule = (SysCodeRule)this.sysCodeRuleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysCodeRule::getCodeRuleCode, (Object)ruleCode));
        AssertUtil.isNotNull((Object)sysCodeRule, (String)"\u672a\u67e5\u8be2\u5230\u6b64\u7f16\u7801\u89c4\u5219\uff01");
        List sysCodeRuleInfoList = this.sysCodeRuleInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCodeRuleInfo::getCodeRuleId, (Object)sysCodeRule.getId())).eq(SysCodeRuleInfo::getElementType, (Object)"serialNumber")).orderByDesc(SysCodeRuleInfo::getCodeRuleSort));
        if (HussarUtils.isEmpty((Object)sysCodeRuleInfoList)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u6b64\u7f16\u7801\u89c4\u5219\u542b\u6709\u6d41\u6c34\u53f7\u7c7b\u578b\u7684\u7f16\u7801\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        SysCodeRuleInfo sysCodeRuleInfo = (SysCodeRuleInfo)sysCodeRuleInfoList.get(0);
        return ApiResponse.success((Object)sysCodeRuleInfo.getSerialNumberCode());
    }

    public String getCurrentCodeByCache(CodePlusDto codePlusDto) {
        String ruleCode = codePlusDto.getRuleCode();
        String level = codePlusDto.getLevel();
        if (HussarUtils.isBlank((CharSequence)level)) {
            level = "0";
        }
        if (level.equalsIgnoreCase("1")) {
            String parentNumber = codePlusDto.getParentNumber();
            return this.sysCodeRuleRefService.getCurrentCodeByParentNumberCache(ruleCode, parentNumber);
        }
        return this.sysCodeRuleRefService.getCurrentCodeByCache(codePlusDto);
    }

    public void updateCacheToDb(CodePlusDto codePlusDto) {
        this.sysCodeRuleRefService.updateCacheToDb(codePlusDto);
    }
}

