/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.code.plus.utils;

import com.jxdinfo.hussar.code.plus.enums.TipConstantsEnum;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.utils.TranslateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionLock {
    private final Logger logger = LoggerFactory.getLogger(DistributionLock.class);
    private final String ruleCodeLock;
    private final String ruleCodeLockValue;
    private final int timeoutSecond;

    public DistributionLock(String ruleCode) {
        this.ruleCodeLock = "ruleCodeLock" + ruleCode;
        this.ruleCodeLockValue = String.valueOf((int)(Math.random() * 100000.0) + 1);
        this.timeoutSecond = 30;
    }

    public void lock() {
        try {
            String s;
            boolean isRuleCodeLock = HussarCacheUtil.containKey((String)"codePlusCacheName", (Object)this.ruleCodeLock);
            int k = 0;
            while (isRuleCodeLock) {
                this.logger.info("\u52a0\u9501\u91cd\u8bd5\u7b2c{}\u6b21\uff01", (Object)(++k));
                Thread.sleep(2000L);
                isRuleCodeLock = HussarCacheUtil.containKey((String)"codePlusCacheName", (Object)this.ruleCodeLock);
                if (isRuleCodeLock && k >= 3) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_LOCK_FAILED_PROGRAM_USING_INTERFACE.getMessage()));
                }
                if (isRuleCodeLock) continue;
            }
            if (!this.ruleCodeLockValue.equals(s = (String)HussarCacheUtil.putIfAbsent((String)"codePlusCacheName", (Object)this.ruleCodeLock, (Object)this.ruleCodeLockValue, (long)this.timeoutSecond))) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CODE_LOCK_FAILED_NOT_OCCUPY.getMessage()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    public void release() {
        try {
            boolean isTrue = HussarCacheUtil.containKey((String)"codePlusCacheName", (Object)this.ruleCodeLock);
            if (isTrue) {
                String s = HussarCacheUtil.get((String)"codePlusCacheName", (Object)this.ruleCodeLock).toString();
                if (this.ruleCodeLockValue.equals(s)) {
                    HussarCacheUtil.evict((String)"codePlusCacheName", (Object)this.ruleCodeLock);
                } else {
                    this.logger.error("\u4e0d\u80fd\u89e3\u9664\u4ed6\u4eba\u7684\u9501\uff01");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u9501\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    public String toString() {
        return "DistributionLock-" + this.ruleCodeLock;
    }
}

