/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.extend.server.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.cloud.common.core.constant.CommonConstants;
import com.jxdinfo.hussar.cloud.extend.api.user.dto.SaasUserLoginDto;
import com.jxdinfo.hussar.cloud.extend.api.user.model.SecurityUser;
import com.jxdinfo.hussar.cloud.extend.api.user.service.SaasUserLoginService;
import com.jxdinfo.hussar.common.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.properties.GlobalProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.enums.UserStatus;
import com.jxdinfo.hussar.organ.service.ISysStruService;
import com.jxdinfo.hussar.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.permit.model.SysUsers;
import com.jxdinfo.hussar.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.permit.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SaasUserLoginServiceImpl
implements SaasUserLoginService {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;

    public ApiResponse<SecurityUser> querySaasLoginUserInfo(SaasUserLoginDto saasUserLoginDto) {
        String username = saasUserLoginDto.getUsername();
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)username)).eq(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode()), false);
        if (ToolUtil.isNotEmpty((Object)sysUsers)) {
            return ApiResponse.success((Object)this.getLoginSecurityUser(sysUsers));
        }
        throw new HussarException("\u672a\u627e\u5230\u7528\u6237");
    }

    private SecurityUser getLoginSecurityUser(SysUsers sysUsers) {
        String connName;
        SecurityUser securityUser = new SecurityUser();
        if (this.globalProperties.isTenantOpen() && ToolUtil.isNotEmpty((Object)(connName = this.dynamicDataSourceService.currentDsName()))) {
            SysTenant tenant;
            securityUser.setConnName(connName);
            if ("master".equals(connName)) {
                securityUser.setTenantCode("000000");
                tenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new QueryWrapper().eq((Object)"TENANT_CODE", (Object)"000000"));
                if (ToolUtil.isNotEmpty((Object)tenant)) {
                    securityUser.setTenantId(String.valueOf(tenant.getId()));
                    securityUser.setTenantName(tenant.getTenantName());
                    securityUser.setTenantCipher(String.valueOf(tenant.getBpmTenantCipher()));
                }
            } else {
                tenant = this.sysTenantService.queryTenantByConnName(connName);
                if (ToolUtil.isNotEmpty((Object)tenant)) {
                    securityUser.setTenantCode(tenant.getTenantCode());
                    securityUser.setTenantId(String.valueOf(tenant.getId()));
                    securityUser.setTenantCipher(String.valueOf(tenant.getBpmTenantCipher()));
                }
            }
        }
        securityUser.setId(sysUsers.getId());
        securityUser.setAccount(sysUsers.getUserAccount());
        securityUser.setDeptId(sysUsers.getDepartmentId());
        securityUser.setEmployeeId(sysUsers.getEmployeeId());
        securityUser.setDeptName(this.getDeptName(sysUsers.getDepartmentId()));
        securityUser.setName(sysUsers.getUserName());
        securityUser.setSecurityLevel(sysUsers.getSecurityLevel());
        securityUser.setAccountStatus(sysUsers.getAccountStatus());
        securityUser.setPassword(sysUsers.getPassword());
        List<Long> rolesList = this.getRolesIdByUserId(sysUsers.getId());
        Long employeeId = sysUsers.getEmployeeId();
        Long departmentId = sysUsers.getDepartmentId();
        if (ToolUtil.isNotEmpty((Object)employeeId) && ToolUtil.isNotEmpty((Object)departmentId)) {
            List<Long> roleList = this.getRolesIdByStruId(sysUsers.getDepartmentId());
            rolesList.addAll(roleList);
        }
        securityUser.setRolesList(rolesList);
        if (ToolUtil.isEmpty((Object)securityUser.getTenantId())) {
            securityUser.setTenantId(Long.toString(CommonConstants.TENANT_ID_1));
        }
        if (ToolUtil.isNotEmpty(rolesList)) {
            List<String> permissionList = this.getPermissionByRoleIds(rolesList);
            securityUser.setPermissionList(permissionList);
        }
        if (HussarUtils.isNotEmpty((Object)securityUser)) {
            HussarCacheUtil.put((String)"security_user", (Object)securityUser.getAccount(), (Object)JSON.toJSONString((Object)securityUser));
        }
        return securityUser;
    }

    private String getDeptName(Long deptId) {
        SysOrganVo dept = this.iSysStruService.getOrgInfoByOrgId(deptId);
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    private List<Long> getRolesIdByUserId(Long userId) {
        return this.iSysUserRoleService.getRolesByUserId(userId);
    }

    private List<Long> getRolesIdByStruId(Long struId) {
        return this.iSysStruRoleService.getRolesByStruId(struId);
    }

    private List<String> getPermissionByRoleIds(List<Long> roleList) {
        return this.sysResourcesService.queryPermissionsByRoleIds(roleList);
    }
}

