/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.extend.server.route.controller;

import com.jxdinfo.hussar.cloud.extend.api.route.model.SysRouteConf;
import com.jxdinfo.hussar.cloud.extend.api.route.service.SysRouteConfService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/route"})
@Api(value="route", tags={"\u52a8\u6001\u8def\u7531\u7ba1\u7406\u6a21\u5757"})
public class SysRouteConfController {
    @Autowired
    private SysRouteConfService sysRouteConfService;

    @ApiOperation(value="\u83b7\u53d6\u8def\u7531\u96c6\u5408", notes="\u83b7\u53d6\u8def\u7531\u96c6\u5408")
    @GetMapping(value={"/list"})
    public ApiResponse<List<SysRouteConf>> listRoutes() {
        return ApiResponse.success((Object)this.sysRouteConfService.list());
    }

    @ApiOperation(value="\u4fee\u6539\u8def\u7531", notes="\u4fee\u6539\u8def\u7531")
    @ApiImplicitParam(name="route", value="\u8def\u7531\u4fe1\u606f", required=true, paramType="body")
    @PostMapping(value={"/updateRoute"})
    public ApiResponse<Boolean> updateRoute(@RequestBody SysRouteConf route) {
        return ApiResponse.success((Object)this.sysRouteConfService.updateRoute(route));
    }

    @ApiOperation(value="\u65b0\u589e\u8def\u7531", notes="\u65b0\u589e\u8def\u7531")
    @ApiImplicitParam(name="route", value="\u8def\u7531\u4fe1\u606f", required=true, paramType="body")
    @PostMapping(value={"/addRoute"})
    public ApiResponse<Boolean> addRoute(@RequestBody SysRouteConf route) {
        return ApiResponse.success((Object)this.sysRouteConfService.saveRoute(route));
    }

    @ApiOperation(value="\u5220\u9664\u8def\u7531", notes="\u5220\u9664\u8def\u7531")
    @ApiImplicitParam(name="routeId", value="\u8def\u7531ID", required=true, paramType="form")
    @PostMapping(value={"/delRoute"})
    public ApiResponse<Boolean> delRoute(@RequestBody String routeId) {
        return ApiResponse.success((Object)this.sysRouteConfService.deleteRoute(routeId));
    }

    @ApiOperation(value="\u67e5\u770b\u8def\u7531\u8be6\u60c5", notes="\u67e5\u770b\u8def\u7531\u8be6\u60c5")
    @ApiImplicitParam(name="routeId", value="\u8def\u7531id", required=true, paramType="query")
    @GetMapping(value={"/getRouteDetail"})
    public ApiResponse<SysRouteConf> getRouteDetail(String routeId) {
        return ApiResponse.success((Object)this.sysRouteConfService.getRouteDetail(routeId));
    }

    @ApiOperation(value="\u67e5\u770b\u8def\u7531id\u662f\u5426\u5df2\u5b58\u5728", notes="\u67e5\u770b\u8def\u7531id\u662f\u5426\u5df2\u5b58\u5728")
    @ApiImplicitParam(name="routeId", value="\u8def\u7531id", required=true, paramType="query")
    @GetMapping(value={"/checkRouteId"})
    public ApiResponse<Boolean> checkRouteId(String routeId) {
        return ApiResponse.success((Object)this.sysRouteConfService.queryRouteIdIsExist(routeId));
    }
}

