/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.extend.server.client.service.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.cloud.extend.api.client.dto.SysOauthClientDetailsDTO;
import com.jxdinfo.hussar.cloud.extend.api.client.model.SysOauthClientDetails;
import com.jxdinfo.hussar.cloud.extend.api.client.service.SysOauthClientDetailsService;
import com.jxdinfo.hussar.cloud.extend.server.client.config.ClientDetailsInitRunner;
import com.jxdinfo.hussar.cloud.extend.server.client.dao.SysOauthClientDetailsMapper;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysOauthClientDetailsServiceImpl
extends ServiceImpl<SysOauthClientDetailsMapper, SysOauthClientDetails>
implements SysOauthClientDetailsService {
    @Autowired
    private RedisTemplate redisTemplate;

    @CacheEvict(value={"hussar_oauth:client:details"}, key="#clientId")
    public Boolean removeByClientId(String clientId) {
        ((SysOauthClientDetailsMapper)this.baseMapper).delete((Wrapper)Wrappers.lambdaQuery().eq(SysOauthClientDetails::getClientId, (Object)clientId));
        SpringContextUtil.publishEvent((ApplicationEvent)new ClientDetailsInitRunner.ClientDetailsInitEvent(clientId));
        return Boolean.TRUE;
    }

    @CacheEvict(value={"hussar_oauth:client:details"}, key="#clientDetailsDTO.clientId")
    public Boolean updateClientById(SysOauthClientDetailsDTO clientDetailsDTO) {
        SysOauthClientDetails clientDetails = new SysOauthClientDetails();
        BeanUtils.copyProperties((Object)clientDetailsDTO, (Object)clientDetails);
        String information = clientDetailsDTO.getAdditionalInformation();
        JSONObject informationObj = JSONUtil.parseObj((String)information).set("captcha_flag", (Object)clientDetailsDTO.getCaptchaFlag()).set("enc_flag", (Object)clientDetailsDTO.getEncFlag());
        clientDetails.setAdditionalInformation(informationObj.toString());
        ((SysOauthClientDetailsMapper)this.baseMapper).updateById(clientDetails);
        SpringContextUtil.publishEvent((ApplicationEvent)new ClientDetailsInitRunner.ClientDetailsInitEvent(clientDetails));
        return Boolean.TRUE;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean saveClient(SysOauthClientDetailsDTO clientDetailsDTO) {
        SysOauthClientDetails clientDetails = new SysOauthClientDetails();
        BeanUtils.copyProperties((Object)clientDetailsDTO, (Object)clientDetails);
        String information = clientDetailsDTO.getAdditionalInformation();
        JSONUtil.parseObj((String)information).set("captcha_flag", (Object)clientDetailsDTO.getCaptchaFlag()).set("enc_flag", (Object)clientDetailsDTO.getEncFlag());
        ((SysOauthClientDetailsMapper)this.baseMapper).insert(clientDetails);
        SpringContextUtil.publishEvent((ApplicationEvent)new ClientDetailsInitRunner.ClientDetailsInitEvent(clientDetails));
        return Boolean.TRUE;
    }

    public Page queryPage(Page page, SysOauthClientDetails query) {
        Page selectPage = (Page)((SysOauthClientDetailsMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)Wrappers.query((Object)query));
        List collect = selectPage.getRecords().stream().map(details -> {
            String information = details.getAdditionalInformation();
            String captchaFlag = JSONUtil.parseObj((String)information).getStr((Object)"captcha_flag");
            String encFlag = JSONUtil.parseObj((String)information).getStr((Object)"enc_flag");
            SysOauthClientDetailsDTO dto = new SysOauthClientDetailsDTO();
            BeanUtils.copyProperties((Object)details, (Object)dto);
            dto.setCaptchaFlag(captchaFlag);
            dto.setEncFlag(encFlag);
            return dto;
        }).collect(Collectors.toList());
        Page dtoPage = new Page(page.getCurrent(), page.getSize(), selectPage.getTotal());
        dtoPage.setRecords(collect);
        return dtoPage;
    }
}

