/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.extend.server.client.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.cloud.common.security.annotation.Inner;
import com.jxdinfo.hussar.cloud.extend.api.client.dto.SysOauthClientDetailsDTO;
import com.jxdinfo.hussar.cloud.extend.api.client.model.SysOauthClientDetails;
import com.jxdinfo.hussar.cloud.extend.api.client.service.SysOauthClientDetailsService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarClient"})
@Api(value="client", tags={"\u5ba2\u6237\u7aef\u7ba1\u7406\u6a21\u5757"})
public class SysClientController {
    @Autowired
    private SysOauthClientDetailsService clientDetailsService;

    @GetMapping(value={"/{clientId}"})
    public ApiResponse getByClientId(@PathVariable String clientId) {
        return ApiResponse.success((Object)this.clientDetailsService.list((Wrapper)Wrappers.lambdaQuery().eq(SysOauthClientDetails::getClientId, (Object)clientId)));
    }

    @GetMapping(value={"/page"})
    public ApiResponse getOauthClientDetailsPage(Page page, SysOauthClientDetails sysOauthClientDetails) {
        return ApiResponse.success((Object)this.clientDetailsService.queryPage(page, sysOauthClientDetails));
    }

    @PostMapping
    @PreAuthorize(value="@pms.hasPermission('sys_client_add')")
    public ApiResponse add(@Valid @RequestBody SysOauthClientDetailsDTO clientDetailsDTO) {
        return ApiResponse.success((Object)this.clientDetailsService.saveClient(clientDetailsDTO));
    }

    @DeleteMapping(value={"/{clientId}"})
    @PreAuthorize(value="@pms.hasPermission('sys_client_del')")
    public ApiResponse removeById(@PathVariable String clientId) {
        return ApiResponse.success((Object)this.clientDetailsService.removeByClientId(clientId));
    }

    @PutMapping
    @PreAuthorize(value="@pms.hasPermission('sys_client_edit')")
    public ApiResponse update(@Valid @RequestBody SysOauthClientDetailsDTO clientDetailsDTO) {
        return ApiResponse.success((Object)this.clientDetailsService.updateClientById(clientDetailsDTO));
    }

    @Inner(value=false)
    @GetMapping(value={"/getHussarClientDetailsById/{clientId}"})
    public ApiResponse getClientDetailsById(@PathVariable String clientId) {
        return ApiResponse.success((Object)this.clientDetailsService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysOauthClientDetails::getClientId, (Object)clientId), false));
    }
}

