/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cloud.extend.server.client.config;

import cn.hutool.core.util.StrUtil;
import com.jxdinfo.hussar.cloud.extend.api.client.service.SysOauthClientDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ClientDetailsInitRunner {
    private Logger log = LoggerFactory.getLogger(ClientDetailsInitRunner.class);
    @Autowired
    private SysOauthClientDetailsService clientDetailsService;
    @Autowired
    private RedisTemplate redisTemplate;

    @Async
    @Order
    @EventListener(value={WebServerInitializedEvent.class, ClientDetailsInitEvent.class})
    public void initClientDetails() {
        this.log.debug("\u521d\u59cb\u5316\u5ba2\u6237\u7aef\u4fe1\u606f\u5f00\u59cb ");
        this.clientDetailsService.list().stream().filter(client -> StrUtil.isNotBlank((CharSequence)client.getAdditionalInformation())).forEach(client -> {
            String key = String.format("%s:%s", "client_config_flag", client.getClientId());
            this.redisTemplate.opsForValue().set((Object)key, (Object)client.getAdditionalInformation());
        });
        this.log.debug("\u521d\u59cb\u5316\u5ba2\u6237\u7aef\u4fe1\u606f\u7ed3\u675f ");
    }

    public static class ClientDetailsInitEvent
    extends ApplicationEvent {
        public ClientDetailsInitEvent(Object source) {
            super(source);
        }
    }
}

