/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.cas.system.dao.CasApplicationGroupMapper;
import com.jxdinfo.hussar.cas.system.dao.CasApplicationMapper;
import com.jxdinfo.hussar.cas.system.dto.CasAppRoleGroupDto;
import com.jxdinfo.hussar.cas.system.model.CasApplication;
import com.jxdinfo.hussar.cas.system.model.CasApplicationGroup;
import com.jxdinfo.hussar.cas.system.service.ICasApplicationService;
import com.jxdinfo.hussar.cas.system.vo.CasApplicationVo;
import com.jxdinfo.hussar.cas.util.ForestNodeMerger;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.log.api.annotation.BussinessLog;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/casApplicationFront"})
@Api(tags={"\u7edf\u4e00\u6743\u9650\u7ba1\u7406"})
public class CasApplicationFrontController
extends BaseController {
    @Resource
    private ICasApplicationService casApplicationService;
    @Resource
    private CasApplicationGroupMapper casApplicationGroupMapper;
    @Resource
    private CasApplicationMapper casApplicationMapper;

    @GetMapping(value={"/lazyCasTree"})
    @ApiOperation(value="\u4e1a\u52a1\u7cfb\u7edf\u6811", notes="\u4e1a\u52a1\u7cfb\u7edf\u6811\u61d2\u52a0\u8f7d")
    @ApiImplicitParam(name="nodeId", value="\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4ID", required=true, paramType="query")
    @BussinessLog(key="/casApplicationFront/lazyCasTree", type="04", value="\u4e1a\u52a1\u7cfb\u7edf\u6811\u61d2\u52a0\u8f7d")
    public ApiResponse<List<JSTreeModel>> lazyCasTree(String nodeId) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.casApplicationService.getLazyCasTree(nodeId)));
    }

    @PostMapping(value={"/addCas"})
    @ApiOperation(value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf", notes="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf")
    @ApiImplicitParam(name="casApplication", value="\u4e1a\u52a1\u7cfb\u7edf\u5b9e\u4f53", required=true, paramType="body")
    @BussinessLog(key="/casApplicationFront/addCas", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf")
    public ApiResponse<CasApplication> addCas(@RequestBody CasApplication casApplication) {
        return this.casApplicationService.saveCasApplication(casApplication);
    }

    @PostMapping(value={"/editCas"})
    @ApiOperation(value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf", notes="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf")
    @ApiImplicitParam(name="casApplication", value="\u4e1a\u52a1\u7cfb\u7edf\u5b9e\u4f53", required=true, paramType="body")
    @BussinessLog(key="/casApplicationFront/editCas", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf")
    public ApiResponse<CasApplication> editCas(@RequestBody CasApplication casApplication) {
        return this.casApplicationService.updateCasApplication(casApplication);
    }

    @PostMapping(value={"/delCas"})
    @ApiOperation(value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf", notes="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf")
    @ApiImplicitParam(name="id", value="\u4e1a\u52a1\u7cfb\u7edfID", required=true, paramType="form")
    public ApiResponse<Tip> delCas(@RequestBody String id) {
        return this.casApplicationService.deleteCasApplication(id);
    }

    @GetMapping(value={"/casOrderTree"})
    @ApiOperation(value="\u4e1a\u52a1\u7cfb\u7edf\u6392\u5e8f\u6811", notes="\u52a0\u8f7d\u4e1a\u52a1\u7cfb\u7edf\u6392\u5e8f\u6811")
    @ApiImplicitParam(name="parentId", value="\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4ID", required=true, paramType="query")
    @BussinessLog(key="/casApplicationFront/casAddPage", type="04", value="\u52a0\u8f7d\u4e1a\u52a1\u7cfb\u7edf\u6392\u5e8f\u6811")
    public ApiResponse<List<JSTreeModel>> casOrderTree(String parentId) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.casApplicationService.getCasOrderTree(parentId)));
    }

    @PostMapping(value={"/saveCasOrder"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u7cfb\u7edf\u6392\u5e8f", notes="\u4fdd\u5b58\u4e1a\u52a1\u7cfb\u7edf\u6392\u5e8f")
    @ApiImplicitParam(name="info", value="\u6392\u5e8f\u4fe1\u606f", required=true, paramType="form")
    public ApiResponse<Tip> saveCasOrder(@RequestBody String info) {
        JSONArray treeArr = JSONArray.parseArray((String)info);
        return this.casApplicationService.updateCasOrder(treeArr);
    }

    @PostMapping(value={"/saveGroup"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4fe1\u606f", notes="\u4fdd\u5b58\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4fe1\u606f")
    @ApiImplicitParam(name="casAppRoleGroupDto", value="\u4e1a\u52a1\u7cfb\u7edf\u89d2\u8272\u5206\u7ec4Dto", required=true, paramType="body")
    @BussinessLog(key="/casApplicationFront/saveGroup", type="03", value="\u4fdd\u5b58\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4fe1\u606f")
    public ApiResponse<CasApplicationGroup> saveGroup(@RequestBody CasAppRoleGroupDto casAppRoleGroupDto) {
        String groupName = casAppRoleGroupDto.getGroupName();
        String type = casAppRoleGroupDto.getType();
        Long groupId = casAppRoleGroupDto.getId();
        if (ToolUtil.equals((Object)"add", (Object)type)) {
            return this.casApplicationService.saveGroup(groupName);
        }
        return this.casApplicationService.updateGroup(groupName, groupId);
    }

    @GetMapping(value={"/searchCasGroup"})
    @ApiOperation(value="\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4e0b\u7684\u4e1a\u52a1\u7cfb\u7edf", notes="\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4e0b\u7684\u4e1a\u52a1\u7cfb\u7edf")
    @ApiImplicitParam(name="id", value="\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4ID", required=true, paramType="query")
    @BussinessLog(key="/casApplicationFront/searchCasGroup", type="04", value="\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4e0b\u7684\u4e1a\u52a1\u7cfb\u7edf")
    public ApiResponse<List<CasApplication>> searchCasGroup(String id) {
        return this.casApplicationService.queryCasGroup(id);
    }

    @PostMapping(value={"/delGroup"})
    @ApiOperation(value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4", notes="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4")
    @ApiImplicitParam(name="id", value="\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4ID", required=true, paramType="form")
    public ApiResponse<Tip> delGroup(@RequestBody String id) {
        return this.casApplicationService.deleteCasGroup(id);
    }

    @GetMapping(value={"/groupOrderTree"})
    @ApiOperation(value="\u52a0\u8f7d\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u6392\u5e8f\u6811", notes="\u52a0\u8f7d\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u6392\u5e8f\u6811")
    @BussinessLog(key="/casApplicationFront/groupOrderTree", type="04", value="\u52a0\u8f7d\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u6392\u5e8f\u6811")
    public ApiResponse<List<JSTreeModel>> groupOrderTree() {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.casApplicationService.getGroupOrderTree()));
    }

    @PostMapping(value={"/saveGroupOrder"})
    @ApiOperation(value="\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u6392\u5e8f", notes="\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u6392\u5e8f")
    @ApiImplicitParam(name="info", value="\u6392\u5e8f\u4fe1\u606f", required=true, paramType="form")
    public ApiResponse<Tip> saveGroupOrder(@RequestBody String info) {
        JSONArray treeArr = JSONArray.parseArray((String)info);
        return this.casApplicationService.updateGroupOrder(treeArr);
    }

    @GetMapping(value={"/list_single"})
    @ApiOperation(value="\u4e1a\u52a1\u7cfb\u7edf\u5217\u8868", notes="\u4e1a\u52a1\u7cfb\u7edf\u5217\u8868\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="dicGroupDto", value="\u5b57\u5178\u5206\u7ec4\u5b9e\u4f53", required=true, paramType="query")})
    @BussinessLog(key="/casApplicationFront/list_single", type="04", value="\u4e1a\u52a1\u7cfb\u7edf\u5217\u8868")
    public ApiResponse<IPage<CasApplicationVo>> listSingle(Page<CasApplicationVo> page, CasApplicationGroup casApplicationGroup) {
        return ApiResponse.success((Object)this.casApplicationService.queryCasList(page, casApplicationGroup));
    }

    @GetMapping(value={"/casGroupPage"})
    @ApiOperation(value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4fe1\u606f", notes="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4fe1\u606f")
    @ApiImplicitParam(name="id", value="\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4ID", required=true, paramType="query")
    @BussinessLog(key="/casApplicationFront/casGroupPage", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4fe1\u606f")
    public ApiResponse<CasApplicationGroup> casAddGroupPage(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new HussarException("\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CasApplicationGroup group = (CasApplicationGroup)this.casApplicationGroupMapper.selectById((Serializable)((Object)id));
        return ApiResponse.success((Object)group);
    }

    @GetMapping(value={"/casSystemPage"})
    @ApiOperation(value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f", notes="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f")
    @ApiImplicitParam(name="id", value="\u4e1a\u52a1\u7cfb\u7edfID", required=true, paramType="query")
    @BussinessLog(key="/casApplicationFront/casSystemPage", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f")
    public ApiResponse<CasApplication> casAddSystemPage(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new HussarException("\u4e1a\u52a1\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CasApplication casApplication = (CasApplication)this.casApplicationMapper.selectById((Serializable)((Object)id));
        Long groupId = casApplication.getGroupId();
        CasApplicationGroup casApplicationGroup = (CasApplicationGroup)this.casApplicationGroupMapper.selectById(groupId);
        CasApplicationVo casApplicationVo = new CasApplicationVo();
        CopyPropertieUtils.copyProperties((Object)casApplicationVo, (Object)casApplication);
        casApplicationVo.setGroupName(casApplicationGroup.getGroupName());
        return ApiResponse.success((Object)casApplicationVo);
    }

    @GetMapping(value={"/testOnline"})
    @ApiOperation(value="\u6d4b\u8bd5\u662f\u5426\u5728\u7ebf", notes="\u6d4b\u8bd5\u662f\u5426\u5728\u7ebf")
    @ApiImplicitParam(name="applicationId", value="\u4e1a\u52a1\u7cfb\u7edfID", required=true, paramType="query")
    @BussinessLog(key="/casApplicationFront/testOnline", type="04", value="\u6d4b\u8bd5\u662f\u5426\u5728\u7ebf")
    public ApiResponse testOnline(String applicationId) throws Exception {
        CasApplication casApplication = (CasApplication)this.casApplicationService.getById((Serializable)((Object)applicationId));
        boolean ifOnline = this.casApplicationService.testOnline(casApplication);
        return ApiResponse.success((Object)ifOnline);
    }
}

