/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.messagepush.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.cas.cassync.model.CasSyncMessage;
import com.jxdinfo.hussar.cas.cassync.model.CasSyncMessageFail;
import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageFailService;
import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageService;
import com.jxdinfo.hussar.cas.messagepush.service.ServerMessageService;
import com.jxdinfo.hussar.cas.system.model.CasApplication;
import com.jxdinfo.hussar.cas.system.service.ICasApplicationService;
import com.jxdinfo.hussar.cas.util.SplitStrUtil;
import com.jxdinfo.hussar.common.constant.http.HttpCode;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.stereotype.Service;

@Service
public class ServerMessageServiceImpl
implements ServerMessageService {
    @Resource
    private AmqpTemplate rabbitTemplate;
    @Resource
    private RabbitAdmin rabbitAdmin;
    @Resource
    private ICasSyncMessageService casSyncMessageService;
    @Resource
    private ICasApplicationService casApplicationService;
    @Resource
    private ICasSyncMessageFailService casSyncMessageFailService;

    public Object integratePushMessage(CasSyncMessage casSyncMessage) {
        JSONObject object = new JSONObject();
        object.put("messageId", (Object)casSyncMessage.getId());
        object.put("messageData", (Object)new String(casSyncMessage.getMessageContent()));
        Long applicationId = casSyncMessage.getApplicationId();
        object.put("applicationId", (Object)applicationId);
        object.put("userId", (Object)BaseSecurityUtil.getUser().getId());
        if (ToolUtil.isNotEmpty((Object)applicationId)) {
            List list1 = this.casApplicationService.list(null);
            for (CasApplication casApplication : list1) {
                object.put("applicationId", (Object)casApplication.getId());
                Object returnObj = this.pushToMq(casSyncMessage, null, object, casApplication);
                if (ToolUtil.isEmpty((Object)returnObj)) continue;
                return returnObj;
            }
        } else {
            CasApplication casApplication = (CasApplication)this.casApplicationService.getById((Serializable)applicationId);
            Object returnObj = this.pushToMq(casSyncMessage, null, object, casApplication);
            if (!ToolUtil.isEmpty((Object)returnObj)) {
                return returnObj;
            }
        }
        return "";
    }

    private Object pushToMq(CasSyncMessage casSyncMessage, CasSyncMessageFail casSyncMessageFail, JSONObject object, CasApplication casApplication) {
        SplitStrUtil splitStrUtil = new SplitStrUtil();
        Object striArray = splitStrUtil.getStriArray(casApplication.getApplicationToken());
        if (!ToolUtil.isEmpty((Object)striArray)) {
            Map map = (Map)striArray;
            String routingkey = "routingKey" + (String)map.get("routingkey");
            String exchange = "exchange" + (String)map.get("exchange");
            String queue = "queue" + (String)map.get("queue");
            DirectExchange exchange1 = this.createExchange(exchange);
            this.addExchange((AbstractExchange)exchange1);
            Queue delayQueue = this.createQueue(queue);
            this.addQueue(delayQueue);
            this.addBinding(delayQueue, exchange1, routingkey);
            this.rabbitTemplate.convertAndSend(exchange, routingkey, (Object)object);
            if (!ToolUtil.isEmpty((Object)casSyncMessage)) {
                casSyncMessage.setMessageStatus("1");
                this.casSyncMessageService.updateById((Object)casSyncMessage);
            }
            if (!ToolUtil.isEmpty((Object)casSyncMessageFail)) {
                casSyncMessageFail.setMessageStatus("1");
                this.casSyncMessageFailService.updateById((Object)casSyncMessageFail);
            }
            return null;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5931\u8d25\uff01");
    }

    private DirectExchange createExchange(String exchangeName) {
        return new DirectExchange(exchangeName, true, false);
    }

    private Queue createQueue(String queue) {
        return new Queue(queue, true);
    }

    private void addExchange(AbstractExchange exchange) {
        this.rabbitAdmin.declareExchange((Exchange)exchange);
    }

    private void addQueue(Queue queue) {
        this.rabbitAdmin.declareQueue(queue);
    }

    private void addBinding(Queue queue, DirectExchange exchange, String routingKey) {
        Binding binding = BindingBuilder.bind((Queue)queue).to(exchange).with(routingKey);
        this.rabbitAdmin.declareBinding(binding);
    }
}

